/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.OrientationInterpolationTrajectoryGenerator;
import us.ihmc.robotics.trajectories.providers.FrameOrientationProvider;
import us.ihmc.robotics.trajectories.providers.SettableDoubleProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class OrientationInterpolationTrajectoryGeneratorTest {
    private String namePrefix = "namePrefixTEST";
    private FrameQuaternion orientation;
    private ReferenceFrame referenceFrame;
    private DoubleProvider trajectoryTimeProvider;
    private FrameOrientationProvider initialOrientationProvider;
    private FrameOrientationProvider finalOrientationProvider;
    private YoRegistry parentRegistry;
    private static final double EPSILON = 1.0E-10;
    private static double trajectoryTime = 10.0;
    private OrientationInterpolationTrajectoryGenerator generator;

    @BeforeEach
    public void setUp() {
        this.referenceFrame = ReferenceFrameTools.constructARootFrame((String)"rootFrameTEST");
        this.orientation = new FrameQuaternion(this.referenceFrame);
        this.trajectoryTimeProvider = new SettableDoubleProvider(trajectoryTime);
        this.initialOrientationProvider = () -> this.orientation;
        this.finalOrientationProvider = () -> this.orientation;
        this.parentRegistry = new YoRegistry("registry");
    }

    @AfterEach
    public void tearDown() {
        this.orientation = null;
        this.referenceFrame = null;
        this.trajectoryTimeProvider = null;
        this.initialOrientationProvider = null;
        this.finalOrientationProvider = null;
        this.parentRegistry = null;
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testConstructor() {
        try {
            this.generator = new OrientationInterpolationTrajectoryGenerator(this.namePrefix, this.referenceFrame, this.trajectoryTimeProvider, this.initialOrientationProvider, this.finalOrientationProvider, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.generator = new OrientationInterpolationTrajectoryGenerator(this.namePrefix, this.referenceFrame, this.trajectoryTimeProvider, this.initialOrientationProvider, this.finalOrientationProvider, this.parentRegistry);
    }

    @Test
    public void testIsDone() {
        this.generator = new OrientationInterpolationTrajectoryGenerator(this.namePrefix, this.referenceFrame, this.trajectoryTimeProvider, this.initialOrientationProvider, this.finalOrientationProvider, this.parentRegistry);
        this.generator.initialize();
        this.generator.setContinuouslyUpdateFinalOrientation(true);
        this.generator.compute(5.0);
        Assert.assertFalse(this.generator.isDone());
        this.generator.compute(trajectoryTime + 1.0E-10);
        Assert.assertTrue(this.generator.isDone());
    }

    @Test
    public void testGet() {
        this.generator = new OrientationInterpolationTrajectoryGenerator(this.namePrefix, this.referenceFrame, this.trajectoryTimeProvider, this.initialOrientationProvider, this.finalOrientationProvider, this.parentRegistry);
        Assert.assertEquals(this.referenceFrame, this.generator.getOrientation().getReferenceFrame());
    }

    @Test
    public void testPackAngularVelocity() {
        this.generator = new OrientationInterpolationTrajectoryGenerator(this.namePrefix, this.referenceFrame, this.trajectoryTimeProvider, this.initialOrientationProvider, this.finalOrientationProvider, this.parentRegistry);
        FrameVector3D angularVelocityToPack = new FrameVector3D(ReferenceFrame.getWorldFrame(), 10.0, 10.0, 10.0);
        Assert.assertFalse(this.referenceFrame.equals((Object)angularVelocityToPack.getReferenceFrame()));
        angularVelocityToPack.setIncludingFrame((FrameTuple3DReadOnly)this.generator.getAngularVelocity());
        Assert.assertEquals(0.0, angularVelocityToPack.getX(), 1.0E-10);
        Assert.assertEquals(0.0, angularVelocityToPack.getY(), 1.0E-10);
        Assert.assertEquals(0.0, angularVelocityToPack.getZ(), 1.0E-10);
        Assert.assertSame(this.referenceFrame, angularVelocityToPack.getReferenceFrame());
    }

    @Test
    public void testPackAngularAcceleration() {
        this.generator = new OrientationInterpolationTrajectoryGenerator(this.namePrefix, this.referenceFrame, this.trajectoryTimeProvider, this.initialOrientationProvider, this.finalOrientationProvider, this.parentRegistry);
        FrameVector3D angularAccelerationToPack = new FrameVector3D(ReferenceFrame.getWorldFrame(), 10.0, 10.0, 10.0);
        Assert.assertFalse(this.referenceFrame.equals((Object)angularAccelerationToPack.getReferenceFrame()));
        angularAccelerationToPack.setIncludingFrame((FrameTuple3DReadOnly)this.generator.getAngularAcceleration());
        Assert.assertEquals(0.0, angularAccelerationToPack.getX(), 1.0E-10);
        Assert.assertEquals(0.0, angularAccelerationToPack.getY(), 1.0E-10);
        Assert.assertEquals(0.0, angularAccelerationToPack.getZ(), 1.0E-10);
        Assert.assertSame(this.referenceFrame, angularAccelerationToPack.getReferenceFrame());
    }

    @Test
    public void testPackAngularData() {
        FrameQuaternion orientationToPack = new FrameQuaternion(this.referenceFrame);
        orientationToPack.setYawPitchRollIncludingFrame(this.referenceFrame, 4.4, 3.3, 1.4);
        this.generator = new OrientationInterpolationTrajectoryGenerator(this.namePrefix, this.referenceFrame, this.trajectoryTimeProvider, this.initialOrientationProvider, this.finalOrientationProvider, this.parentRegistry);
        orientationToPack.setIncludingFrame(this.generator.getOrientation());
        this.generator.setContinuouslyUpdateFinalOrientation(true);
        Assert.assertEquals(this.referenceFrame, orientationToPack.getReferenceFrame());
        orientationToPack.setIncludingFrame(this.generator.getOrientation());
        Assert.assertEquals(this.referenceFrame, orientationToPack.getReferenceFrame());
        FrameVector3D angularVelocityToPack = new FrameVector3D(ReferenceFrame.getWorldFrame(), 10.0, 10.0, 10.0);
        FrameVector3D angularAccelerationToPack = new FrameVector3D(ReferenceFrame.getWorldFrame(), 10.0, 10.0, 10.0);
        Assert.assertFalse(this.referenceFrame.equals((Object)angularVelocityToPack.getReferenceFrame()));
        Assert.assertTrue(ReferenceFrame.getWorldFrame().equals((Object)angularVelocityToPack.getReferenceFrame()));
        Assert.assertFalse(this.referenceFrame.equals((Object)angularAccelerationToPack.getReferenceFrame()));
        Assert.assertTrue(ReferenceFrame.getWorldFrame().equals((Object)angularAccelerationToPack.getReferenceFrame()));
        this.generator.getAngularData((FrameOrientation3DBasics)orientationToPack, (FrameVector3DBasics)angularVelocityToPack, (FrameVector3DBasics)angularAccelerationToPack);
        Assert.assertEquals(0.0, orientationToPack.getYaw(), 1.0E-10);
        Assert.assertEquals(0.0, orientationToPack.getPitch(), 1.0E-10);
        Assert.assertEquals(0.0, orientationToPack.getRoll(), 1.0E-10);
        Assert.assertSame(this.referenceFrame, orientationToPack.getReferenceFrame());
        Assert.assertEquals(0.0, angularVelocityToPack.getX(), 1.0E-10);
        Assert.assertEquals(0.0, angularVelocityToPack.getY(), 1.0E-10);
        Assert.assertEquals(0.0, angularVelocityToPack.getZ(), 1.0E-10);
        Assert.assertSame(this.referenceFrame, angularVelocityToPack.getReferenceFrame());
        Assert.assertEquals(0.0, angularAccelerationToPack.getX(), 1.0E-10);
        Assert.assertEquals(0.0, angularAccelerationToPack.getY(), 1.0E-10);
        Assert.assertEquals(0.0, angularAccelerationToPack.getZ(), 1.0E-10);
        Assert.assertSame(this.referenceFrame, angularAccelerationToPack.getReferenceFrame());
    }
}

