/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.RotationTools;
import us.ihmc.robotics.math.trajectories.BlendedPoseTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPoseTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.interfaces.FixedFramePoseTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameEuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSE3TrajectoryPoint;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.yoVariables.registry.YoRegistry;

public class BlendedPoseTrajectoryGeneratorTest {
    private final double EPSILON = 0.001;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    private void assertGeometricEquals(FramePose3D poseA, FramePose3D poseB, double epsilon) {
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)poseA.getPosition(), (EuclidFrameGeometry)poseB.getPosition(), (double)epsilon);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)poseA.getOrientation(), (EuclidFrameGeometry)poseB.getOrientation(), (double)epsilon);
    }

    private FixedFramePoseTrajectoryGenerator createRandomReferenceTrajectory(Random random, int numberOfWaypoints, double duration, ReferenceFrame referenceFrame, YoRegistry registry) {
        MultipleWaypointsPoseTrajectoryGenerator referenceTrajectory = new MultipleWaypointsPoseTrajectoryGenerator("referenceTrajectory", 10, registry);
        for (int i = 0; i < numberOfWaypoints; ++i) {
            double time = (double)i * duration / (double)(numberOfWaypoints - 1);
            PoseTrajectoryState state = new PoseTrajectoryState(random, time, referenceFrame, referenceFrame, referenceFrame);
            referenceTrajectory.appendPoseWaypoint(state.getWaypoint());
        }
        referenceTrajectory.initialize();
        return referenceTrajectory;
    }

    @Test
    public void testNoConstraints() {
        Random random = new Random(1738L);
        double trajectoryDuration = 1.0;
        int numberOfSamples = 10;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        PoseReferenceFrame bodyFrame = new PoseReferenceFrame("BodyFrame", worldFrame);
        YoRegistry registry = new YoRegistry("trajectory");
        FixedFramePoseTrajectoryGenerator referenceTrajectory = this.createRandomReferenceTrajectory(random, 10, trajectoryDuration, worldFrame, registry);
        BlendedPoseTrajectoryGenerator blendedTrajectory = new BlendedPoseTrajectoryGenerator("blendedTrajectory", referenceTrajectory, worldFrame, registry);
        for (int i = 0; i < numberOfSamples; ++i) {
            double time = (double)i * trajectoryDuration / (double)(numberOfSamples - 1);
            PoseTrajectoryState stateA = new PoseTrajectoryState(referenceTrajectory, time, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
            PoseTrajectoryState stateB = new PoseTrajectoryState((FixedFramePoseTrajectoryGenerator)blendedTrajectory, time, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
            stateA.assertEpsilonEquals(stateB, 0.001);
        }
    }

    @Test
    public void testInitialPoseConstraint() {
        Random random = new Random(1738L);
        double initialBlendDuration = 0.25;
        double trajectoryDuration = 1.0;
        int numberOfSamples = 10;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        PoseReferenceFrame bodyFrame = new PoseReferenceFrame("BodyFrame", worldFrame);
        YoRegistry registry = new YoRegistry("trajectory");
        FixedFramePoseTrajectoryGenerator referenceTrajectory = this.createRandomReferenceTrajectory(random, 10, trajectoryDuration, worldFrame, registry);
        BlendedPoseTrajectoryGenerator blendedTrajectory = new BlendedPoseTrajectoryGenerator("blendedTrajectory", referenceTrajectory, worldFrame, registry);
        PoseTrajectoryState initialState = new PoseTrajectoryState(random, 0.0, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
        blendedTrajectory.blendInitialConstraint((FramePose3DReadOnly)initialState.getPose(), 0.0, initialBlendDuration);
        PoseTrajectoryState referenceInitialState = new PoseTrajectoryState(referenceTrajectory, 0.0, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
        PoseTrajectoryState blendedInitialState = new PoseTrajectoryState((FixedFramePoseTrajectoryGenerator)blendedTrajectory, 0.0, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
        this.assertGeometricEquals(blendedInitialState.getPose(), initialState.getPose(), 0.001);
        Assert.assertTrue(blendedInitialState.getTwist().epsilonEquals((SpatialMotionReadOnly)referenceInitialState.getTwist(), 0.001));
        for (int i = 0; i < numberOfSamples; ++i) {
            double time = (double)i * trajectoryDuration / (double)(numberOfSamples - 1);
            if (!(time > initialBlendDuration)) continue;
            PoseTrajectoryState stateA = new PoseTrajectoryState(referenceTrajectory, time, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
            PoseTrajectoryState stateB = new PoseTrajectoryState((FixedFramePoseTrajectoryGenerator)blendedTrajectory, time, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
            stateA.assertEpsilonEquals(stateB, 0.001);
        }
    }

    @Test
    public void testInitialPoseAndTwistConstraint() {
        Random random = new Random();
        double initialBlendDuration = 0.25;
        double trajectoryDuration = 1.0;
        int numberOfSamples = 100;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        PoseReferenceFrame bodyFrame = new PoseReferenceFrame("BodyFrame", worldFrame);
        YoRegistry registry = new YoRegistry("trajectory");
        FixedFramePoseTrajectoryGenerator referenceTrajectory = this.createRandomReferenceTrajectory(random, 10, trajectoryDuration, worldFrame, registry);
        BlendedPoseTrajectoryGenerator blendedTrajectory = new BlendedPoseTrajectoryGenerator("blendedTrajectory", referenceTrajectory, worldFrame, registry);
        PoseTrajectoryState initialState = new PoseTrajectoryState(random, 0.0, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
        blendedTrajectory.blendInitialConstraint((FramePose3DReadOnly)initialState.getPose(), (TwistReadOnly)initialState.getTwist(), 0.0, initialBlendDuration);
        PoseTrajectoryState blendedInitialState = new PoseTrajectoryState((FixedFramePoseTrajectoryGenerator)blendedTrajectory, 0.0, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
        this.assertGeometricEquals(blendedInitialState.getPose(), initialState.getPose(), 0.001);
        Assert.assertTrue(blendedInitialState.getTwist().epsilonEquals((SpatialMotionReadOnly)initialState.getTwist(), 0.001));
        for (int i = 0; i < numberOfSamples; ++i) {
            double time = (double)i * trajectoryDuration / (double)(numberOfSamples - 1);
            if (!(time > initialBlendDuration)) continue;
            PoseTrajectoryState stateA = new PoseTrajectoryState(referenceTrajectory, time, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
            PoseTrajectoryState stateB = new PoseTrajectoryState((FixedFramePoseTrajectoryGenerator)blendedTrajectory, time, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
            stateA.assertEpsilonEquals(stateB, 0.001);
        }
    }

    @Test
    public void testFinalPoseConstraint() {
        Random random = new Random(1738L);
        double finalBlendDuration = 0.25;
        double trajectoryDuration = 1.0;
        int numberOfSamples = 10;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        PoseReferenceFrame bodyFrame = new PoseReferenceFrame("BodyFrame", worldFrame);
        YoRegistry registry = new YoRegistry("trajectory");
        FixedFramePoseTrajectoryGenerator referenceTrajectory = this.createRandomReferenceTrajectory(random, 10, trajectoryDuration, worldFrame, registry);
        BlendedPoseTrajectoryGenerator blendedTrajectory = new BlendedPoseTrajectoryGenerator("blendedTrajectory", referenceTrajectory, worldFrame, registry);
        FramePose3D finalReferencePose = new FramePose3D(worldFrame);
        referenceTrajectory.compute(trajectoryDuration);
        PoseTrajectoryState finalState = new PoseTrajectoryState(random, trajectoryDuration, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
        blendedTrajectory.blendFinalConstraint((FramePose3DReadOnly)finalState.getPose(), trajectoryDuration, finalBlendDuration);
        FramePose3D referencePose = new FramePose3D(worldFrame);
        FramePose3D blendedPose = new FramePose3D(worldFrame);
        referenceTrajectory.compute(trajectoryDuration);
        blendedTrajectory.compute(trajectoryDuration);
        referencePose.setIncludingFrame(referenceTrajectory.getPose());
        blendedPose.setIncludingFrame(blendedTrajectory.getPose());
        this.assertGeometricEquals(finalState.getPose(), blendedPose, 0.001);
        for (int i = 0; i < numberOfSamples; ++i) {
            double time = (double)i * trajectoryDuration / (double)(numberOfSamples - 1);
            if (!(time < trajectoryDuration - finalBlendDuration)) continue;
            PoseTrajectoryState stateA = new PoseTrajectoryState(referenceTrajectory, time, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
            PoseTrajectoryState stateB = new PoseTrajectoryState((FixedFramePoseTrajectoryGenerator)blendedTrajectory, time, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
            stateA.assertEpsilonEquals(stateB, 0.001);
        }
    }

    @Test
    public void testSameFinalPoseConstraint() {
        Random random = new Random(1738L);
        double finalBlendDuration = 0.25;
        double trajectoryDuration = 1.0;
        double dt = 0.01;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        PoseReferenceFrame bodyFrame = new PoseReferenceFrame("BodyFrame", worldFrame);
        YoRegistry registry = new YoRegistry("trajectory");
        FixedFramePoseTrajectoryGenerator referenceTrajectory = this.createRandomReferenceTrajectory(random, 10, trajectoryDuration, worldFrame, registry);
        BlendedPoseTrajectoryGenerator blendedTrajectory = new BlendedPoseTrajectoryGenerator("blendedTrajectory", referenceTrajectory, worldFrame, registry);
        FramePose3D finalReferencePose = new FramePose3D(worldFrame);
        referenceTrajectory.compute(trajectoryDuration);
        finalReferencePose.setIncludingFrame(referenceTrajectory.getPose());
        blendedTrajectory.blendFinalConstraint((FramePose3DReadOnly)finalReferencePose, trajectoryDuration, trajectoryDuration);
        blendedTrajectory.initialize();
        PoseTrajectoryState referenceFinalState = new PoseTrajectoryState(referenceTrajectory, trajectoryDuration, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
        PoseTrajectoryState blendedFinalState = new PoseTrajectoryState((FixedFramePoseTrajectoryGenerator)blendedTrajectory, trajectoryDuration, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
        FramePose3D referencePose = new FramePose3D(worldFrame);
        FramePose3D blendedPose = new FramePose3D(worldFrame);
        referenceTrajectory.compute(trajectoryDuration);
        blendedTrajectory.compute(trajectoryDuration);
        referencePose.setIncludingFrame(referenceTrajectory.getPose());
        blendedPose.setIncludingFrame(blendedTrajectory.getPose());
        Assert.assertTrue(blendedFinalState.getTwist().epsilonEquals((SpatialMotionReadOnly)referenceFinalState.getTwist(), 0.001));
        this.assertGeometricEquals(finalReferencePose, blendedPose, 0.001);
        for (double time = 0.0; time <= trajectoryDuration; time += dt) {
            PoseTrajectoryState stateA = new PoseTrajectoryState(referenceTrajectory, time, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
            PoseTrajectoryState stateB = new PoseTrajectoryState((FixedFramePoseTrajectoryGenerator)blendedTrajectory, time, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
            stateA.assertEpsilonEquals(stateB, 0.001);
        }
    }

    @Test
    public void testFinalPoseAndTwistConstraint() {
        Random random = new Random();
        double finalBlendDuration = 0.25;
        double trajectoryDuration = 1.0;
        int numberOfSamples = 10;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        PoseReferenceFrame bodyFrame = new PoseReferenceFrame("BodyFrame", worldFrame);
        YoRegistry registry = new YoRegistry("trajectory");
        FixedFramePoseTrajectoryGenerator referenceTrajectory = this.createRandomReferenceTrajectory(random, 10, trajectoryDuration, worldFrame, registry);
        BlendedPoseTrajectoryGenerator blendedTrajectory = new BlendedPoseTrajectoryGenerator("blendedTrajectory", referenceTrajectory, worldFrame, registry);
        PoseTrajectoryState finalState = new PoseTrajectoryState(random, trajectoryDuration, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
        blendedTrajectory.blendFinalConstraint((FramePose3DReadOnly)finalState.getPose(), (TwistReadOnly)finalState.getTwist(), trajectoryDuration, finalBlendDuration);
        PoseTrajectoryState blendedFinalState = new PoseTrajectoryState((FixedFramePoseTrajectoryGenerator)blendedTrajectory, trajectoryDuration, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
        this.assertGeometricEquals(blendedFinalState.getPose(), finalState.getPose(), 0.001);
        Assert.assertTrue(blendedFinalState.getTwist().epsilonEquals((SpatialMotionReadOnly)finalState.getTwist(), 0.001));
        for (int i = 0; i < numberOfSamples; ++i) {
            double time = (double)i * trajectoryDuration / (double)(numberOfSamples - 1);
            if (!(time < trajectoryDuration - finalBlendDuration)) continue;
            PoseTrajectoryState stateA = new PoseTrajectoryState(referenceTrajectory, time, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
            PoseTrajectoryState stateB = new PoseTrajectoryState((FixedFramePoseTrajectoryGenerator)blendedTrajectory, time, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
            stateA.assertEpsilonEquals(stateB, 0.001);
        }
    }

    @Test
    public void testInitialAndFinalConstraint() {
        Random random = new Random(1738L);
        double initialBlendDuration = 0.25;
        double finalBlendDuration = 0.25;
        double trajectoryDuration = 1.0;
        int numberOfSamples = 10;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        PoseReferenceFrame bodyFrame = new PoseReferenceFrame("BodyFrame", worldFrame);
        YoRegistry registry = new YoRegistry("trajectory");
        FixedFramePoseTrajectoryGenerator referenceTrajectory = this.createRandomReferenceTrajectory(random, 10, trajectoryDuration, worldFrame, registry);
        BlendedPoseTrajectoryGenerator blendedTrajectory = new BlendedPoseTrajectoryGenerator("blendedTrajectory", referenceTrajectory, worldFrame, registry);
        PoseTrajectoryState initialState = new PoseTrajectoryState(random, 0.0, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
        blendedTrajectory.blendInitialConstraint((FramePose3DReadOnly)initialState.getPose(), (TwistReadOnly)initialState.getTwist(), 0.0, initialBlendDuration);
        PoseTrajectoryState finalState = new PoseTrajectoryState(random, trajectoryDuration, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
        blendedTrajectory.blendFinalConstraint((FramePose3DReadOnly)finalState.getPose(), (TwistReadOnly)finalState.getTwist(), trajectoryDuration, finalBlendDuration);
        PoseTrajectoryState blendedInitialState = new PoseTrajectoryState((FixedFramePoseTrajectoryGenerator)blendedTrajectory, 0.0, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
        this.assertGeometricEquals(blendedInitialState.getPose(), initialState.getPose(), 0.001);
        Assert.assertTrue(blendedInitialState.getTwist().epsilonEquals((SpatialMotionReadOnly)initialState.getTwist(), 0.001));
        PoseTrajectoryState blendedFinalState = new PoseTrajectoryState((FixedFramePoseTrajectoryGenerator)blendedTrajectory, trajectoryDuration, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
        this.assertGeometricEquals(blendedFinalState.getPose(), finalState.getPose(), 0.001);
        Assert.assertTrue(blendedFinalState.getTwist().epsilonEquals((SpatialMotionReadOnly)finalState.getTwist(), 0.001));
        for (int i = 0; i < numberOfSamples; ++i) {
            double time = (double)i * trajectoryDuration / (double)(numberOfSamples - 1);
            if (!(time > initialBlendDuration) || !(time < trajectoryDuration - finalBlendDuration)) continue;
            PoseTrajectoryState stateA = new PoseTrajectoryState(referenceTrajectory, time, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
            PoseTrajectoryState stateB = new PoseTrajectoryState((FixedFramePoseTrajectoryGenerator)blendedTrajectory, time, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
            stateA.assertEpsilonEquals(stateB, 0.001);
        }
    }

    @Test
    public void testDerivativesConsistency() throws Exception {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        PoseReferenceFrame bodyFrame = new PoseReferenceFrame("BodyFrame", worldFrame);
        Random random = new Random(5165165161L);
        double dt = 1.0E-5;
        double trajectoryDuration = 1.0;
        double startIntegrationTime = 0.05;
        double endIntegrationTime = 1.0;
        FramePoint3D currentPosition = new FramePoint3D();
        FrameVector3D currentLinearVelocity = new FrameVector3D();
        FrameVector3D currentLinearAcceleration = new FrameVector3D();
        FrameQuaternion currentOrientation = new FrameQuaternion();
        FrameVector3D currentAngularVelocity = new FrameVector3D();
        FrameVector3D currentAngularAcceleration = new FrameVector3D();
        FramePoint3D positionFromIntegration = new FramePoint3D();
        Vector3D integratedLinearVelocity = new Vector3D();
        FrameVector3D linearVelocityFromIntegration = new FrameVector3D();
        Vector3D integratedLinearAcceleration = new Vector3D();
        FrameQuaternion orientationFromIntegration = new FrameQuaternion();
        Vector3D angularVelocityVector = new Vector3D();
        Quaternion quaternionFromIntegration = new Quaternion();
        Quaternion integratedAngularVelocity = new Quaternion();
        FrameVector3D angularVelocityFromIntegration = new FrameVector3D();
        Vector3D integratedAngularAcceleration = new Vector3D();
        YoRegistry registry = new YoRegistry("null");
        FixedFramePoseTrajectoryGenerator referenceTrajectory = this.createRandomReferenceTrajectory(random, 2, trajectoryDuration, worldFrame, registry);
        BlendedPoseTrajectoryGenerator blendedTrajectory = new BlendedPoseTrajectoryGenerator("blended", referenceTrajectory, worldFrame, registry);
        blendedTrajectory.initialize();
        PoseTrajectoryState initialState = new PoseTrajectoryState(random, 0.0, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
        blendedTrajectory.blendInitialConstraint((FramePose3DReadOnly)initialState.getPose(), (TwistReadOnly)initialState.getTwist(), 0.0, 0.3);
        PoseTrajectoryState finalState = new PoseTrajectoryState(random, trajectoryDuration, (ReferenceFrame)bodyFrame, worldFrame, worldFrame);
        blendedTrajectory.blendFinalConstraint((FramePose3DReadOnly)finalState.getPose(), (TwistReadOnly)finalState.getTwist(), trajectoryDuration, 0.3);
        blendedTrajectory.compute(startIntegrationTime - dt);
        positionFromIntegration.setIncludingFrame((FrameTuple3DReadOnly)blendedTrajectory.getPosition());
        linearVelocityFromIntegration.setIncludingFrame((FrameTuple3DReadOnly)blendedTrajectory.getVelocity());
        orientationFromIntegration.setIncludingFrame(blendedTrajectory.getOrientation());
        angularVelocityFromIntegration.setIncludingFrame((FrameTuple3DReadOnly)blendedTrajectory.getAngularVelocity());
        for (double time = startIntegrationTime; time <= endIntegrationTime; time += dt) {
            blendedTrajectory.compute(time);
            currentPosition.setIncludingFrame((FrameTuple3DReadOnly)blendedTrajectory.getPosition());
            currentOrientation.setIncludingFrame(blendedTrajectory.getOrientation());
            currentLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)blendedTrajectory.getVelocity());
            currentAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)blendedTrajectory.getAngularVelocity());
            currentLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)blendedTrajectory.getAcceleration());
            currentAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)blendedTrajectory.getAngularAcceleration());
            integratedLinearVelocity.set((Tuple3DReadOnly)currentLinearVelocity);
            integratedLinearVelocity.scale(dt);
            positionFromIntegration.add((Tuple3DReadOnly)integratedLinearVelocity);
            integratedLinearAcceleration.set((Tuple3DReadOnly)currentLinearAcceleration);
            integratedLinearAcceleration.scale(dt);
            linearVelocityFromIntegration.add((Tuple3DReadOnly)integratedLinearAcceleration);
            angularVelocityVector.set((Tuple3DReadOnly)currentAngularVelocity);
            RotationTools.integrateAngularVelocity((Vector3DReadOnly)angularVelocityVector, (double)dt, (QuaternionBasics)integratedAngularVelocity);
            quaternionFromIntegration.set((QuaternionReadOnly)orientationFromIntegration);
            quaternionFromIntegration.multiply((QuaternionReadOnly)integratedAngularVelocity, (QuaternionReadOnly)quaternionFromIntegration);
            orientationFromIntegration.set((QuaternionReadOnly)quaternionFromIntegration);
            integratedAngularAcceleration.set((Tuple3DReadOnly)currentAngularAcceleration);
            integratedAngularAcceleration.scale(dt);
            angularVelocityFromIntegration.add((Tuple3DReadOnly)integratedAngularAcceleration);
            Assert.assertTrue(currentPosition.geometricallyEquals((EuclidFrameGeometry)positionFromIntegration, 0.001));
            Assert.assertTrue(currentOrientation.geometricallyEquals((EuclidFrameGeometry)orientationFromIntegration, 0.001));
            Assert.assertTrue(currentLinearVelocity.geometricallyEquals((EuclidFrameGeometry)linearVelocityFromIntegration, 0.01));
            Assert.assertTrue(currentAngularVelocity.geometricallyEquals((EuclidFrameGeometry)angularVelocityFromIntegration, 0.01));
        }
    }

    @Test
    public void testTroublingDataSet1WithBlending() {
        double trajectoryDuration = 0.6;
        double dt = 0.01;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        YoRegistry registry = new YoRegistry("trajectory");
        MultipleWaypointsPoseTrajectoryGenerator swingTrajectory = new MultipleWaypointsPoseTrajectoryGenerator("Swing", 6, registry);
        swingTrajectory.clear(worldFrame);
        FramePoint3D initialPosition = new FramePoint3D(worldFrame, -7.212, -0.636, 0.302);
        FrameVector3D initialVelocity = new FrameVector3D(worldFrame, -0.0, -0.0, -0.002);
        FrameQuaternion initialOrientation = new FrameQuaternion(worldFrame, 0.0, -0.0, 1.0, 0.005);
        swingTrajectory.appendPositionWaypoint(0.0, (FramePoint3DBasics)initialPosition, (FrameVector3DBasics)initialVelocity);
        swingTrajectory.appendOrientationWaypoint(0.0, initialOrientation, new FrameVector3D());
        FrameEuclideanTrajectoryPoint firstWaypoint = new FrameEuclideanTrajectoryPoint(0.2, (FramePoint3DReadOnly)new FramePoint3D(worldFrame, -7.293, -0.623, 0.402), (FrameVector3DReadOnly)new FrameVector3D(worldFrame, -1.372, 0.219, 0.475));
        FrameEuclideanTrajectoryPoint secondWaypoint = new FrameEuclideanTrajectoryPoint(0.4, (FramePoint3DReadOnly)new FramePoint3D(worldFrame, -7.669, -0.563, 0.4), (FrameVector3DReadOnly)new FrameVector3D(worldFrame, -1.372, 0.219, 0.425));
        swingTrajectory.appendPositionWaypoint(firstWaypoint);
        swingTrajectory.appendPositionWaypoint(secondWaypoint);
        FramePoint3D finalPosition = new FramePoint3D(worldFrame, -7.75, -0.55, 0.3);
        FrameVector3D finalVelocity = new FrameVector3D(worldFrame, -0.0, -0.0, -0.3);
        FrameQuaternion finalOrientation = new FrameQuaternion(worldFrame, 0.0, -0.0, 1.0, 0.002);
        swingTrajectory.appendPositionWaypoint(trajectoryDuration, (FramePoint3DBasics)finalPosition, (FrameVector3DBasics)finalVelocity);
        swingTrajectory.appendOrientationWaypoint(trajectoryDuration, finalOrientation, new FrameVector3D());
        FramePose3D finalPoseToBlend = new FramePose3D(worldFrame, (Tuple3DReadOnly)new FramePoint3D(worldFrame, -7.75, -0.55, 0.3), (Orientation3DReadOnly)finalOrientation);
        swingTrajectory.initialize();
        BlendedPoseTrajectoryGenerator blendedTrajectory = new BlendedPoseTrajectoryGenerator("blendedTrajectory", (FixedFramePoseTrajectoryGenerator)swingTrajectory, worldFrame, registry);
        blendedTrajectory.blendFinalConstraint((FramePose3DReadOnly)finalPoseToBlend, trajectoryDuration, trajectoryDuration);
        blendedTrajectory.initialize();
        FramePose3D tempPose = new FramePose3D();
        swingTrajectory.compute(trajectoryDuration);
        tempPose.setIncludingFrame(swingTrajectory.getPose());
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)finalOrientation, (EuclidFrameGeometry)tempPose.getOrientation(), (double)0.001);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)finalPosition, (EuclidFrameGeometry)tempPose.getPosition(), (double)0.001);
        blendedTrajectory.compute(trajectoryDuration);
        tempPose.setIncludingFrame(blendedTrajectory.getPose());
        this.assertGeometricEquals(finalPoseToBlend, tempPose, 0.001);
        for (double time = 0.0; time <= trajectoryDuration; time += dt) {
            PoseTrajectoryState stateA = new PoseTrajectoryState((FixedFramePoseTrajectoryGenerator)swingTrajectory, time, worldFrame, worldFrame, worldFrame);
            PoseTrajectoryState stateB = new PoseTrajectoryState((FixedFramePoseTrajectoryGenerator)blendedTrajectory, time, worldFrame, worldFrame, worldFrame);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)stateA.getPose().getOrientation(), (EuclidFrameGeometry)stateB.getPose().getOrientation(), (double)0.1);
        }
    }

    @Test
    public void testTroublingDataSet1WithoutBlending() {
        int numberOfSamples = 100;
        double trajectoryDuration = 0.6;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        YoRegistry registry = new YoRegistry("trajectory");
        MultipleWaypointsPoseTrajectoryGenerator swingTrajectory = new MultipleWaypointsPoseTrajectoryGenerator("Swing", 6, registry);
        BlendedPoseTrajectoryGenerator blendedTrajectory = new BlendedPoseTrajectoryGenerator("blendedTrajectory", (FixedFramePoseTrajectoryGenerator)swingTrajectory, worldFrame, registry);
        swingTrajectory.clear(worldFrame);
        FramePoint3D initialPosition = new FramePoint3D(worldFrame, -7.212, -0.636, 0.302);
        FrameVector3D initialVelocity = new FrameVector3D(worldFrame, -0.0, -0.0, -0.002);
        FrameQuaternion initialOrientation = new FrameQuaternion(worldFrame, 0.0, -0.0, 1.0, 0.005);
        swingTrajectory.appendPositionWaypoint(0.0, (FramePoint3DBasics)initialPosition, (FrameVector3DBasics)initialVelocity);
        swingTrajectory.appendOrientationWaypoint(0.0, initialOrientation, new FrameVector3D());
        FrameEuclideanTrajectoryPoint firstWaypoint = new FrameEuclideanTrajectoryPoint(0.2, (FramePoint3DReadOnly)new FramePoint3D(worldFrame, -7.293, -0.623, 0.402), (FrameVector3DReadOnly)new FrameVector3D(worldFrame, -1.372, 0.219, 0.475));
        FrameEuclideanTrajectoryPoint secondWaypoint = new FrameEuclideanTrajectoryPoint(0.4, (FramePoint3DReadOnly)new FramePoint3D(worldFrame, -7.669, -0.563, 0.4), (FrameVector3DReadOnly)new FrameVector3D(worldFrame, -1.372, 0.219, 0.425));
        swingTrajectory.appendPositionWaypoint(firstWaypoint);
        swingTrajectory.appendPositionWaypoint(secondWaypoint);
        FramePoint3D finalPosition = new FramePoint3D(worldFrame, -7.75, -0.55, 0.3);
        FrameVector3D finalVelocity = new FrameVector3D(worldFrame, -0.0, -0.0, -0.3);
        FrameQuaternion finalOrientation = new FrameQuaternion(worldFrame, 0.0, -0.0, 1.0, 0.0);
        swingTrajectory.appendPositionWaypoint(trajectoryDuration, (FramePoint3DBasics)finalPosition, (FrameVector3DBasics)finalVelocity);
        swingTrajectory.appendOrientationWaypoint(trajectoryDuration, finalOrientation, new FrameVector3D());
        blendedTrajectory.initialize();
        FrameQuaternion orientation = new FrameQuaternion(worldFrame);
        for (int i = 0; i < numberOfSamples; ++i) {
            double time = (double)i * trajectoryDuration / (double)(numberOfSamples - 1);
            blendedTrajectory.compute(time);
            orientation.setIncludingFrame(blendedTrajectory.getOrientation());
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)initialOrientation, (EuclidFrameGeometry)orientation, (double)0.1);
        }
    }

    @Test
    public void testTroublingDataSet2WithBlending() {
        double dt = 0.01;
        double trajectoryDuration = 0.6;
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        YoRegistry registry = new YoRegistry("trajectory");
        MultipleWaypointsPoseTrajectoryGenerator swingTrajectory = new MultipleWaypointsPoseTrajectoryGenerator("Swing", 6, registry);
        swingTrajectory.clear(worldFrame);
        FramePoint3D initialPosition = new FramePoint3D(worldFrame, -7.212, -0.636, 0.302);
        FrameVector3D initialVelocity = new FrameVector3D(worldFrame, -0.0, -0.0, -0.002);
        FrameQuaternion initialOrientation = new FrameQuaternion(worldFrame, 0.0, -0.0, 1.0, 0.0);
        swingTrajectory.appendPositionWaypoint(0.0, (FramePoint3DBasics)initialPosition, (FrameVector3DBasics)initialVelocity);
        swingTrajectory.appendOrientationWaypoint(0.0, initialOrientation, new FrameVector3D());
        FrameEuclideanTrajectoryPoint firstWaypoint = new FrameEuclideanTrajectoryPoint(0.2, (FramePoint3DReadOnly)new FramePoint3D(worldFrame, -7.293, -0.623, 0.402), (FrameVector3DReadOnly)new FrameVector3D(worldFrame, -1.372, 0.219, 0.475));
        FrameEuclideanTrajectoryPoint secondWaypoint = new FrameEuclideanTrajectoryPoint(0.4, (FramePoint3DReadOnly)new FramePoint3D(worldFrame, -7.669, -0.563, 0.4), (FrameVector3DReadOnly)new FrameVector3D(worldFrame, -1.372, 0.219, 0.425));
        swingTrajectory.appendPositionWaypoint(firstWaypoint);
        swingTrajectory.appendPositionWaypoint(secondWaypoint);
        FramePoint3D finalPosition = new FramePoint3D(worldFrame, -7.75, -0.55, 0.3);
        FrameVector3D finalVelocity = new FrameVector3D(worldFrame, -0.0, -0.0, -0.3);
        swingTrajectory.appendPositionWaypoint(trajectoryDuration, (FramePoint3DBasics)finalPosition, (FrameVector3DBasics)finalVelocity);
        swingTrajectory.appendOrientationWaypoint(trajectoryDuration, initialOrientation, new FrameVector3D());
        swingTrajectory.initialize();
        BlendedPoseTrajectoryGenerator blendedTrajectory = new BlendedPoseTrajectoryGenerator("blendedTrajectory", (FixedFramePoseTrajectoryGenerator)swingTrajectory, worldFrame, registry);
        FramePose3D initialPoseToBlend = new FramePose3D(worldFrame, (Tuple3DReadOnly)initialPosition, (Orientation3DReadOnly)initialOrientation);
        blendedTrajectory.blendInitialConstraint((FramePose3DReadOnly)initialPoseToBlend, 0.0, 0.2);
        blendedTrajectory.initialize();
        for (double time = 0.0; time <= trajectoryDuration; time += dt) {
            PoseTrajectoryState stateA = new PoseTrajectoryState((FixedFramePoseTrajectoryGenerator)swingTrajectory, time, worldFrame, worldFrame, worldFrame);
            PoseTrajectoryState stateB = new PoseTrajectoryState((FixedFramePoseTrajectoryGenerator)blendedTrajectory, time, worldFrame, worldFrame, worldFrame);
            stateA.assertEpsilonEquals(stateB, 0.001);
        }
    }

    private class PoseTrajectoryState {
        public final double time;
        public final FramePoint3D position;
        public final FrameQuaternion orientation;
        public final FrameVector3D linearVelocity;
        public final FrameVector3D angularVelocity;
        public final FrameVector3D linearAcceleration;
        public final FrameVector3D angularAcceleration;
        private final ReferenceFrame bodyFrame;
        private final ReferenceFrame baseFrame;
        private final ReferenceFrame expressedInFrame;

        public PoseTrajectoryState(FixedFramePoseTrajectoryGenerator trajectory, double time, ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame) {
            this.position = new FramePoint3D(expressedInFrame);
            this.orientation = new FrameQuaternion(expressedInFrame);
            this.linearVelocity = new FrameVector3D(expressedInFrame);
            this.angularVelocity = new FrameVector3D(expressedInFrame);
            this.linearAcceleration = new FrameVector3D(expressedInFrame);
            this.angularAcceleration = new FrameVector3D(expressedInFrame);
            this.time = time;
            this.bodyFrame = bodyFrame;
            this.baseFrame = baseFrame;
            this.expressedInFrame = expressedInFrame;
            trajectory.compute(time);
            trajectory.getLinearData((FramePoint3DBasics)this.position, (FrameVector3DBasics)this.linearVelocity, (FrameVector3DBasics)this.linearAcceleration);
            trajectory.getAngularData((FrameOrientation3DBasics)this.orientation, (FrameVector3DBasics)this.angularVelocity, (FrameVector3DBasics)this.angularAcceleration);
        }

        public PoseTrajectoryState(Random random, double time, ReferenceFrame bodyFrame, ReferenceFrame baseFrame, ReferenceFrame expressedInFrame) {
            this.time = time;
            this.position = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)expressedInFrame, (double)1.0, (double)1.0, (double)1.0);
            this.orientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)expressedInFrame);
            this.linearVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expressedInFrame, (double)-10.0, (double)10.0, (double)-10.0, (double)10.0, (double)-10.0, (double)10.0);
            this.angularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expressedInFrame, (double)-10.0, (double)10.0, (double)-10.0, (double)10.0, (double)-10.0, (double)10.0);
            this.linearAcceleration = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expressedInFrame, (double)-100.0, (double)100.0, (double)-100.0, (double)100.0, (double)-100.0, (double)100.0);
            this.angularAcceleration = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)expressedInFrame, (double)-100.0, (double)100.0, (double)-100.0, (double)100.0, (double)-100.0, (double)100.0);
            this.bodyFrame = bodyFrame;
            this.baseFrame = baseFrame;
            this.expressedInFrame = expressedInFrame;
        }

        public FrameSE3TrajectoryPoint getWaypoint() {
            return new FrameSE3TrajectoryPoint(this.time, (FramePoint3DReadOnly)this.position, (FrameOrientation3DReadOnly)this.orientation, (FrameVector3DReadOnly)this.linearVelocity, (FrameVector3DReadOnly)this.angularVelocity);
        }

        public FramePose3D getPose() {
            this.position.changeFrame(this.expressedInFrame);
            this.orientation.changeFrame(this.expressedInFrame);
            return new FramePose3D((FrameTuple3DReadOnly)this.position, (FrameOrientation3DReadOnly)this.orientation);
        }

        public Twist getTwist() {
            this.linearVelocity.changeFrame(this.expressedInFrame);
            this.angularVelocity.changeFrame(this.expressedInFrame);
            Twist twist = new Twist(this.bodyFrame, this.baseFrame, this.expressedInFrame);
            twist.getLinearPart().set((FrameTuple3DReadOnly)this.linearVelocity);
            twist.getAngularPart().set((FrameTuple3DReadOnly)this.angularVelocity);
            return twist;
        }

        public void assertEpsilonEquals(PoseTrajectoryState other, double epsilon) {
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)this.position, (EuclidFrameGeometry)other.position, (double)epsilon);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)this.orientation, (EuclidFrameGeometry)other.orientation, (double)epsilon);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)this.linearVelocity, (EuclidFrameGeometry)other.linearVelocity, (double)epsilon);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)this.angularVelocity, (EuclidFrameGeometry)other.angularVelocity, (double)epsilon);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)this.linearAcceleration, (EuclidFrameGeometry)other.linearAcceleration, (double)epsilon);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)this.angularAcceleration, (EuclidFrameGeometry)other.angularAcceleration, (double)epsilon);
        }
    }
}

