/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.functionGenerator;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.robotics.math.functionGenerator.TriangleWaveFunctionGenerator;

public class TriangleWaveFunctionGeneratorTest {
    private static final int ITERATIONS = 10000;
    private static final double EPSILON = 1.0E-12;
    private static final double FD_EPSILON = 1.0E-6;

    @Test
    public void test() {
        Random random = new Random(34805734L);
        for (int i = 0; i < 10000; ++i) {
            TriangleWaveFunctionGenerator triangleWave = new TriangleWaveFunctionGenerator();
            double offset = RandomNumbers.nextDouble((Random)random, (double)5.0);
            double amplitude = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)5.0);
            double frequency = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)5.0);
            double phase = 0.0;
            triangleWave.setOffset(offset);
            triangleWave.setAmplitude(amplitude);
            triangleWave.setFrequency(frequency);
            triangleWave.setPhase(phase);
            triangleWave.resetAngle();
            Assertions.assertEquals((double)(offset - amplitude), (double)triangleWave.getValue(), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)triangleWave.getValueDDot(), (double)1.0E-12);
            double dt = 1.0E-6;
            double angle = RandomNumbers.nextDouble((Random)random, (double)3.1315926535897933);
            triangleWave.setAngle(angle);
            double valueDotCurrent = triangleWave.getValueDot();
            double valueDDotCurrent = triangleWave.getValueDDot();
            triangleWave.setAngle(angle - triangleWave.getAngleDot() * dt);
            double valuePrevious = triangleWave.getValue();
            double valueDotPrevious = triangleWave.getValueDot();
            triangleWave.setAngle(angle + triangleWave.getAngleDot() * dt);
            double valueNext = triangleWave.getValue();
            double valueDotNext = triangleWave.getValueDot();
            double valueDotCurrentFD = (valueNext - valuePrevious) / (2.0 * dt);
            double valueDDotCurrentFD = (valueDotNext - valueDotPrevious) / (2.0 * dt);
            Assertions.assertEquals((double)valueDotCurrentFD, (double)valueDotCurrent, (double)1.0E-6, (String)("Difference: " + Math.abs(valueDotCurrentFD - valueDotCurrent)));
            Assertions.assertEquals((double)valueDDotCurrentFD, (double)valueDDotCurrent, (double)1.0E-6, (String)("Difference: " + Math.abs(valueDDotCurrentFD - valueDDotCurrent)));
        }
    }
}

