/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.functionGenerator;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.robotics.math.functionGenerator.SineWaveFunctionGenerator;

public class SinewaveFunctionGeneratorTest {
    private static final int ITERATIONS = 10000;
    private static final double EPSILON = 1.0E-12;
    private static final double FD_EPSILON = 1.0E-6;

    @Test
    public void test() {
        Random random = new Random(34805734L);
        for (int i = 0; i < 10000; ++i) {
            SineWaveFunctionGenerator sinewave = new SineWaveFunctionGenerator();
            double offset = RandomNumbers.nextDouble((Random)random, (double)5.0);
            double amplitude = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)5.0);
            double frequency = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)5.0);
            double phase = 0.0;
            sinewave.setOffset(offset);
            sinewave.setAmplitude(amplitude);
            sinewave.setFrequency(frequency);
            sinewave.setPhase(phase);
            sinewave.resetAngle();
            Assertions.assertEquals((double)offset, (double)sinewave.getValue(), (double)1.0E-12);
            Assertions.assertEquals((double)(Math.PI * 2 * frequency * amplitude), (double)sinewave.getValueDot(), (double)1.0E-12);
            Assertions.assertEquals((double)0.0, (double)sinewave.getValueDDot(), (double)1.0E-12);
            double dt = 1.0E-6;
            double angle = RandomNumbers.nextDouble((Random)random, (double)Math.PI);
            sinewave.setAngle(angle);
            double valueDotCurrent = sinewave.getValueDot();
            double valueDDotCurrent = sinewave.getValueDDot();
            sinewave.setAngle(angle - sinewave.getAngleDot() * dt);
            double valuePrevious = sinewave.getValue();
            double valueDotPrevious = sinewave.getValueDot();
            sinewave.setAngle(angle + sinewave.getAngleDot() * dt);
            double valueNext = sinewave.getValue();
            double valueDotNext = sinewave.getValueDot();
            double valueDotCurrentFD = (valueNext - valuePrevious) / (2.0 * dt);
            double valueDDotCurrentFD = (valueDotNext - valueDotPrevious) / (2.0 * dt);
            Assertions.assertEquals((double)valueDotCurrentFD, (double)valueDotCurrent, (double)1.0E-6, (String)("Difference: " + Math.abs(valueDotCurrentFD - valueDotCurrent)));
            Assertions.assertEquals((double)valueDDotCurrentFD, (double)valueDDotCurrent, (double)1.0E-6, (String)("Difference: " + Math.abs(valueDDotCurrentFD - valueDDotCurrent)));
        }
    }
}

