/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.filters.WeightedAverageYoBoolean;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class WeightedAverageYoBooleanTest {
    private YoRegistry registry;
    private YoBoolean yoVariable1ToAverage;
    private YoBoolean yoVariable2ToAverage;
    private YoDouble yoVariable1Weight;
    private YoDouble yoVariable2Weight;
    private WeightedAverageYoBoolean averagePositiveVariable;
    private WeightedAverageYoBoolean averageVariable;

    @BeforeEach
    public void setUp() {
        this.registry = new YoRegistry("testRegistry");
        this.yoVariable1ToAverage = new YoBoolean("variable1ToFilter", this.registry);
        this.yoVariable2ToAverage = new YoBoolean("variable2ToFilter", this.registry);
        this.yoVariable1Weight = new YoDouble("variable1Weight", this.registry);
        this.yoVariable2Weight = new YoDouble("variable2Weight", this.registry);
        this.averagePositiveVariable = new WeightedAverageYoBoolean("averagePositiveVariable", this.registry, true);
        this.averagePositiveVariable.addBooleanToAverage((DoubleProvider)this.yoVariable1Weight, (BooleanProvider)this.yoVariable1ToAverage);
        this.averagePositiveVariable.addBooleanToAverage((DoubleProvider)this.yoVariable2Weight, (BooleanProvider)this.yoVariable2ToAverage);
        this.averageVariable = new WeightedAverageYoBoolean("averageVariable", this.registry);
        this.averageVariable.addBooleanToAverage((DoubleProvider)this.yoVariable1Weight, (BooleanProvider)this.yoVariable1ToAverage);
        this.averageVariable.addBooleanToAverage((DoubleProvider)this.yoVariable2Weight, (BooleanProvider)this.yoVariable2ToAverage);
    }

    @AfterEach
    public void tearDown() {
        this.registry = null;
        this.yoVariable1ToAverage = null;
        this.yoVariable2ToAverage = null;
        this.yoVariable1Weight = null;
        this.yoVariable2Weight = null;
        this.averagePositiveVariable = null;
        this.averageVariable = null;
    }

    @Test
    public void testConstructors_Set_Get() {
        WeightedAverageYoBoolean bool = new WeightedAverageYoBoolean("stringInt", this.registry);
        Assert.assertFalse(bool.getBooleanValue());
        bool.set(true);
        Assert.assertTrue(bool.getBooleanValue());
        bool.set(false);
        Assert.assertFalse(bool.getBooleanValue());
    }

    @Test
    public void testUpdate() {
        this.yoVariable1Weight.set(1.0);
        this.yoVariable2Weight.set(1.0);
        this.yoVariable1ToAverage.set(true);
        this.yoVariable2ToAverage.set(false);
        this.averagePositiveVariable.update();
        this.averageVariable.update();
        Assert.assertTrue(this.averagePositiveVariable.getBooleanValue());
        Assert.assertFalse(this.averageVariable.getBooleanValue());
        this.yoVariable1ToAverage.set(true);
        this.yoVariable2ToAverage.set(true);
        this.averagePositiveVariable.update();
        this.averageVariable.update();
        Assert.assertTrue(this.averagePositiveVariable.getBooleanValue());
        Assert.assertTrue(this.averageVariable.getBooleanValue());
        this.yoVariable1ToAverage.set(false);
        this.yoVariable2ToAverage.set(false);
        this.averagePositiveVariable.update();
        this.averageVariable.update();
        Assert.assertFalse(this.averagePositiveVariable.getBooleanValue());
        Assert.assertFalse(this.averageVariable.getBooleanValue());
        YoDouble yoVariable3Weight = new YoDouble("variable3Weight", this.registry);
        YoBoolean yoVariable3ToAverage = new YoBoolean("variable3ToFilter", this.registry);
        this.averagePositiveVariable.addBooleanToAverage((DoubleProvider)yoVariable3Weight, (BooleanProvider)yoVariable3ToAverage);
        this.averageVariable.addBooleanToAverage((DoubleProvider)yoVariable3Weight, (BooleanProvider)yoVariable3ToAverage);
        yoVariable3Weight.set(1.0);
        this.yoVariable1ToAverage.set(true);
        this.yoVariable2ToAverage.set(false);
        yoVariable3ToAverage.set(false);
        this.averagePositiveVariable.update();
        this.averageVariable.update();
        Assert.assertFalse(this.averagePositiveVariable.getBooleanValue());
        Assert.assertFalse(this.averageVariable.getBooleanValue());
        this.yoVariable2ToAverage.set(true);
        this.averagePositiveVariable.update();
        this.averageVariable.update();
        Assert.assertTrue(this.averagePositiveVariable.getBooleanValue());
        Assert.assertTrue(this.averageVariable.getBooleanValue());
        yoVariable3Weight.set(2.0);
        this.yoVariable1ToAverage.set(true);
        this.yoVariable2ToAverage.set(true);
        yoVariable3ToAverage.set(false);
        this.averagePositiveVariable.update();
        this.averageVariable.update();
        Assert.assertTrue(this.averagePositiveVariable.getBooleanValue());
        Assert.assertFalse(this.averageVariable.getBooleanValue());
    }
}

