/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import java.util.Random;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.robotics.math.filters.FiniteDifferenceAngularVelocityYoFrameVector;
import us.ihmc.robotics.math.filters.RateLimitedYoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.registry.YoRegistry;

public class RateLimitedYoFrameQuaternionTest {
    private static final double EPSILON = 1.0E-12;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testConvergenceWithConstantInput() throws Exception {
        Random random = new Random(46363L);
        double dt = 0.004;
        MutableDouble maxRate = new MutableDouble();
        YoRegistry registry = new YoRegistry("dummy");
        RateLimitedYoFrameQuaternion rateLimitedQuaternion = new RateLimitedYoFrameQuaternion("blop", "", registry, () -> maxRate.doubleValue(), dt, ReferenceFrame.getWorldFrame());
        rateLimitedQuaternion.update((QuaternionReadOnly)new Quaternion());
        FiniteDifferenceAngularVelocityYoFrameVector angularVelocity = new FiniteDifferenceAngularVelocityYoFrameVector("rate", (YoFrameQuaternion)rateLimitedQuaternion, dt, registry);
        for (int i = 0; i < 1000; ++i) {
            maxRate.setValue(RandomNumbers.nextDouble((Random)random, (double)0.001, (double)10.0));
            Quaternion goalQuaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            double distanceToGoal = Math.abs(AngleTools.trimAngleMinusPiToPi((double)rateLimitedQuaternion.distance((Orientation3DReadOnly)goalQuaternion)));
            if (distanceToGoal / dt < maxRate.doubleValue()) {
                rateLimitedQuaternion.update((QuaternionReadOnly)goalQuaternion);
                EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)goalQuaternion, (Orientation3DReadOnly)rateLimitedQuaternion, (double)1.0E-12);
                continue;
            }
            double timeToConverge = distanceToGoal / maxRate.doubleValue();
            int numberOfIterations = (int)(timeToConverge / dt);
            double previousDistance = distanceToGoal;
            angularVelocity.update();
            for (int j = 0; j < numberOfIterations; ++j) {
                rateLimitedQuaternion.update((QuaternionReadOnly)goalQuaternion);
                double distance = Math.abs(AngleTools.trimAngleMinusPiToPi((double)rateLimitedQuaternion.distance((Orientation3DReadOnly)goalQuaternion)));
                Assert.assertTrue(distance < previousDistance);
                angularVelocity.update();
                double rate = angularVelocity.length();
                Assert.assertEquals("difference: " + Math.abs(rate - maxRate.doubleValue()), rate, maxRate.doubleValue(), 1.0E-12);
                previousDistance = distance;
                Assert.assertFalse(rateLimitedQuaternion.geometricallyEquals((EuclidGeometry)goalQuaternion, 1.0E-12));
            }
            rateLimitedQuaternion.update((QuaternionReadOnly)goalQuaternion);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)goalQuaternion, (Orientation3DReadOnly)rateLimitedQuaternion, (double)1.0E-12);
        }
    }
}

