/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.filters.DeltaLimitedYoVariable;
import us.ihmc.yoVariables.registry.YoRegistry;

public class DeltaLimitedYoVariableTest {
    private static final int RANDOM_LOWER_BOUND = 10;
    private static final int RANDOM_UPPER_BOUND = 30000;
    private YoRegistry registry;
    private DeltaLimitedYoVariable variable;

    @Test
    public void testReferenceAndInputBothNegativeNoOvershootInputGreaterThanReference() {
        Random random = new Random(1976L);
        this.registry = new YoRegistry("registry");
        this.variable = new DeltaLimitedYoVariable("testVar", this.registry, 0.0);
        for (int i = 0; i < 60000; ++i) {
            double reference = (double)RandomNumbers.nextInt((Random)random, (int)10, (int)30000) * -1.0;
            double input = reference / 2.0;
            double delta = Math.abs(input - reference);
            this.variable.setMaxDelta(delta);
            this.variable.updateOutput(reference, input);
            Assert.assertTrue(input < 0.0);
            Assert.assertTrue(reference < 0.0);
            Assert.assertTrue(input > reference);
            Assert.assertFalse(this.variable.isLimitingActive());
            Assert.assertEquals(input, this.variable.getDoubleValue(), 1.0E-8);
        }
    }

    @Test
    public void testReferenceAndInputBothNegativeNoOvershootReferenceGreaterThanInput() {
        Random random = new Random(1976L);
        this.registry = new YoRegistry("registry");
        this.variable = new DeltaLimitedYoVariable("testVar", this.registry, 0.0);
        for (int i = 0; i < 60000; ++i) {
            double reference = (double)RandomNumbers.nextInt((Random)random, (int)10, (int)30000) * -1.0;
            double input = reference * 2.0;
            double delta = Math.abs(input - reference);
            this.variable.setMaxDelta(delta);
            this.variable.updateOutput(reference, input);
            Assert.assertTrue(input < 0.0);
            Assert.assertTrue(reference < 0.0);
            Assert.assertTrue(input < reference);
            Assert.assertFalse(this.variable.isLimitingActive());
            Assert.assertEquals(input, this.variable.getDoubleValue(), 1.0E-8);
        }
    }

    @Test
    public void testReferenceAndInputBothPositiveNoOvershootReferenceGreaterThanInput() {
        Random random = new Random(1976L);
        this.registry = new YoRegistry("registry");
        this.variable = new DeltaLimitedYoVariable("testVar", this.registry, 0.0);
        for (int i = 0; i < 60000; ++i) {
            double reference = RandomNumbers.nextInt((Random)random, (int)10, (int)30000);
            double input = reference / 2.0;
            double delta = Math.abs(input - reference);
            this.variable.setMaxDelta(delta);
            this.variable.updateOutput(reference, input);
            Assert.assertTrue(input > 0.0);
            Assert.assertTrue(reference > 0.0);
            Assert.assertTrue(input < reference);
            Assert.assertFalse(this.variable.isLimitingActive());
            Assert.assertEquals(input, this.variable.getDoubleValue(), 1.0E-8);
        }
    }

    @Test
    public void testReferenceAndInputBothPositiveNoOvershootInputGreaterThanReference() {
        Random random = new Random(1976L);
        this.registry = new YoRegistry("registry");
        this.variable = new DeltaLimitedYoVariable("testVar", this.registry, 0.0);
        for (int i = 0; i < 60000; ++i) {
            double reference = RandomNumbers.nextInt((Random)random, (int)10, (int)30000);
            double input = reference * 2.0;
            double delta = Math.abs(input - reference);
            this.variable.setMaxDelta(delta);
            this.variable.updateOutput(reference, input);
            Assert.assertTrue(input > 0.0);
            Assert.assertTrue(reference > 0.0);
            Assert.assertTrue(input > reference);
            Assert.assertFalse(this.variable.isLimitingActive());
            Assert.assertEquals(input, this.variable.getDoubleValue(), 1.0E-8);
        }
    }

    @Test
    public void testPositiveReferenceNegativeInputNoOvershoot() {
        Random random = new Random(1976L);
        this.registry = new YoRegistry("registry");
        this.variable = new DeltaLimitedYoVariable("testVar", this.registry, 0.0);
        for (int i = 0; i < 60000; ++i) {
            double reference = RandomNumbers.nextInt((Random)random, (int)10, (int)30000);
            double input = reference * -0.5;
            double delta = Math.abs(input - reference);
            this.variable.setMaxDelta(delta);
            this.variable.updateOutput(reference, input);
            Assert.assertTrue(input < 0.0);
            Assert.assertTrue(reference > 0.0);
            Assert.assertTrue(input < reference);
            Assert.assertFalse(this.variable.isLimitingActive());
            Assert.assertEquals(input, this.variable.getDoubleValue(), 1.0E-8);
        }
    }

    @Test
    public void testNegativeReferencePositiveInputNoOvershoot() {
        Random random = new Random(1976L);
        this.registry = new YoRegistry("registry");
        this.variable = new DeltaLimitedYoVariable("testVar", this.registry, 0.0);
        for (int i = 0; i < 60000; ++i) {
            double reference = (double)RandomNumbers.nextInt((Random)random, (int)10, (int)30000) * -1.0;
            double input = reference * -0.5;
            double delta = Math.abs(input - reference);
            this.variable.setMaxDelta(delta);
            this.variable.updateOutput(reference, input);
            Assert.assertTrue(input > 0.0);
            Assert.assertTrue(reference < 0.0);
            Assert.assertTrue(input > reference);
            Assert.assertFalse(this.variable.isLimitingActive());
            Assert.assertEquals(input, this.variable.getDoubleValue(), 1.0E-8);
        }
    }

    @Test
    public void testReferenceAndInputBothNegativeWithOvershootInputGreaterThanReference() {
        Random random = new Random(1976L);
        this.registry = new YoRegistry("registry");
        this.variable = new DeltaLimitedYoVariable("testVar", this.registry, 0.0);
        for (int i = 0; i < 60000; ++i) {
            double reference = (double)RandomNumbers.nextInt((Random)random, (int)10, (int)30000) * -1.0;
            double input = reference / 2.0;
            double delta = Math.abs(input - reference) / 2.0;
            this.variable.setMaxDelta(delta);
            this.variable.updateOutput(reference, input);
            double overshoot = Math.abs(input - reference) - delta;
            double expectedClip = input - overshoot;
            Assert.assertTrue(input < 0.0);
            Assert.assertTrue(reference < 0.0);
            Assert.assertTrue(input > reference);
            Assert.assertTrue(this.variable.isLimitingActive());
            Assert.assertEquals("Variable not clipped correctly\nReference: " + reference + "\nInput: " + input + "\nMagnitude of requested delta: " + Math.abs(input - reference) + "\nMax Allowed Delta: " + delta + "\nOvershoot: " + overshoot, expectedClip, this.variable.getDoubleValue(), 1.0E-8);
        }
    }

    @Test
    public void testReferenceAndInputBothNegativeWithOvershootReferenceGreaterThanInput() {
        Random random = new Random(1976L);
        this.registry = new YoRegistry("registry");
        this.variable = new DeltaLimitedYoVariable("testVar", this.registry, 0.0);
        for (int i = 0; i < 60000; ++i) {
            double reference = (double)RandomNumbers.nextInt((Random)random, (int)10, (int)30000) * -1.0;
            double input = reference * 2.0;
            double delta = Math.abs(input - reference) / 2.0;
            this.variable.setMaxDelta(delta);
            this.variable.updateOutput(reference, input);
            double overshoot = Math.abs(input - reference) - delta;
            double expectedClip = input + overshoot;
            Assert.assertTrue(input < 0.0);
            Assert.assertTrue(reference < 0.0);
            Assert.assertTrue(input < reference);
            Assert.assertTrue(this.variable.isLimitingActive());
            Assert.assertEquals("Variable not clipped correctly\nReference: " + reference + "\nInput: " + input + "\nMagnitude of requested delta: " + Math.abs(input - reference) + "\nMax Allowed Delta: " + delta + "\nOvershoot: " + overshoot, expectedClip, this.variable.getDoubleValue(), 1.0E-8);
        }
    }

    @Test
    public void testReferenceAndInputBothPositiveWithOvershootInputGreaterThanReference() {
        Random random = new Random(1976L);
        this.registry = new YoRegistry("registry");
        this.variable = new DeltaLimitedYoVariable("testVar", this.registry, 0.0);
        for (int i = 0; i < 60000; ++i) {
            double reference = RandomNumbers.nextInt((Random)random, (int)10, (int)30000);
            double input = reference * 2.0;
            double delta = Math.abs(input - reference) / 2.0;
            this.variable.setMaxDelta(delta);
            this.variable.updateOutput(reference, input);
            double overshoot = Math.abs(input - reference) - delta;
            double expectedClip = input - overshoot;
            Assert.assertTrue(input > 0.0);
            Assert.assertTrue(reference > 0.0);
            Assert.assertTrue(input > reference);
            Assert.assertTrue(this.variable.isLimitingActive());
            Assert.assertEquals("Variable not clipped correctly\nReference: " + reference + "\nInput: " + input + "\nMagnitude of requested delta: " + Math.abs(input - reference) + "\nMax Allowed Delta: " + delta + "\nOvershoot: " + overshoot, expectedClip, this.variable.getDoubleValue(), 1.0E-8);
        }
    }

    @Test
    public void testReferenceAndInputBothPositiveWithOvershootReferenceGreaterThanInput() {
        Random random = new Random(1976L);
        this.registry = new YoRegistry("registry");
        this.variable = new DeltaLimitedYoVariable("testVar", this.registry, 0.0);
        for (int i = 0; i < 60000; ++i) {
            double reference = RandomNumbers.nextInt((Random)random, (int)10, (int)30000);
            double input = reference / 2.0;
            double delta = Math.abs(input - reference) / 2.0;
            this.variable.setMaxDelta(delta);
            this.variable.updateOutput(reference, input);
            double overshoot = Math.abs(input - reference) - delta;
            double expectedClip = input + overshoot;
            Assert.assertTrue(input > 0.0);
            Assert.assertTrue(reference > 0.0);
            Assert.assertTrue(input < reference);
            Assert.assertTrue(this.variable.isLimitingActive());
            Assert.assertEquals("Variable not clipped correctly\nReference: " + reference + "\nInput: " + input + "\nMagnitude of requested delta: " + Math.abs(input - reference) + "\nMax Allowed Delta: " + delta + "\nOvershoot: " + overshoot, expectedClip, this.variable.getDoubleValue(), 1.0E-8);
        }
    }

    @Test
    public void testPositiveReferenceNegativeInputWithOvershoot() {
        Random random = new Random(1976L);
        this.registry = new YoRegistry("registry");
        this.variable = new DeltaLimitedYoVariable("testVar", this.registry, 0.0);
        for (int i = 0; i < 60000; ++i) {
            double reference = RandomNumbers.nextInt((Random)random, (int)10, (int)30000);
            double input = reference * -0.5;
            double delta = Math.abs(input - reference) / 2.0;
            this.variable.setMaxDelta(delta);
            this.variable.updateOutput(reference, input);
            double overshoot = Math.abs(input - reference) - delta;
            double expectedClip = input + overshoot;
            Assert.assertTrue(input < 0.0);
            Assert.assertTrue(reference > 0.0);
            Assert.assertTrue(input < reference);
            Assert.assertTrue(this.variable.isLimitingActive());
            Assert.assertEquals("Variable not clipped correctly\nReference: " + reference + "\nInput: " + input + "\nMagnitude of requested delta: " + Math.abs(input - reference) + "\nMax Allowed Delta: " + delta + "\nOvershoot: " + overshoot, expectedClip, this.variable.getDoubleValue(), 1.0E-8);
        }
    }

    @Test
    public void testNegativeReferencePositiveInputWithOvershoot() {
        Random random = new Random(1976L);
        this.registry = new YoRegistry("registry");
        this.variable = new DeltaLimitedYoVariable("testVar", this.registry, 0.0);
        for (int i = 0; i < 60000; ++i) {
            double reference = (double)RandomNumbers.nextInt((Random)random, (int)10, (int)30000) * -1.0;
            double input = reference * -0.5;
            double delta = Math.abs(input - reference) / 2.0;
            this.variable.setMaxDelta(delta);
            this.variable.updateOutput(reference, input);
            double overshoot = Math.abs(input - reference) - delta;
            double expectedClip = input - overshoot;
            Assert.assertTrue(input > 0.0);
            Assert.assertTrue(reference < 0.0);
            Assert.assertTrue(input > reference);
            Assert.assertTrue(this.variable.isLimitingActive());
            Assert.assertEquals("Variable not clipped correctly\nReference: " + reference + "\nInput: " + input + "\nMagnitude of requested delta: " + Math.abs(input - reference) + "\nMax Allowed Delta: " + delta + "\nOvershoot: " + overshoot, expectedClip, this.variable.getDoubleValue(), 1.0E-8);
        }
    }

    @Test
    public void testOvershootThenNoOvershoot() {
        Random random = new Random(1976L);
        this.registry = new YoRegistry("registry");
        this.variable = new DeltaLimitedYoVariable("testVar", this.registry, 0.0);
        for (int i = 0; i < 60000; ++i) {
            double reference = (double)RandomNumbers.nextInt((Random)random, (int)10, (int)30000) * -1.0;
            double input = reference * -0.5;
            double delta = Math.abs(input - reference) / 2.0;
            this.variable.setMaxDelta(delta);
            this.variable.updateOutput(reference, input);
            double overshoot = Math.abs(input - reference) - delta;
            double expectedClip = input - overshoot;
            Assert.assertTrue(input > 0.0);
            Assert.assertTrue(reference < 0.0);
            Assert.assertTrue(input > reference);
            Assert.assertTrue(this.variable.isLimitingActive());
            Assert.assertEquals("Variable not clipped correctly\nReference: " + reference + "\nInput: " + input + "\nMagnitude of requested delta: " + Math.abs(input - reference) + "\nMax Allowed Delta: " + delta + "\nOvershoot: " + overshoot, expectedClip, this.variable.getDoubleValue(), 1.0E-8);
            input = this.variable.getDoubleValue();
            this.variable.updateOutput(reference, input);
            double newRequestedDelta = Math.abs(input - reference);
            Assert.assertFalse(newRequestedDelta > delta);
            Assert.assertFalse(this.variable.isLimitingActive());
            Assert.assertEquals("Variable not clipped correctly\nReference: " + reference + "\nInput: " + input + "\nMagnitude of requested delta: " + Math.abs(input - reference) + "\nMax Allowed Delta: " + delta + "\nOvershoot: " + overshoot, expectedClip, this.variable.getDoubleValue(), 1.0E-8);
        }
    }
}

