/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math;

import java.util.ArrayList;
import java.util.Random;
import org.ejml.EjmlUnitTests;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.math.MatrixYoVariableConversionTools;
import us.ihmc.yoVariables.registry.YoRegistry;

public class MatrixYoVariableConversionToolsTest {
    @Test
    public void testBackAndForthVector() {
        ArrayList yoArray = new ArrayList();
        int size = 50;
        String prefix = "test";
        YoRegistry registry = new YoRegistry("test");
        DMatrixRMaj matrix = new DMatrixRMaj(size, 1);
        Random random = new Random(1235612L);
        RandomMatrices_DDRM.fillUniform((DMatrixRMaj)matrix, (Random)random);
        DMatrixRMaj matrixBack = new DMatrixRMaj(size, 1);
        MatrixYoVariableConversionTools.populateYoVariablesVector(yoArray, (int)size, (String)prefix, (YoRegistry)registry);
        MatrixYoVariableConversionTools.storeInYoVariablesVector((DMatrixRMaj)matrix, yoArray);
        MatrixYoVariableConversionTools.getFromYoVariablesVector((DMatrixRMaj)matrixBack, yoArray);
        EjmlUnitTests.assertEquals((DMatrix)matrix, (DMatrix)matrixBack, (double)1.0E-12);
    }

    @Test
    public void testBackAndForthMatrix() {
        ArrayList yoArray = new ArrayList();
        int nRows = 50;
        int nColumns = 60;
        String prefix = "test";
        YoRegistry registry = new YoRegistry("test");
        DMatrixRMaj matrix = new DMatrixRMaj(nRows, nColumns);
        Random random = new Random(1235612L);
        RandomMatrices_DDRM.fillUniform((DMatrixRMaj)matrix, (Random)random);
        DMatrixRMaj matrixBack = new DMatrixRMaj(nRows, nColumns);
        MatrixYoVariableConversionTools.populateYoVariablesMatrix(yoArray, (int)nRows, (int)nColumns, (String)prefix, (YoRegistry)registry);
        MatrixYoVariableConversionTools.storeInYoVariablesMatrix((DMatrixRMaj)matrix, yoArray);
        MatrixYoVariableConversionTools.getFromYoVariablesMatrix((DMatrixRMaj)matrixBack, yoArray);
        EjmlUnitTests.assertEquals((DMatrix)matrix, (DMatrix)matrixBack, (double)1.0E-12);
    }

    @Test
    public void testBackAndForthSymmetricMatrix() {
        ArrayList yoArray = new ArrayList();
        int size = 50;
        String prefix = "test";
        YoRegistry registry = new YoRegistry("test");
        Random random = new Random(1235612L);
        DMatrixRMaj matrix = RandomMatrices_DDRM.symmetricPosDef((int)size, (Random)random);
        DMatrixRMaj matrixBack = new DMatrixRMaj(size, size);
        MatrixYoVariableConversionTools.populateYoVariablesSymmetricMatrix(yoArray, (int)size, (String)prefix, (YoRegistry)registry);
        MatrixYoVariableConversionTools.storeInYoVariablesSymmetric((DMatrixRMaj)matrix, yoArray);
        MatrixYoVariableConversionTools.getFromYoVariablesSymmetric((DMatrixRMaj)matrixBack, yoArray);
        EjmlUnitTests.assertEquals((DMatrix)matrix, (DMatrix)matrixBack, (double)1.0E-12);
    }
}

