/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearDynamicSystems;

import org.junit.jupiter.api.Test;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.dataStructures.ObsoletePolynomial;
import us.ihmc.robotics.linearDynamicSystems.LinearDynamicSystem;
import us.ihmc.robotics.linearDynamicSystems.MatlabChart;
import us.ihmc.robotics.linearDynamicSystems.TransferFunction;
import us.ihmc.robotics.linearDynamicSystems.TransferFunctionMatrix;
import us.ihmc.robotics.linearDynamicSystems.TransferFunctionToStateSpaceConverter;

class TransferFunctionToStateSpaceConverterTest {
    TransferFunctionToStateSpaceConverterTest() {
    }

    @Test
    void testTransferFunctionToStateSpaceConverter() {
        boolean plotResponse = false;
        ObsoletePolynomial numeratorPolynomial = new ObsoletePolynomial(1.0);
        ObsoletePolynomial denominatorPolynomial = new ObsoletePolynomial(1.0, 1.0);
        this.checkTransferFunctionRemainsTheSame(numeratorPolynomial, denominatorPolynomial);
        double wn = Math.PI * 2;
        double zeta = 0.1;
        numeratorPolynomial = new ObsoletePolynomial(wn * wn);
        denominatorPolynomial = new ObsoletePolynomial(1.0, 2.0 * zeta * wn, wn * wn);
        LinearDynamicSystem dynamicSystem = this.checkTransferFunctionRemainsTheSame(numeratorPolynomial, denominatorPolynomial);
        double[] initialConditions = new double[]{1.0, 0.0};
        if (plotResponse) {
            this.simulateAndPlot(denominatorPolynomial, dynamicSystem, initialConditions);
        }
        numeratorPolynomial = new ObsoletePolynomial(1.2, 0.3, 1.07);
        denominatorPolynomial = new ObsoletePolynomial(2.2, 3.3, 4.7, 9.6);
        dynamicSystem = this.checkTransferFunctionRemainsTheSame(numeratorPolynomial, denominatorPolynomial);
        initialConditions = new double[]{1.0, 0.0, 0.0};
        if (plotResponse) {
            this.simulateAndPlot(denominatorPolynomial, dynamicSystem, initialConditions);
        }
        numeratorPolynomial = new ObsoletePolynomial(1.2, 0.3, 1.07, 3.3);
        denominatorPolynomial = new ObsoletePolynomial(2.2, 3.3, 4.7, 9.6);
        dynamicSystem = this.checkTransferFunctionRemainsTheSame(numeratorPolynomial, denominatorPolynomial);
        initialConditions = new double[]{1.0, 0.0, 0.0};
        if (plotResponse) {
            this.simulateAndPlot(denominatorPolynomial, dynamicSystem, initialConditions);
        }
        if (plotResponse) {
            ThreadTools.sleepForever();
        }
    }

    private LinearDynamicSystem checkTransferFunctionRemainsTheSame(ObsoletePolynomial numeratorPolynomial, ObsoletePolynomial denominatorPolynomial) {
        TransferFunction transferFunction = new TransferFunction(numeratorPolynomial, denominatorPolynomial);
        LinearDynamicSystem dynamicSystem = TransferFunctionToStateSpaceConverter.convertTransferFunctionToStateSpaceObservableCanonicalForm((TransferFunction)transferFunction);
        Assert.assertEquals(denominatorPolynomial.getOrder(), dynamicSystem.getOrder());
        Assert.assertEquals(1L, dynamicSystem.getInputSize());
        Assert.assertEquals(1L, dynamicSystem.getOutputSize());
        this.checkTransferFunctionsRemainTheSame(transferFunction, dynamicSystem);
        LinearDynamicSystem dynamicSystemTwo = TransferFunctionToStateSpaceConverter.convertTransferFunctionToStateSpaceControllableCanonicalForm((TransferFunction)transferFunction);
        this.checkTransferFunctionsRemainTheSame(transferFunction, dynamicSystemTwo);
        return dynamicSystem;
    }

    private void checkTransferFunctionsRemainTheSame(TransferFunction transferFunction, LinearDynamicSystem dynamicSystem) {
        TransferFunctionMatrix transferFunctionMatrix = dynamicSystem.getTransferFunctionMatrix();
        Assert.assertEquals(1L, transferFunctionMatrix.getRows());
        Assert.assertEquals(1L, transferFunctionMatrix.getColumns());
        TransferFunction transferFunctionTwo = transferFunctionMatrix.get(0, 0);
        Assert.assertTrue(transferFunction.epsilonEquals(transferFunctionTwo, 1.0E-7));
    }

    private void simulateAndPlot(ObsoletePolynomial denominatorPolynomial, LinearDynamicSystem dynamicSystem, double[] initialConditions) {
        if (dynamicSystem.getOrder() != initialConditions.length) {
            throw new RuntimeException("dynamicSystem.getOrder() != initialConditions.length");
        }
        double stepSize = 0.001;
        int numTicks = 5000;
        double[][] stateVersusTime = dynamicSystem.simulateInitialConditions(initialConditions, stepSize, numTicks);
        double[] time = new double[numTicks];
        for (int i = 0; i < numTicks; ++i) {
            time[i] = stepSize * (double)i;
        }
        double[] x = new double[numTicks];
        for (int i = 0; i < numTicks; ++i) {
            x[i] = stateVersusTime[i][0];
        }
        MatlabChart fig = new MatlabChart();
        fig.plot(time, x, "-r", 2.0f, "x");
        fig.RenderPlot();
        fig.title("Dynamic System Response");
        fig.xlabel("t");
        fig.ylabel("x");
        fig.grid("on", "on");
        fig.legend("northeast");
        fig.font("Helvetica", 15);
        fig.displayInJFrame();
        if (dynamicSystem.getOrder() >= 2) {
            double[] xDot = new double[numTicks];
            for (int i = 0; i < numTicks; ++i) {
                xDot[i] = stateVersusTime[i][1];
            }
            MatlabChart phasePortrait = new MatlabChart();
            phasePortrait.plot(x, xDot, "-r", 2.0f, "x vs. xDot");
            phasePortrait.RenderPlot();
            phasePortrait.title("Dynamic System Response: Phase Portrait");
            phasePortrait.xlabel("x");
            phasePortrait.ylabel("xDot");
            phasePortrait.grid("on", "on");
            phasePortrait.legend("northeast");
            phasePortrait.font("Helvetica", 15);
            phasePortrait.displayInJFrame();
        }
    }
}

