/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearDynamicSystems;

import Jama.Matrix;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.dataStructures.ComplexNumber;
import us.ihmc.robotics.linearDynamicSystems.DynamicSystemsTestHelpers;
import us.ihmc.robotics.linearDynamicSystems.EigenvalueDecomposer;
import us.ihmc.robotics.linearDynamicSystems.LinearDynamicSystem;

public class MassSpringDamperTest {
    private static final double wn = 1.0;
    private static final double zeta = 0.5;
    private static final double P1 = 0.5;
    private static final double P2 = Math.sqrt(0.75) * 1.0;
    private static final double P3 = 1.0;
    private Matrix matrixA;
    private ComplexNumber[] leftEigenvectorV;
    private ComplexNumber[] rightEigenvectorW;
    private ComplexNumber[] eigenvalues;
    private EigenvalueDecomposer eigenvalueDecomposerA;

    @BeforeEach
    public void setUp() throws Exception {
        this.matrixA = new Matrix((double[][])new double[][]{{-1.0, -1.0}, {1.0, 0.0}});
        this.leftEigenvectorV = new ComplexNumber[]{new ComplexNumber(-P2, -0.5), new ComplexNumber(0.0, 1.0)};
        this.rightEigenvectorW = new ComplexNumber[]{new ComplexNumber(-1.0 / (2.0 * P2), 0.0), new ComplexNumber(-0.5 / (2.0 * P2), -0.5)};
        this.eigenvalues = new ComplexNumber[]{new ComplexNumber(-0.5, P2), new ComplexNumber(-0.5, -P2)};
        this.eigenvalueDecomposerA = new EigenvalueDecomposer(this.matrixA);
        new LinearDynamicSystem(this.matrixA, null, null, null);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.matrixA = null;
        this.leftEigenvectorV = null;
        this.rightEigenvectorW = null;
        this.eigenvalues = null;
        this.eigenvalueDecomposerA = null;
    }

    @Test
    public void testVDotWEqualsOne() {
        ComplexNumber dotProduct = new ComplexNumber(0.0, 0.0);
        for (int i = 0; i < this.leftEigenvectorV.length; ++i) {
            dotProduct = dotProduct.plus(this.leftEigenvectorV[i].times(this.rightEigenvectorW[i]));
        }
        Assert.assertEquals(1.0, dotProduct.real(), 1.0E-7);
        Assert.assertEquals(0.0, dotProduct.imag(), 1.0E-7);
    }

    @Test
    public void testVDotWCongEqualsZero() {
        ComplexNumber dotProduct = new ComplexNumber(0.0, 0.0);
        for (int i = 0; i < this.leftEigenvectorV.length; ++i) {
            dotProduct = dotProduct.plus(this.leftEigenvectorV[i].times(this.rightEigenvectorW[i].conj()));
        }
        Assert.assertEquals(0.0, dotProduct.real(), 1.0E-7);
        Assert.assertEquals(0.0, dotProduct.imag(), 1.0E-7);
    }

    @Test
    public void testDecomposerGotEigenvaluesRight() {
        ComplexNumber[] eigenvaluesFromDecomposer = this.eigenvalueDecomposerA.getEigenvalues();
        DynamicSystemsTestHelpers.assertEpsilonEquals(this.eigenvalues, eigenvaluesFromDecomposer, 1.0E-7);
    }
}

