/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearDynamicSystems;

import Jama.Matrix;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.dataStructures.ComplexNumber;
import us.ihmc.robotics.dataStructures.ObsoletePolynomial;
import us.ihmc.robotics.linearDynamicSystems.ComplexMatrix;
import us.ihmc.robotics.linearDynamicSystems.LinearDynamicSystem;
import us.ihmc.robotics.linearDynamicSystems.TransferFunction;
import us.ihmc.robotics.linearDynamicSystems.TransferFunctionMatrix;

public class LinearDynamicSystemTest {
    private static final boolean VERBOSE = false;
    private static final double wn = 1.0;
    private static final double zeta = 0.5;
    private Matrix simpleDecayMatrixA;
    private Matrix massSpringDamperMatrixA;
    private LinearDynamicSystem simpleDecaySystem;
    private LinearDynamicSystem massSpringDamperSystem;
    private Matrix simpleNotSquareMatrix;
    private Matrix simpleSquareMatrix;

    @BeforeEach
    public void setUp() throws Exception {
        this.simpleDecayMatrixA = new Matrix((double[][])new double[][]{{-1.0}});
        this.simpleDecaySystem = new LinearDynamicSystem(this.simpleDecayMatrixA, null, null, null);
        this.massSpringDamperMatrixA = new Matrix((double[][])new double[][]{{-1.0, -1.0}, {1.0, 0.0}});
        this.massSpringDamperSystem = new LinearDynamicSystem(this.massSpringDamperMatrixA, null, null, null);
        this.simpleNotSquareMatrix = new Matrix(1, 2, 0.0);
        this.simpleSquareMatrix = new Matrix(2, 2, 0.0);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.simpleDecaySystem = null;
        this.simpleDecayMatrixA = null;
        this.massSpringDamperMatrixA = null;
        this.massSpringDamperSystem = null;
    }

    @Test
    public void testException() {
        block20: {
            LinearDynamicSystem LDS;
            boolean thrown;
            block19: {
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    thrown = false;
                                    try {
                                        LinearDynamicSystem linearDynamicSystem = new LinearDynamicSystem(this.simpleNotSquareMatrix, null, null, null);
                                    }
                                    catch (RuntimeException e) {
                                        if (e.getMessage() != "matrixA must be square!") break block14;
                                        thrown = true;
                                    }
                                }
                                Assert.assertTrue(thrown);
                                thrown = false;
                                try {
                                    LinearDynamicSystem e = new LinearDynamicSystem(null, null, null, null);
                                }
                                catch (RuntimeException e) {
                                    if (e.getMessage() != "matrixA must be defined. B,C,D can be null") break block15;
                                    thrown = true;
                                }
                            }
                            Assert.assertTrue(thrown);
                            thrown = false;
                            try {
                                LDS = new LinearDynamicSystem(this.simpleSquareMatrix, null, null, null);
                                LDS.addFullStateFeedback(this.simpleSquareMatrix);
                            }
                            catch (RuntimeException e) {
                                if (e.getMessage() != "Matrix B must not be null for addFullStateFeedback!") break block16;
                                thrown = true;
                            }
                        }
                        Assert.assertTrue(thrown);
                        thrown = false;
                        try {
                            LDS = new LinearDynamicSystem(this.simpleSquareMatrix, null, null, this.simpleSquareMatrix);
                            LDS.addOutputStateFeedback(this.simpleSquareMatrix, this.simpleSquareMatrix);
                        }
                        catch (RuntimeException e) {
                            if (e.getMessage() != "Matrix B must not be null for addOutputStateFeedback!") break block17;
                            thrown = true;
                        }
                    }
                    Assert.assertTrue(thrown);
                    thrown = false;
                    try {
                        LDS = new LinearDynamicSystem(this.simpleSquareMatrix, this.simpleSquareMatrix, this.simpleSquareMatrix, this.simpleSquareMatrix);
                        LDS.addOutputStateFeedback(this.simpleSquareMatrix, this.simpleSquareMatrix);
                    }
                    catch (RuntimeException e) {
                        if (e.getMessage() != "Matrix D must be null for addOutputStateFeedback!") break block18;
                        thrown = true;
                    }
                }
                Assert.assertTrue(thrown);
                thrown = false;
                try {
                    LDS = new LinearDynamicSystem(this.simpleSquareMatrix, this.simpleSquareMatrix, null, null);
                    LDS.addOutputStateFeedback(this.simpleSquareMatrix, this.simpleSquareMatrix);
                }
                catch (RuntimeException e) {
                    if (e.getMessage() != "Matrix C must not be null for addOutputStateFeedback!") break block19;
                    thrown = true;
                }
            }
            Assert.assertTrue(thrown);
            thrown = false;
            try {
                LDS = new LinearDynamicSystem(this.simpleSquareMatrix, this.simpleSquareMatrix, this.simpleSquareMatrix, this.simpleSquareMatrix);
                double[] initCond = new double[this.simpleSquareMatrix.getColumnDimension() + 1];
                Random r = new Random();
                LDS.simulateInitialConditions(initCond, r.nextDouble(), r.nextInt());
            }
            catch (RuntimeException e) {
                if (e.getMessage() != "initialConditions.length != order") break block20;
                thrown = true;
            }
        }
    }

    @Test
    public void testMCSExampleOne() {
        double[][] elementsA = new double[][]{{2.0, -2.0, 3.0}, {1.0, 1.0, 1.0}, {1.0, 3.0, -1.0}};
        Matrix matrixA = new Matrix((double[][])elementsA);
        double[][] elementsB = new double[][]{{0.0, 1.0}, {1.0, 0.0}, {3.0, 2.0}};
        Matrix matrixB = new Matrix((double[][])elementsB);
        double[][] elementsC = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}};
        Matrix matrixC = new Matrix((double[][])elementsC);
        LinearDynamicSystem linearDynamicSystem = new LinearDynamicSystem(matrixA, null, null, null);
        TransferFunctionMatrix sIMinusAInverseMatrix = linearDynamicSystem.getTransferFunctionMatrix();
        ObsoletePolynomial sMinusOne = new ObsoletePolynomial(new double[]{1.0, -1.0});
        ObsoletePolynomial sMinusThree = new ObsoletePolynomial(new double[]{1.0, -3.0});
        ObsoletePolynomial sPlusTwo = new ObsoletePolynomial(new double[]{1.0, 2.0});
        ObsoletePolynomial denominatorTwo = sMinusOne.times(sMinusThree).times(sPlusTwo);
        ObsoletePolynomial numerator00 = new ObsoletePolynomial(1.0, 0.0, -4.0);
        ObsoletePolynomial numerator01 = new ObsoletePolynomial(-2.0, 7.0);
        ObsoletePolynomial numerator02 = new ObsoletePolynomial(3.0, -5.0);
        ObsoletePolynomial numerator10 = new ObsoletePolynomial(1.0, 2.0);
        ObsoletePolynomial numerator11 = new ObsoletePolynomial(1.0, -1.0, -5.0);
        ObsoletePolynomial numerator12 = new ObsoletePolynomial(1.0, 1.0);
        ObsoletePolynomial numerator20 = new ObsoletePolynomial(1.0, 2.0);
        ObsoletePolynomial numerator21 = new ObsoletePolynomial(3.0, -8.0);
        ObsoletePolynomial numerator22 = new ObsoletePolynomial(1.0, -3.0, 4.0);
        TransferFunction t00 = new TransferFunction(numerator00, denominatorTwo);
        TransferFunction t01 = new TransferFunction(numerator01, denominatorTwo);
        TransferFunction t02 = new TransferFunction(numerator02, denominatorTwo);
        TransferFunction t10 = new TransferFunction(numerator10, denominatorTwo);
        TransferFunction t11 = new TransferFunction(numerator11, denominatorTwo);
        TransferFunction t12 = new TransferFunction(numerator12, denominatorTwo);
        TransferFunction t20 = new TransferFunction(numerator20, denominatorTwo);
        TransferFunction t21 = new TransferFunction(numerator21, denominatorTwo);
        TransferFunction t22 = new TransferFunction(numerator22, denominatorTwo);
        TransferFunction[][] expectedSIMinusATransferFunctions = new TransferFunction[][]{{t00, t01, t02}, {t10, t11, t12}, {t20, t21, t22}};
        TransferFunctionMatrix expectedSIMinusAInverseMatrix = new TransferFunctionMatrix((TransferFunction[][])expectedSIMinusATransferFunctions);
        ComplexNumber complexNumber = new ComplexNumber(0.678, 1.234);
        ComplexMatrix evaluate1 = expectedSIMinusAInverseMatrix.evaluate(complexNumber);
        ComplexMatrix evaluate2 = sIMinusAInverseMatrix.evaluate(complexNumber);
        Assert.assertTrue(evaluate1.epsilonEquals(evaluate2, 1.0E-7));
        boolean passed = sIMinusAInverseMatrix.epsilonEquals(expectedSIMinusAInverseMatrix, 1.0E-7);
        Assert.assertTrue(passed);
        Matrix identity = Matrix.identity((int)3, (int)3);
        linearDynamicSystem.setMatrixB(identity);
        linearDynamicSystem.setMatrixC(identity);
        TransferFunctionMatrix sIMinusAInverseMatrix2 = linearDynamicSystem.getTransferFunctionMatrix();
        passed = sIMinusAInverseMatrix.epsilonEquals(sIMinusAInverseMatrix2, 1.0E-7);
        Assert.assertTrue(passed);
        linearDynamicSystem.setMatrixB(matrixB);
        linearDynamicSystem.setMatrixC(matrixC);
        linearDynamicSystem.setMatrixB(matrixB);
        linearDynamicSystem.setMatrixC(matrixC);
        TransferFunctionMatrix matrixG = linearDynamicSystem.getTransferFunctionMatrix();
        ObsoletePolynomial numeratorG00 = new ObsoletePolynomial(new double[]{7.0, -8.0});
        ObsoletePolynomial numeratorG01 = new ObsoletePolynomial(new double[]{1.0, 6.0, -14.0});
        ObsoletePolynomial numeratorG10 = new ObsoletePolynomial(new double[]{1.0, 2.0, -2.0});
        ObsoletePolynomial numeratorG11 = new ObsoletePolynomial(new double[]{3.0, 4.0});
        TransferFunction tG00 = new TransferFunction(numeratorG00, denominatorTwo);
        TransferFunction tG01 = new TransferFunction(numeratorG01, denominatorTwo);
        TransferFunction tG10 = new TransferFunction(numeratorG10, denominatorTwo);
        TransferFunction tG11 = new TransferFunction(numeratorG11, denominatorTwo);
        TransferFunction[][] expectedTransferFunctionsG = new TransferFunction[][]{{tG00, tG01}, {tG10, tG11}};
        TransferFunctionMatrix expectedMatrixG = new TransferFunctionMatrix((TransferFunction[][])expectedTransferFunctionsG);
        complexNumber = new ComplexNumber(0.0, 0.0);
        ComplexMatrix evaluateMatrixG = matrixG.evaluate(complexNumber);
        ComplexMatrix evaluateExpectedMatrixG = expectedMatrixG.evaluate(complexNumber);
        passed = evaluateMatrixG.epsilonEquals(evaluateExpectedMatrixG, 0.1);
        Assert.assertTrue(passed);
        passed = matrixG.epsilonEquals(expectedMatrixG, 1.0E-7);
    }

    @Test
    public void testMCSExampleTwo() {
        double[][] elementsA = new double[][]{{0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}, {-1.0, 1.0, 0.0, 0.0}, {1.0, -1.0, 0.0, 0.0}};
        Matrix matrixA = new Matrix((double[][])elementsA);
        double[][] elementsB = new double[][]{{0.0, 0.0}, {0.0, 0.0}, {1.0, 0.0}, {0.0, 1.0}};
        Matrix matrixB = new Matrix((double[][])elementsB);
        double[][] elementsC = new double[][]{{0.0, 1.0, 0.0, 0.0}};
        Matrix matrixC = new Matrix((double[][])elementsC);
        LinearDynamicSystem linearDynamicSystem = new LinearDynamicSystem(matrixA, null, null, null);
        TransferFunctionMatrix transferFunctionMatrix = linearDynamicSystem.getTransferFunctionMatrix();
        ObsoletePolynomial denominator = new ObsoletePolynomial(new double[]{1.0, 0.0, 2.0, 0.0, 0.0});
        TransferFunction[][] expectedTransferFunctions = new TransferFunction[4][4];
        expectedTransferFunctions[0][0] = new TransferFunction(new ObsoletePolynomial(1.0, 0.0, 1.0, 0.0), denominator);
        expectedTransferFunctions[0][1] = new TransferFunction(new ObsoletePolynomial(1.0, 0.0), denominator);
        expectedTransferFunctions[0][2] = new TransferFunction(new ObsoletePolynomial(1.0, 0.0, 1.0), denominator);
        expectedTransferFunctions[0][3] = new TransferFunction(new ObsoletePolynomial(1.0), denominator);
        expectedTransferFunctions[1][0] = new TransferFunction(new ObsoletePolynomial(1.0, 0.0), denominator);
        expectedTransferFunctions[1][1] = new TransferFunction(new ObsoletePolynomial(1.0, 0.0, 1.0, 0.0), denominator);
        expectedTransferFunctions[1][2] = new TransferFunction(new ObsoletePolynomial(1.0), denominator);
        expectedTransferFunctions[1][3] = new TransferFunction(new ObsoletePolynomial(1.0, 0.0, 1.0), denominator);
        expectedTransferFunctions[2][0] = new TransferFunction(new ObsoletePolynomial(-1.0, 0.0, 0.0), denominator);
        expectedTransferFunctions[2][1] = new TransferFunction(new ObsoletePolynomial(1.0, 0.0, 0.0), denominator);
        expectedTransferFunctions[2][2] = new TransferFunction(new ObsoletePolynomial(1.0, 0.0, 1.0, 0.0), denominator);
        expectedTransferFunctions[2][3] = new TransferFunction(new ObsoletePolynomial(1.0, 0.0), denominator);
        expectedTransferFunctions[3][0] = new TransferFunction(new ObsoletePolynomial(1.0, 0.0, 0.0), denominator);
        expectedTransferFunctions[3][1] = new TransferFunction(new ObsoletePolynomial(-1.0, 0.0, 0.0), denominator);
        expectedTransferFunctions[3][2] = new TransferFunction(new ObsoletePolynomial(1.0, 0.0), denominator);
        expectedTransferFunctions[3][3] = new TransferFunction(new ObsoletePolynomial(1.0, 0.0, 1.0, 0.0), denominator);
        TransferFunctionMatrix expectedTransferFunctionMatrix = new TransferFunctionMatrix(expectedTransferFunctions);
        boolean passed = expectedTransferFunctionMatrix.epsilonEquals(transferFunctionMatrix, 1.0E-7);
        Assert.assertTrue(passed);
        ObsoletePolynomial numerator0 = new ObsoletePolynomial(new double[]{1.0});
        ObsoletePolynomial numerator1 = new ObsoletePolynomial(new double[]{1.0, 0.0, 1.0});
        TransferFunction t0 = new TransferFunction(numerator0, denominator);
        TransferFunction t1 = new TransferFunction(numerator1, denominator);
        TransferFunction[][] expectedTransferFunctionsWithBAndC = new TransferFunction[][]{{t0, t1}};
        linearDynamicSystem = new LinearDynamicSystem(matrixA, matrixB, matrixC, null);
        transferFunctionMatrix = linearDynamicSystem.getTransferFunctionMatrix();
        expectedTransferFunctionMatrix = new TransferFunctionMatrix((TransferFunction[][])expectedTransferFunctionsWithBAndC);
        passed = expectedTransferFunctionMatrix.epsilonEquals(transferFunctionMatrix, 1.0E-7);
        Assert.assertTrue(passed);
        elementsB = new double[][]{{0.0}, {0.0}, {1.0}, {0.0}};
        matrixB = new Matrix((double[][])elementsB);
        linearDynamicSystem = new LinearDynamicSystem(matrixA, matrixB, matrixC, null);
        Matrix matrixG = new Matrix((double[][])new double[][]{{44.0, -19.0, 12.0, 48.0}});
        LinearDynamicSystem closedLoopSystem = linearDynamicSystem.addFullStateFeedback(matrixG);
        closedLoopSystem.getMatrixA();
        TransferFunctionMatrix closedLoopMatrix = closedLoopSystem.getTransferFunctionMatrix();
        ObsoletePolynomial characteristicEquation = closedLoopMatrix.get(0, 0).getDenominatorPolynomial();
        ObsoletePolynomial expectedCharacteristicEquation = new ObsoletePolynomial(new double[]{1.0, 12.0, 46.0, 60.0, 25.0});
        Assert.assertTrue(characteristicEquation.epsilonEquals(expectedCharacteristicEquation, 1.0E-7));
    }

    @Test
    public void testSimulateInitialConditions() {
        int i;
        double[] xi = new double[]{0.1, -0.01};
        int T1 = 1000;
        int T2 = 1000;
        int order = this.massSpringDamperMatrixA.getRowDimension();
        double[] xm = new double[order];
        double[] xf = new double[order];
        double[] expectedXf = new double[order];
        double[][] firstSimulation = this.massSpringDamperSystem.simulateInitialConditions(xi, 0.001, T1);
        for (int i2 = 0; i2 < order; ++i2) {
            xm[i2] = firstSimulation[T1 - 1][i2];
        }
        double[][] secondSimulation = this.massSpringDamperSystem.simulateInitialConditions(xm, 0.001, T2);
        for (int i3 = 0; i3 < order; ++i3) {
            xf[i3] = secondSimulation[T2 - 1][i3];
        }
        double[][] totalSimulation = this.massSpringDamperSystem.simulateInitialConditions(xi, 0.001, T1 + T2 - 1);
        for (i = 0; i < order; ++i) {
            expectedXf[i] = totalSimulation[T1 + T2 - 2][i];
        }
        for (i = 0; i < order; ++i) {
            Assert.assertEquals(expectedXf[i], xf[i], 1.0E-7);
        }
    }

    @Test
    public void testGetTransferFunctionMatrix() {
        TransferFunctionMatrix transferFunctions = this.simpleDecaySystem.getTransferFunctionMatrix();
        Assert.assertEquals(1L, transferFunctions.getRows());
        Assert.assertEquals(1L, transferFunctions.getColumns());
        TransferFunction transferFunction = transferFunctions.get(0, 0);
        TransferFunction expectedTransferFunction = new TransferFunction(new double[]{1.0}, new double[]{1.0, 1.0});
        Assert.assertTrue(transferFunction.epsilonEquals(expectedTransferFunction, 1.0E-7));
    }

    @Test
    public void testSimpleDecaySystem() {
        this.verifyLinearDynamicSystem(this.simpleDecaySystem, this.simpleDecayMatrixA);
    }

    @Test
    public void testMassSpringDamperSystem() {
        this.verifyLinearDynamicSystem(this.massSpringDamperSystem, this.massSpringDamperMatrixA);
    }

    @Test
    public void testRandomLinearDynamicSystems() {
        int numberOfRandomTests = 100;
        Random random = new Random(1776L);
        for (int i = 0; i < numberOfRandomTests; ++i) {
            Matrix matrixA = this.generateRandomMatrix(random, 5);
            LinearDynamicSystem linearDynamicSystem = new LinearDynamicSystem(matrixA, null, null, null);
            this.verifyLinearDynamicSystem(linearDynamicSystem, matrixA);
        }
    }

    private Matrix generateRandomMatrix(Random random, int maxOrder) {
        int order = random.nextInt(maxOrder) + 1;
        Matrix ret = new Matrix(order, order);
        for (int i = 0; i < order; ++i) {
            for (int j = 0; j < order; ++j) {
                ret.set(i, j, -20000.0 * random.nextDouble());
            }
        }
        return ret;
    }

    private void verifyLinearDynamicSystem(LinearDynamicSystem linearDynamicSystem, Matrix matrixA) {
        TransferFunctionMatrix transferFunctionMatrix = linearDynamicSystem.getTransferFunctionMatrix();
        int order = matrixA.getRowDimension();
        ComplexMatrix identity = ComplexMatrix.constructIdentity((int)order);
        for (double omega = 0.0; omega < 100.0; omega += 0.1) {
            ComplexMatrix transferFunctionAtJOmega;
            ComplexNumber jOmega = new ComplexNumber(0.0, omega);
            ComplexMatrix sIMinusA = identity.times(jOmega).minus(matrixA);
            ComplexMatrix sIMinusAInverse = sIMinusA.inverse();
            boolean testPassed = sIMinusAInverse.epsilonEquals(transferFunctionAtJOmega = transferFunctionMatrix.evaluate(jOmega), 0.1);
            if (!testPassed) {
                System.out.println("sIMinusAInverse = " + sIMinusAInverse);
                System.out.println("transferFunctionAtJOmega = " + transferFunctionAtJOmega);
            }
            Assert.assertTrue(testPassed);
        }
    }

    @Test
    public void testStateFeedbackMethods() {
        double[][] elementsA = new double[][]{{-10.0}};
        Matrix matrixA = new Matrix((double[][])elementsA);
        double[][] elementsB = new double[][]{{1.0}};
        Matrix matrixB = new Matrix((double[][])elementsB);
        double[][] elementsC = new double[][]{{1.0}};
        Matrix matrixC = new Matrix((double[][])elementsC);
        double[][] elementsK = new double[][]{{-10.0}};
        Matrix matrixK = new Matrix((double[][])elementsK);
        double[][] elementsIC = new double[][]{{0.0}};
        Matrix matrixIC = new Matrix((double[][])elementsIC);
        double u = 1.5;
        int numTicks = 4000;
        double stepSize = 0.001;
        LinearDynamicSystem sysA = new LinearDynamicSystem(matrixA, matrixB, matrixC, null);
        LinearDynamicSystem closedLoopSysA = sysA.addOutputStateFeedback(matrixK);
        double y = this.verifySimulateOutput(closedLoopSysA, matrixIC, u, stepSize, numTicks);
        double expectedY = (double)numTicks * stepSize * u;
        Assert.assertEquals(expectedY, y, 1.0E-7);
        matrixA.set(0, 0, -10.0);
        matrixB.set(0, 0, 2.0);
        matrixC.set(0, 0, 1.0);
        LinearDynamicSystem sysB = new LinearDynamicSystem(matrixA, matrixB, matrixC, null);
        matrixK.set(0, 0, -5.0);
        double[][] elementsKr = new double[][]{{0.5}};
        Matrix matrixKr = new Matrix((double[][])elementsKr);
        LinearDynamicSystem closedLoopSysB = sysB.addOutputStateFeedback(matrixK, matrixKr);
        y = this.verifySimulateOutput(closedLoopSysB, matrixIC, u, stepSize, numTicks);
        expectedY = (double)numTicks * stepSize * u;
        Assert.assertEquals(expectedY, y, 1.0E-7);
    }

    private double verifySimulateOutput(LinearDynamicSystem Sys, Matrix InitialCondition, double input, double stepSize, int numTicks) {
        Matrix closedLoopMatrixA = Sys.getMatrixA();
        Matrix closedLoopMatrixB = Sys.getMatrixB();
        Matrix closedLoopMatrixC = Sys.getMatrixC();
        Matrix state = new Matrix(1, 1);
        state = InitialCondition.copy();
        for (int i = 0; i < numTicks; ++i) {
            Matrix aTimesX = closedLoopMatrixA.times(state);
            Matrix bTimesU = closedLoopMatrixB.times(input);
            Matrix dotX = aTimesX.plus(bTimesU);
            state = state.plus(dotX.times(stepSize));
        }
        double y = closedLoopMatrixC.times(state).get(0, 0);
        return y;
    }

    @Test
    public void testEulerIntegrateSpringDamper() {
        double epsilon = 1.0E-7;
        double k = 100.0;
        double b = 10.0;
        double[][] elementsA = new double[][]{{0.0, 1.0}, {-k, -b}};
        double[][] elementsB = new double[][]{{0.0}, {1.0}};
        double[][] elementsC = new double[][]{{1.0, 0.0}};
        double[][] elementsD = new double[][]{{0.0}};
        Matrix matrixA = new Matrix((double[][])elementsA);
        Matrix matrixB = new Matrix((double[][])elementsB);
        Matrix matrixC = new Matrix((double[][])elementsC);
        Matrix matrixD = new Matrix((double[][])elementsD);
        LinearDynamicSystem system = new LinearDynamicSystem(matrixA, matrixB, matrixC, matrixD);
        double stepSize = 0.001;
        double[] currentState = new double[]{1.0, 0.0};
        double[] input = new double[]{0.0};
        currentState = system.eulerIntegrateOneStep(currentState, input, stepSize);
        double[] output = system.getOutputFromState(currentState, input);
        Assert.assertEquals(1L, output.length);
        Assert.assertEquals(1.0, output[0], epsilon);
        currentState = system.eulerIntegrateOneStep(currentState, input, stepSize);
        output = system.getOutputFromState(currentState, input);
        Assert.assertEquals(0.9999, output[0], epsilon);
        currentState = system.eulerIntegrateOneStep(currentState, input, stepSize);
        output = system.getOutputFromState(currentState, input);
        Assert.assertEquals(0.999701, output[0], epsilon);
    }

    @Test
    public void testEulerIntegrateMIMO() {
        double epsilon = 1.0E-7;
        double[][] elementsA = new double[][]{{0.1, 0.2, 0.3, 0.123}, {0.4, 0.5, 0.6, -0.222}, {0.7, 0.8, 0.9, -1.734}, {0.11, 0.22, 0.33, 0.44}};
        double[][] elementsB = new double[][]{{0.17, 0.94, 0.25}, {0.33, 0.55, -0.66}, {-0.17, 0.45, 0.123}, {0.137, 0.15, 0.223}};
        double[][] elementsC = new double[][]{{1.0, 2.0, 3.0, -4.0}, {5.0, 6.0, 7.0, 8.0}};
        double[][] elementsD = new double[][]{{0.123, 0.456, 0.789}, {-0.123, 0.256, -0.189}};
        Matrix matrixA = new Matrix((double[][])elementsA);
        Matrix matrixB = new Matrix((double[][])elementsB);
        Matrix matrixC = new Matrix((double[][])elementsC);
        Matrix matrixD = new Matrix((double[][])elementsD);
        LinearDynamicSystem system = new LinearDynamicSystem(matrixA, matrixB, matrixC, matrixD);
        double stepSize = 0.001;
        double[] currentState = new double[]{1.0, 0.0, 0.0, 0.0};
        double[] input = new double[]{0.1, 0.2, 0.3};
        currentState = system.eulerIntegrateOneStep(currentState, input, stepSize);
        double[] output = system.getOutputFromState(currentState, input);
        Assert.assertEquals(2L, output.length);
        Assert.assertEquals(1.3428173, output[0], epsilon);
        currentState = system.eulerIntegrateOneStep(currentState, input, stepSize);
        output = system.getOutputFromState(currentState, input);
        Assert.assertEquals(1.3454372370822003, output[0], epsilon);
        currentState = system.eulerIntegrateOneStep(currentState, input, stepSize);
        output = system.getOutputFromState(currentState, input);
        Assert.assertEquals(1.348059813331106, output[0], epsilon);
    }
}

