/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearDynamicSystems;

import Jama.Matrix;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.dataStructures.ComplexNumber;
import us.ihmc.robotics.linearDynamicSystems.ComplexMatrix;

public class ComplexMatrixTest {
    private final double[][][] realElements = new double[][][]{new double[][]{{1.0, 0.0}, {2.0, 0.0}}, new double[][]{{3.0, 0.0}, {4.0, 0.0}}};
    private final double[][][] singleElements = new double[][][]{new double[][]{{1.0, 1.0}}};
    private final double[][][] complexElements = new double[][][]{new double[][]{{1.0, 7.0}, {2.0, 9.0}}, new double[][]{{3.0, 11.0}, {4.0, 15.0}}};
    private final double[][][] threeByFourElements = new double[][][]{new double[][]{{1.0, 7.0}, {2.0, 9.0}, {2.0, 9.0}, {-0.88, 1.9}}, new double[][]{{3.0, 11.0}, {4.0, 5.0}, {2.0, 9.0}, {1.1, 1.9}}, new double[][]{{3.0, 19.0}, {4.0, 15.0}, {2.0, 39.0}, {1.1, 1.9}}};
    private ComplexMatrix realExample;
    private ComplexMatrix singleComplexNumber;
    private ComplexMatrix complexExample;
    private ComplexMatrix threeByFour;
    private ComplexMatrix identityOne;
    private ComplexMatrix identityFour;
    private ComplexMatrix[] allExamples;

    @BeforeEach
    public void setUp() throws Exception {
        this.realExample = new ComplexMatrix(this.realElements);
        this.singleComplexNumber = new ComplexMatrix(this.singleElements);
        this.complexExample = new ComplexMatrix(this.complexElements);
        this.threeByFour = new ComplexMatrix(this.threeByFourElements);
        this.identityOne = ComplexMatrix.constructIdentity((int)1);
        this.identityFour = ComplexMatrix.constructIdentity((int)4);
        this.allExamples = new ComplexMatrix[]{this.realExample, this.singleComplexNumber, this.complexExample, this.threeByFour, this.identityOne, this.identityFour};
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.realExample = null;
        this.singleComplexNumber = null;
        this.complexExample = null;
        this.threeByFour = null;
        this.identityOne = null;
        this.identityFour = null;
        this.allExamples = null;
    }

    @Test
    public void testIdentity() {
        Assert.assertTrue(this.identityOne.epsilonEquals(new Matrix((double[][])new double[][]{{1.0}}), 1.0E-7));
    }

    @Test
    public void testGetRowAndColumnDimensions() {
        Assert.assertEquals(2L, this.realExample.getRowDimension());
        Assert.assertEquals(2L, this.realExample.getColumnDimension());
        Assert.assertEquals(1L, this.singleComplexNumber.getRowDimension());
        Assert.assertEquals(1L, this.singleComplexNumber.getColumnDimension());
        Assert.assertEquals(2L, this.complexExample.getRowDimension());
        Assert.assertEquals(2L, this.complexExample.getColumnDimension());
        Assert.assertEquals(1L, this.identityOne.getRowDimension());
        Assert.assertEquals(1L, this.identityOne.getColumnDimension());
        Assert.assertEquals(4L, this.identityFour.getRowDimension());
        Assert.assertEquals(4L, this.identityFour.getColumnDimension());
        Assert.assertEquals(3L, this.threeByFour.getRowDimension());
        Assert.assertEquals(4L, this.threeByFour.getColumnDimension());
    }

    @Test
    public void testEpsilonEquals() {
        for (int i = 0; i < this.allExamples.length; ++i) {
            for (int j = 0; j < this.allExamples.length; ++j) {
                if (i == j) {
                    Assert.assertTrue(this.allExamples[i].epsilonEquals(this.allExamples[j], 1.0E-7));
                    continue;
                }
                Assert.assertFalse(this.allExamples[i].epsilonEquals(this.allExamples[j], 1.0E-7));
            }
        }
    }

    @Test
    public void testConstructDiagonalMatrix() {
        ComplexNumber[] diagonalElements = new ComplexNumber[]{new ComplexNumber(1.0, 2.0), new ComplexNumber(3.0, 4.0)};
        ComplexMatrix matrix = ComplexMatrix.constructDiagonalMatrix((ComplexNumber[])diagonalElements);
        int numRows = matrix.getRowDimension();
        int numColumns = matrix.getColumnDimension();
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                if (i == j) {
                    Assert.assertTrue(diagonalElements[i].epsilonEquals(matrix.get(i, j), 1.0E-7));
                    continue;
                }
                Assert.assertTrue(matrix.get(i, j).epsilonEquals(0.0, 1.0E-7));
            }
        }
    }

    @Test
    public void testTranspose() {
        ComplexMatrix fourByThree = this.threeByFour.transpose();
        Assert.assertEquals(4L, fourByThree.getRowDimension());
        Assert.assertEquals(3L, fourByThree.getColumnDimension());
        int numRows = this.threeByFour.getRowDimension();
        int numColumns = this.threeByFour.getColumnDimension();
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                Assert.assertFalse(this.threeByFour.get(i, j) == fourByThree.get(j, i));
                Assert.assertTrue(this.threeByFour.get(i, j).epsilonEquals(fourByThree.get(j, i), 0.0));
            }
        }
    }

    @Test
    public void testTimes() {
        double timesByReal = 7.11;
        ComplexNumber timesByComplex = new ComplexNumber(8.23, 11.1);
        this.verifyTimes(this.threeByFour, new ComplexNumber(timesByReal, 0.0), this.threeByFour.times(timesByReal));
        this.verifyTimes(this.threeByFour, timesByComplex, this.threeByFour.times(timesByComplex));
    }

    private void verifyTimes(ComplexMatrix original, ComplexNumber timesBy, ComplexMatrix result) {
        Assert.assertEquals(original.getRowDimension(), result.getRowDimension());
        Assert.assertEquals(original.getColumnDimension(), result.getColumnDimension());
        for (int i = 0; i < result.getRowDimension(); ++i) {
            for (int j = 0; j < result.getColumnDimension(); ++j) {
                Assert.assertTrue(original.get(i, j).times(timesBy).epsilonEquals(result.get(i, j), 1.0E-7));
            }
        }
    }

    @Test
    public void testMatrixTimes() {
        ComplexMatrix fourByThree = this.threeByFour.transpose();
        ComplexMatrix result = this.threeByFour.times(fourByThree);
        Assert.assertEquals(3L, result.getRowDimension());
        Assert.assertEquals(3L, result.getColumnDimension());
        ComplexNumber result00 = this.threeByFour.get(0, 0).times(fourByThree.get(0, 0)).plus(this.threeByFour.get(0, 1).times(fourByThree.get(1, 0))).plus(this.threeByFour.get(0, 2).times(fourByThree.get(2, 0))).plus(this.threeByFour.get(0, 3).times(fourByThree.get(3, 0)));
        ComplexNumber result12 = this.threeByFour.get(1, 0).times(fourByThree.get(0, 2)).plus(this.threeByFour.get(1, 1).times(fourByThree.get(1, 2))).plus(this.threeByFour.get(1, 2).times(fourByThree.get(2, 2))).plus(this.threeByFour.get(1, 3).times(fourByThree.get(3, 2)));
        Assert.assertTrue(result00.epsilonEquals(result.get(0, 0), 1.0E-7));
        Assert.assertTrue(result12.epsilonEquals(result.get(1, 2), 1.0E-7));
    }

    @Test
    public void testInverse() {
        ComplexMatrix fourByThree = this.threeByFour.transpose();
        ComplexMatrix threeByThree = this.threeByFour.times(fourByThree);
        ComplexMatrix threeByThreeInverse = threeByThree.inverse();
        ComplexMatrix identityOne = threeByThree.times(threeByThreeInverse);
        ComplexMatrix identityTwo = threeByThreeInverse.times(threeByThree);
        ComplexMatrix identity = ComplexMatrix.constructIdentity((int)3);
        Assert.assertTrue(identity.epsilonEquals(identityOne, 1.0E-7));
        Assert.assertTrue(identity.epsilonEquals(identityTwo, 1.0E-7));
    }
}

