/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra.careSolvers.schur;

import java.util.Random;
import org.ejml.EjmlUnitTests;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.matrixlib.NativeCommonOps;
import us.ihmc.robotics.linearAlgebra.careSolvers.schur.QRBasedSchurDecomposition;

public class QRBasedSchurDecompositionTest {
    private static double epsilon = 1.0E-8;
    private static int iters = 100;

    @Test
    public void testEasy() {
        DMatrixRMaj A = new DMatrixRMaj(3, 3);
        A.set(0, 0, 3.0);
        A.set(0, 1, 2.0);
        A.set(0, 2, 1.0);
        A.set(1, 0, 4.0);
        A.set(1, 1, 2.0);
        A.set(1, 2, 1.0);
        A.set(2, 0, 4.0);
        A.set(2, 1, 4.0);
        DMatrixRMaj AExpected = new DMatrixRMaj(A);
        QRBasedSchurDecomposition schur = new QRBasedSchurDecomposition(3);
        schur.setMaxIterations(1000000);
        schur.decompose(A);
        DMatrixRMaj U = schur.getU(null);
        DMatrixRMaj T = schur.getT(null);
        QRBasedSchurDecompositionTest.assertDecompositionHolds(A, U, T);
        EjmlUnitTests.assertEquals((DMatrix)AExpected, (DMatrix)A, (double)epsilon);
    }

    @Test
    public void testRandom() {
        QRBasedSchurDecomposition schur = new QRBasedSchurDecomposition(3);
        schur.setMaxIterations(10000);
        Random random = new Random(1738L);
        for (int i = 0; i < iters; ++i) {
            int rows = RandomNumbers.nextInt((Random)random, (int)1, (int)10);
            DMatrixRMaj A = new DMatrixRMaj(rows, rows);
            A.setData(RandomNumbers.nextDoubleArray((Random)random, (int)(rows * rows), (double)100.0));
            DMatrixRMaj AExpected = new DMatrixRMaj(A);
            schur.decompose(A);
            DMatrixRMaj U = schur.getU(null);
            DMatrixRMaj T = schur.getT(null);
            QRBasedSchurDecompositionTest.assertDecompositionHolds(A, U, T);
            EjmlUnitTests.assertEquals((DMatrix)AExpected, (DMatrix)A, (double)epsilon);
        }
    }

    private static void assertDecompositionHolds(DMatrixRMaj Aexpected, DMatrixRMaj U, DMatrixRMaj T) {
        DMatrixRMaj UTranspose = new DMatrixRMaj(U);
        CommonOps_DDRM.transpose((DMatrixRMaj)U, (DMatrixRMaj)UTranspose);
        DMatrixRMaj A = new DMatrixRMaj(Aexpected);
        NativeCommonOps.multQuad((DMatrix1Row)UTranspose, (DMatrix1Row)T, (DMatrix1Row)A);
        EjmlUnitTests.assertEquals((DMatrix)Aexpected, (DMatrix)A, (double)epsilon);
    }
}

