/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra.careSolvers;

import java.util.Random;
import org.ejml.EjmlUnitTests;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.robotics.linearAlgebra.careSolvers.CARESolverTestTools;
import us.ihmc.robotics.linearAlgebra.careSolvers.LyapunovEquationSolver;

public class LyapunovSolverTest {
    private static final double epsilon = 1.0E-7;
    private static final int iters = 100;

    @Test
    public void testRandom() {
        LyapunovEquationSolver solver = new LyapunovEquationSolver();
        Random random = new Random(1738L);
        for (int iter = 0; iter < 100; ++iter) {
            int size = RandomNumbers.nextInt((Random)random, (int)1, (int)10);
            DMatrixRMaj A = CARESolverTestTools.generateRandomSymmetricPDMatrix(random, size);
            DMatrixRMaj Q = CARESolverTestTools.generateRandomSymmetricPDMatrix(random, size);
            DMatrixRMaj AOriginal = new DMatrixRMaj(A);
            DMatrixRMaj QOriginal = new DMatrixRMaj(Q);
            solver.setMatrices(A, Q);
            solver.solve();
            DMatrixRMaj X = solver.getX();
            DMatrixRMaj constructedQ = new DMatrixRMaj(size, size);
            CommonOps_DDRM.multTransA((DMatrix1Row)A, (DMatrix1Row)X, (DMatrix1Row)constructedQ);
            CommonOps_DDRM.multAdd((DMatrix1Row)X, (DMatrix1Row)A, (DMatrix1Row)constructedQ);
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)constructedQ);
            EjmlUnitTests.assertEquals((DMatrix)AOriginal, (DMatrix)A, (double)1.0E-7);
            EjmlUnitTests.assertEquals((DMatrix)QOriginal, (DMatrix)Q, (double)1.0E-7);
            EjmlUnitTests.assertEquals((DMatrix)constructedQ, (DMatrix)Q, (double)1.0E-7);
        }
    }
}

