/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra;

import java.util.Random;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.linearAlgebra.MatrixExponentialCalculator;

public class MatrixExponentialCalculatorTest {
    @Test
    public void testAgainstTaylorSeries() {
        int size = 50;
        Random random = new Random(125L);
        MatrixExponentialCalculator matrixExponentialCalculator = new MatrixExponentialCalculator(size);
        DMatrixRMaj A = RandomMatrices_DDRM.rectangle((int)size, (int)size, (Random)random);
        CommonOps_DDRM.scale((double)(1.0 / (double)size), (DMatrixD1)A);
        DMatrixRMaj result = new DMatrixRMaj(size, size);
        matrixExponentialCalculator.compute(result, A);
        DMatrixRMaj taylorSeriesCheck = new DMatrixRMaj(size, size);
        MatrixExponentialCalculatorTest.computeMatrixExponentialThroughTaylorSeries(taylorSeriesCheck, A, 15);
        Assert.assertTrue(MatrixFeatures_DDRM.isIdentical((DMatrixD1)taylorSeriesCheck, (DMatrixD1)result, (double)1.0E-6));
    }

    @Disabled
    @Test
    public void testEfficiency() {
        int size = 50;
        Random random = new Random(125L);
        MatrixExponentialCalculator matrixExponentialCalculator = new MatrixExponentialCalculator(size);
        DMatrixRMaj A = new DMatrixRMaj(size, size);
        DMatrixRMaj result = new DMatrixRMaj(size, size);
        int nTestsWarmup = 1000;
        for (int i = 0; i < nTestsWarmup; ++i) {
            RandomMatrices_DDRM.fillUniform((DMatrixRMaj)A, (Random)random);
            CommonOps_DDRM.scale((double)0.005, (DMatrixD1)A);
            matrixExponentialCalculator.compute(result, A);
        }
        int nTests = 10000;
        long totalTimeMillis = 0L;
        for (int i = 0; i < nTests; ++i) {
            RandomMatrices_DDRM.fillUniform((DMatrixRMaj)A, (Random)random);
            CommonOps_DDRM.scale((double)0.005, (DMatrixD1)A);
            long startMillis = System.currentTimeMillis();
            matrixExponentialCalculator.compute(result, A);
            long stopMillis = System.currentTimeMillis();
            totalTimeMillis += stopMillis - startMillis;
        }
        double totalTimeMillisPerTest = (double)totalTimeMillis / (double)nTests;
        System.out.println(totalTimeMillisPerTest);
    }

    private static void computeMatrixExponentialThroughTaylorSeries(DMatrixRMaj result, DMatrixRMaj A, int n) {
        DMatrixRMaj tempPower = new DMatrixRMaj(A.getNumRows(), A.getNumCols());
        DMatrixRMaj tempExponentialTerm = new DMatrixRMaj(A.getNumRows(), A.getNumCols());
        CommonOps_DDRM.setIdentity((DMatrix1Row)result);
        CommonOps_DDRM.setIdentity((DMatrix1Row)tempPower);
        int factorial = 1;
        for (int i = 1; i < n; ++i) {
            CommonOps_DDRM.mult((DMatrix1Row)A, (DMatrix1Row)tempPower, (DMatrix1Row)tempExponentialTerm);
            tempPower.set((DMatrixD1)tempExponentialTerm);
            CommonOps_DDRM.scale((double)(1.0 / (double)(factorial *= i)), (DMatrixD1)tempExponentialTerm);
            CommonOps_DDRM.addEquals((DMatrixD1)result, (DMatrixD1)tempExponentialTerm);
        }
    }
}

