/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra;

import java.util.Random;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.PrintTools;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.robotics.linearAlgebra.DampedLeastSquaresNullspaceCalculator;
import us.ihmc.robotics.linearAlgebra.DampedQRNullspaceCalculator;
import us.ihmc.robotics.linearAlgebra.DampedSVDNullspaceCalculator;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.yoVariables.registry.YoRegistry;

public class DampedNullspaceCalculatorTimingTest {
    @Test
    public void testTimings() {
        YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
        ExecutionTimer svdTimer = new ExecutionTimer("svdTimer", registry);
        ExecutionTimer leastSquaresTimer = new ExecutionTimer("leastSquaresTimer", registry);
        ExecutionTimer qrTimer = new ExecutionTimer("qrTimer", registry);
        DampedSVDNullspaceCalculator svdCalculator = new DampedSVDNullspaceCalculator(100, 0.1);
        DampedLeastSquaresNullspaceCalculator leastSquaresCalculator = new DampedLeastSquaresNullspaceCalculator(100, 0.1);
        DampedQRNullspaceCalculator qrCalculator = new DampedQRNullspaceCalculator(100, 0.1);
        svdCalculator.setPseudoInverseAlpha(0.1);
        leastSquaresCalculator.setPseudoInverseAlpha(0.1);
        Random random = new Random(10L);
        for (int j = 0; j < 100; ++j) {
            int Jcolumns = RandomNumbers.nextInt((Random)random, (int)5, (int)100);
            int Jrows = RandomNumbers.nextInt((Random)random, (int)1, (int)Jcolumns);
            int ARows = RandomNumbers.nextInt((Random)random, (int)1, (int)Jcolumns);
            double[] Jvalues = RandomNumbers.nextDoubleArray((Random)random, (int)(Jrows * Jcolumns), (double)10.0);
            double[] Avalues = RandomNumbers.nextDoubleArray((Random)random, (int)(ARows * Jcolumns), (double)10.0);
            for (int i = 0; i < 100; ++i) {
                DMatrixRMaj J = new DMatrixRMaj(Jrows, Jcolumns, false, Jvalues);
                DMatrixRMaj A = new DMatrixRMaj(ARows, Jcolumns, false, Avalues);
                DMatrixRMaj A_projected1 = new DMatrixRMaj(ARows, Jcolumns, false, Avalues);
                DMatrixRMaj A_projected2 = new DMatrixRMaj(ARows, Jcolumns, false, Avalues);
                DMatrixRMaj A_projected3 = new DMatrixRMaj(ARows, Jcolumns, false, Avalues);
                svdTimer.startMeasurement();
                svdCalculator.projectOntoNullspace(A, J, A_projected1);
                svdTimer.stopMeasurement();
                leastSquaresTimer.startMeasurement();
                leastSquaresCalculator.projectOntoNullspace(A, J, A_projected2);
                leastSquaresTimer.stopMeasurement();
                qrTimer.startMeasurement();
                qrCalculator.projectOntoNullspace(A, J, A_projected3);
                qrTimer.stopMeasurement();
            }
        }
        PrintTools.info((String)("SVD average time : " + svdTimer.getAverageTime()));
        PrintTools.info((String)("Least Squares average time : " + leastSquaresTimer.getAverageTime()));
        PrintTools.info((String)("QR average time : " + qrTimer.getAverageTime()));
    }
}

