/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.hyperCubeTree;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.hyperCubeTree.HyperCubeLeaf;
import us.ihmc.robotics.hyperCubeTree.HyperCubeNode;
import us.ihmc.robotics.hyperCubeTree.HyperCubeTreeListener;
import us.ihmc.robotics.hyperCubeTree.OneDimensionalBounds;

public class HyperCubeNodeTest {
    public static final double eps = 1.0E-6;

    @Test
    public void testAssumptions() {
        boolean[] sides;
        Assert.assertEquals(6L, 6L);
        Assert.assertEquals(7L, 7L);
        int index = 0;
        for (boolean side : sides = new boolean[]{true, true, true}) {
            index = (index << 1) + (side ? 1 : 0);
        }
        Assert.assertTrue(index == 7);
    }

    @Test
    public void testToIndex() {
        int dimensionality = 3;
        HyperCubeNode<Double, Void> node = this.setupDoubleNode(dimensionality);
        boolean[] sides = new boolean[]{true, true, true};
        int index = node.toIndex(sides);
        Assert.assertEquals(7L, index);
        sides = new boolean[]{false, true, true};
        index = node.toIndex(sides);
        Assert.assertEquals(3L, index);
        sides = new boolean[]{false, true, false};
        index = node.toIndex(sides);
        Assert.assertEquals(2L, index);
    }

    @Test
    public void testToBooleanArray() {
        int dimensionality = 3;
        HyperCubeNode<Boolean, Void> node = this.setupBooleanNode(dimensionality);
        boolean[] sides = new boolean[]{true, true, false};
        int index = node.toIndex(sides);
        Assert.assertEquals(6L, index);
        boolean[] recreatedSides = node.toBooleanArray(index);
        for (int i = 0; i < dimensionality; ++i) {
            Assert.assertEquals(sides[i], recreatedSides[i]);
        }
        sides = new boolean[]{false, true, true};
        index = node.toIndex(sides);
        Assert.assertEquals(3L, index);
        sides = new boolean[]{false, true, false};
        index = node.toIndex(sides);
        Assert.assertEquals(2L, index);
    }

    private HyperCubeNode<Double, Void> setupDoubleNode(int dimensionality) {
        OneDimensionalBounds[] bounds = new OneDimensionalBounds[dimensionality];
        for (int i = 0; i < dimensionality; ++i) {
            bounds[i] = new OneDimensionalBounds(Double.valueOf(0.0), Double.valueOf(1.0));
        }
        HyperCubeNode node = new HyperCubeNode(bounds, "Node", new NullListener());
        return node;
    }

    private HyperCubeNode<Boolean, Void> setupBooleanNode(int dimensionality) {
        OneDimensionalBounds[] bounds = new OneDimensionalBounds[dimensionality];
        for (int i = 0; i < dimensionality; ++i) {
            bounds[i] = new OneDimensionalBounds(Double.valueOf(0.0), Double.valueOf(1.0));
        }
        HyperCubeNode node = new HyperCubeNode(bounds, "Node", new NullListener());
        return node;
    }

    @Test
    public void testLocatePoint() {
        int dimensionality = 3;
        HyperCubeNode<Double, Void> node = this.setupDoubleNode(dimensionality);
        double[] point = new double[]{0.25, 0.6, 0.6};
        int expectation = 3;
        boolean[] sides = node.locatePoint(point);
        int index = node.toIndex(sides);
        Assert.assertEquals(expectation, index);
        point = new double[]{0.5, 0.5, 1.0};
        expectation = 7;
        sides = node.locatePoint(point);
        index = node.toIndex(sides);
        Assert.assertEquals(expectation, index);
        point = new double[]{0.499, 0.499, 0.499};
        expectation = 0;
        sides = node.locatePoint(point);
        index = node.toIndex(sides);
        Assert.assertEquals(expectation, index);
    }

    @Test
    public void testIndexing() {
        int dimensionality = 12;
        HyperCubeNode<Double, Void> node = this.setupDoubleNode(dimensionality);
        for (int i = 0; i < 1 << dimensionality; ++i) {
            boolean[] sides = node.toBooleanArray(i);
            int index = node.toIndex(sides);
            Assert.assertEquals(i, index);
        }
    }

    @Test
    public void testWithinBounds() {
        OneDimensionalBounds[] bounds = new OneDimensionalBounds[]{new OneDimensionalBounds(Double.valueOf(-0.35), Double.valueOf(-0.1)), new OneDimensionalBounds(Double.valueOf(57.6), Double.valueOf(65.3))};
        double[] test1 = new double[]{2.3, 59.9};
        double[] test2 = new double[]{-0.2, 60.5};
        double[] test3 = new double[]{-99.2, 69.5};
        Assert.assertFalse(HyperCubeNode.withinBounds((OneDimensionalBounds[])bounds, (double[])test1));
        Assert.assertTrue(HyperCubeNode.withinBounds((OneDimensionalBounds[])bounds, (double[])test2));
        Assert.assertFalse(HyperCubeNode.withinBounds((OneDimensionalBounds[])bounds, (double[])test3));
    }

    @Test
    public void testSubdivideBounds() {
        int dimensionality = 3;
        HyperCubeNode<Double, Void> node = this.setupDoubleNode(dimensionality);
        OneDimensionalBounds[] subBounds = node.subdivideBounds(new boolean[]{true, false, false});
        Assert.assertEquals(0.5, subBounds[0].min(), 1.0E-6);
        Assert.assertEquals(1.0, subBounds[0].max(), 1.0E-6);
        Assert.assertEquals(0.0, subBounds[1].min(), 1.0E-6);
        Assert.assertEquals(0.5, subBounds[1].max(), 1.0E-6);
        Assert.assertEquals(0.0, subBounds[2].min(), 1.0E-6);
        Assert.assertEquals(0.5, subBounds[2].max(), 1.0E-6);
    }

    @Test
    public void testSplit() {
        for (int i = 1; i < 11; ++i) {
            HyperCubeNode<Double, Void> node = this.setupDoubleNode(i);
            node.split();
            Assert.assertEquals(true, node.hasChildren());
            Assert.assertEquals(1 << i, node.getChildNumber());
            for (int j = 0; j < 1 << i; ++j) {
                Assert.assertTrue(node.getChild(j) != null);
            }
        }
    }

    @Test
    public void testReplaceLeaf() {
        int dimensionality = 3;
        HyperCubeNode<Double, Void> node = this.setupDoubleNode(dimensionality);
        double leafValue = 0.78;
        Assert.assertNull(node.getLeaf());
        node.setLeaf(new HyperCubeLeaf((Object)leafValue, new double[]{0.0, 0.5, 0.5}));
        Assert.assertEquals(leafValue, (Double)node.getLeaf().getValue(), 1.0E-6);
    }

    public static class NullListener<T, D>
    implements HyperCubeTreeListener<T, D> {
        public void nodeAdded(String id, OneDimensionalBounds[] bounds, HyperCubeLeaf<T> leaf) {
        }

        public void nodeRemoved(String id) {
        }

        public void leafAdded(HyperCubeLeaf<T> leaf) {
        }

        public void treeCleared() {
        }

        public void metaDataUpdated(String id, OneDimensionalBounds[] bounds, D data) {
        }
    }
}

