/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.graphics;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPolynomial3D;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoGraphicPolynomial3DTest {
    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testRemoteYoGraphicVariableOrdering() {
        Random random = new Random(345345L);
        for (int iteration = 0; iteration < 10; ++iteration) {
            String name = "writer";
            YoRegistry registry = new YoRegistry("writerRegistry");
            int numberOfPolynomials = random.nextInt(20) + 3;
            YoFramePose3D poseToPolynomialFrame = new YoFramePose3D(name + "Pose", ReferenceFrame.getWorldFrame(), registry);
            ArrayList<YoPolynomial3D> yoPolynomial3Ds = new ArrayList<YoPolynomial3D>();
            ArrayList<YoDouble> waypointTimes = new ArrayList<YoDouble>();
            for (int i = 0; i < numberOfPolynomials; ++i) {
                int maxsize = random.nextInt(20) + 1;
                YoPolynomial xPolynomial = new YoPolynomial(name + "XPoly" + i, maxsize, registry);
                YoPolynomial yPolynomial = new YoPolynomial(name + "YPoly" + i, maxsize, registry);
                YoPolynomial zPolynomial = new YoPolynomial(name + "ZPoly" + i, maxsize, registry);
                yoPolynomial3Ds.add(new YoPolynomial3D(xPolynomial, yPolynomial, zPolynomial));
                waypointTimes.add(new YoDouble(name + "WaypointTime" + i, registry));
            }
            double radius = random.nextDouble();
            int resolution = RandomNumbers.nextInt((Random)random, (int)1, (int)50);
            int radialResolution = RandomNumbers.nextInt((Random)random, (int)1, (int)50);
            YoGraphicPolynomial3D yoGraphicWriter = new YoGraphicPolynomial3D(name, poseToPolynomialFrame, yoPolynomial3Ds, waypointTimes, radius, resolution, radialResolution, registry);
            Object[] allWriterYoVariables = yoGraphicWriter.getVariables();
            double[] allWriterConstants = new double[yoGraphicWriter.getConstants().length];
            for (int i = 0; i < yoGraphicWriter.getConstants().length; ++i) {
                allWriterConstants[i] = yoGraphicWriter.getConstants()[i];
            }
            YoGraphicPolynomial3D yoGraphicReader = YoGraphicPolynomial3D.createAsRemoteYoGraphic((String)"reader", (YoVariable[])allWriterYoVariables, (double[])allWriterConstants);
            Object[] allReaderYoVariables = yoGraphicReader.getVariables();
            double[] allReaderConstants = new double[yoGraphicReader.getConstants().length];
            for (int i = 0; i < yoGraphicReader.getConstants().length; ++i) {
                allReaderConstants[i] = yoGraphicReader.getConstants()[i];
            }
            Assert.assertArrayEquals(allWriterYoVariables, allReaderYoVariables);
            Assert.assertArrayEquals(allWriterConstants, allReaderConstants, 1.0E-7);
        }
    }
}

