/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.concaveHull.clippingAndMerging;

import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.concavePolygon2D.clippingAndMerging.ConcavePolygon2DClippingTools;

public class LinkedPointListTest {
    @Test
    public void testFourVertexCreationLinkingAndReverse() {
        ConcavePolygon2DClippingTools.LinkedPointList list = new ConcavePolygon2DClippingTools.LinkedPointList();
        ConcavePolygon2DClippingTools.LinkedPoint firstLink = new ConcavePolygon2DClippingTools.LinkedPoint(-1.0, 1.0);
        ConcavePolygon2DClippingTools.LinkedPoint secondLink = new ConcavePolygon2DClippingTools.LinkedPoint(1.0, 1.0);
        ConcavePolygon2DClippingTools.LinkedPoint thirdLink = new ConcavePolygon2DClippingTools.LinkedPoint(1.0, -1.0);
        ConcavePolygon2DClippingTools.LinkedPoint fourthLink = new ConcavePolygon2DClippingTools.LinkedPoint(-1.0, -1.0);
        list.addPointToEnd(firstLink);
        list.addPointToEnd(secondLink);
        list.addPointToEnd(thirdLink);
        list.addPointToEnd(fourthLink);
        ConcavePolygon2DClippingTools.LinkedPoint firstPoint = list.getFirstPoint();
        ConcavePolygon2DClippingTools.LinkedPoint lastPoint = list.getLastPoint();
        Assert.assertTrue(firstLink.equals(firstPoint));
        Assert.assertTrue(fourthLink.equals(lastPoint));
        Assert.assertTrue(firstLink.getSuccessor().equals(secondLink));
        Assert.assertTrue(secondLink.getSuccessor().equals(thirdLink));
        Assert.assertTrue(thirdLink.getSuccessor().equals(fourthLink));
        Assert.assertTrue(fourthLink.getSuccessor().equals(firstLink));
        Assert.assertTrue(fourthLink.getPredecessor().equals(thirdLink));
        Assert.assertTrue(thirdLink.getPredecessor().equals(secondLink));
        Assert.assertTrue(secondLink.getPredecessor().equals(firstLink));
        Assert.assertTrue(firstLink.getPredecessor().equals(fourthLink));
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-1.0, 1.0), (Point2DReadOnly)firstPoint.getPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-1.0, -1.0), (Point2DReadOnly)lastPoint.getPoint(), (double)1.0E-12);
        list.reverseOrder();
        Assert.assertTrue(list.getFirstPoint().equals(fourthLink));
        Assert.assertTrue(list.getLastPoint().equals(firstLink));
        Assert.assertTrue(fourthLink.getSuccessor().equals(thirdLink));
        Assert.assertTrue(thirdLink.getSuccessor().equals(secondLink));
        Assert.assertTrue(secondLink.getSuccessor().equals(firstLink));
        Assert.assertTrue(firstLink.getSuccessor().equals(fourthLink));
        Assert.assertTrue(firstLink.getPredecessor().equals(secondLink));
        Assert.assertTrue(secondLink.getPredecessor().equals(thirdLink));
        Assert.assertTrue(thirdLink.getPredecessor().equals(fourthLink));
        Assert.assertTrue(fourthLink.getPredecessor().equals(firstLink));
    }

    @Test
    public void testThreeVertexCreationLinkingAndReverse() {
        ConcavePolygon2DClippingTools.LinkedPointList list = new ConcavePolygon2DClippingTools.LinkedPointList();
        ConcavePolygon2DClippingTools.LinkedPoint firstLink = new ConcavePolygon2DClippingTools.LinkedPoint(-1.0, 1.0);
        ConcavePolygon2DClippingTools.LinkedPoint secondLink = new ConcavePolygon2DClippingTools.LinkedPoint(1.0, 1.0);
        ConcavePolygon2DClippingTools.LinkedPoint thirdLink = new ConcavePolygon2DClippingTools.LinkedPoint(-1.0, -1.0);
        list.addPointToEnd(firstLink);
        list.addPointToEnd(secondLink);
        list.addPointToEnd(thirdLink);
        ConcavePolygon2DClippingTools.LinkedPoint firstPoint = list.getFirstPoint();
        ConcavePolygon2DClippingTools.LinkedPoint lastPoint = list.getLastPoint();
        Assert.assertTrue(firstLink.equals(firstPoint));
        Assert.assertTrue(thirdLink.equals(lastPoint));
        Assert.assertTrue(firstLink.getSuccessor().equals(secondLink));
        Assert.assertTrue(secondLink.getSuccessor().equals(thirdLink));
        Assert.assertTrue(thirdLink.getSuccessor().equals(firstLink));
        Assert.assertTrue(thirdLink.getPredecessor().equals(secondLink));
        Assert.assertTrue(secondLink.getPredecessor().equals(firstLink));
        Assert.assertTrue(firstLink.getPredecessor().equals(thirdLink));
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-1.0, 1.0), (Point2DReadOnly)firstPoint.getPoint(), (double)1.0E-12);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(-1.0, -1.0), (Point2DReadOnly)lastPoint.getPoint(), (double)1.0E-12);
    }
}

