/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.LeastSquaresZPlaneFitter;
import us.ihmc.robotics.random.RandomGeometry;

public class LeastSquaresZPlaneFitterTest {
    @Test
    public void testPointsWithSamePitchAndDifferentPositionGetSameAnswer() {
        LeastSquaresZPlaneFitter leastSquaresZPlaneFitter = new LeastSquaresZPlaneFitter();
        ArrayList<Point3D> pointListA = new ArrayList<Point3D>();
        Plane3D plane3dA = new Plane3D(0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        pointListA.add(new Point3D(1.0, 1.0, 0.1));
        pointListA.add(new Point3D(1.0, -1.0, 0.1));
        pointListA.add(new Point3D(-1.0, 1.0, -0.1));
        pointListA.add(new Point3D(-1.0, -1.0, -0.1));
        leastSquaresZPlaneFitter.fitPlaneToPoints(pointListA, plane3dA);
        Vector3D normalA = new Vector3D((Tuple3DReadOnly)plane3dA.getNormal());
        ArrayList<Point3D> pointListB = new ArrayList<Point3D>();
        Plane3D plane3dB = new Plane3D(0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        pointListB.add(new Point3D(5.0, 5.0, 0.1));
        pointListB.add(new Point3D(5.0, 3.0, 0.1));
        pointListB.add(new Point3D(3.0, 5.0, -0.1));
        pointListB.add(new Point3D(3.0, 3.0, -0.1));
        leastSquaresZPlaneFitter.fitPlaneToPoints(pointListB, plane3dB);
        Vector3D normalB = new Vector3D((Tuple3DReadOnly)plane3dB.getNormal());
        Assert.assertTrue(normalA.epsilonEquals((EuclidGeometry)normalB, 1.0E-7));
    }

    @Test
    public void testSimpleFlatCase() {
        LeastSquaresZPlaneFitter leastSquaresZPlaneFitter = new LeastSquaresZPlaneFitter();
        ArrayList<Point3D> pointList = new ArrayList<Point3D>();
        Plane3D plane3d = new Plane3D(0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        pointList.add(new Point3D(0.0, 0.0, 0.0));
        pointList.add(new Point3D(0.0, 0.1, 0.0));
        pointList.add(new Point3D(1.0, 0.1, 0.0));
        leastSquaresZPlaneFitter.fitPlaneToPoints(pointList, plane3d);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(0.0, 0.0, 1.0), (EuclidGeometry)new Vector3D((Tuple3DReadOnly)plane3d.getNormal()), (double)1.0E-7);
    }

    @Test
    public void testRandomlyGeneratedPointsOnRandomPlanes() {
        int numberOfTests = 1000;
        double maxXYZ = 10.0;
        Random random = new Random(1678L);
        LeastSquaresZPlaneFitter leastSquaresZPlaneFitter = new LeastSquaresZPlaneFitter();
        double pointNoiseAmplitude = 0.0;
        double normalEpsilon = 1.0E-10;
        double pointEpsilon = 1.0E-10;
        this.performATestWithRandomPoints(numberOfTests, maxXYZ, random, leastSquaresZPlaneFitter, pointNoiseAmplitude, normalEpsilon, pointEpsilon);
        pointNoiseAmplitude = 0.001;
        normalEpsilon = 0.01;
        pointEpsilon = 0.001;
        this.performATestWithRandomPoints(numberOfTests, maxXYZ, random, leastSquaresZPlaneFitter, pointNoiseAmplitude, normalEpsilon, pointEpsilon);
        pointNoiseAmplitude = 0.01;
        normalEpsilon = 0.03;
        pointEpsilon = 0.01;
        this.performATestWithRandomPoints(numberOfTests, maxXYZ, random, leastSquaresZPlaneFitter, pointNoiseAmplitude, normalEpsilon, pointEpsilon);
    }

    private void performATestWithRandomPoints(int numberOfTests, double maxXYZ, Random random, LeastSquaresZPlaneFitter leastSquaresZPlaneFitter, double pointNoiseAmplitude, double normalEpsilon, double pointEpsilon) {
        for (int i = 0; i < numberOfTests; ++i) {
            Point3D planePoint = RandomGeometry.nextPoint3D((Random)random, (double)maxXYZ, (double)maxXYZ, (double)maxXYZ);
            Vector3D planeNormal = RandomGeometry.nextVector3D((Random)random, (double)1.0);
            if (planeNormal.getZ() < 0.0) {
                planeNormal.scale(-1.0);
            }
            Plane3D plane3d = new Plane3D((Point3DReadOnly)planePoint, (Vector3DReadOnly)planeNormal);
            int numberOfPoints = RandomNumbers.nextInt((Random)random, (int)3, (int)50);
            ArrayList<Point3D> listOfPoints = new ArrayList<Point3D>();
            for (int j = 0; j < numberOfPoints; ++j) {
                Point3D point = RandomGeometry.nextPoint3D((Random)random, (double)maxXYZ, (double)maxXYZ, (double)maxXYZ);
                plane3d.orthogonalProjection((Point3DBasics)point);
                point.add((Tuple3DReadOnly)RandomGeometry.nextVector3D((Random)random, (double)pointNoiseAmplitude));
                listOfPoints.add(point);
            }
            Plane3D plane3dSolution = new Plane3D();
            leastSquaresZPlaneFitter.fitPlaneToPoints(listOfPoints, plane3dSolution);
            Point3D pointSolution = new Point3D((Tuple3DReadOnly)plane3dSolution.getPoint());
            Vector3D normalSolution = new Vector3D((Tuple3DReadOnly)plane3dSolution.getNormal());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)planeNormal, (EuclidGeometry)normalSolution, (double)normalEpsilon);
            double distanceToPlane = plane3d.distance((Point3DReadOnly)pointSolution);
            Assert.assertTrue(distanceToPlane < pointEpsilon);
        }
    }

    @Test
    public void testCornerCaseWithOnlyTwoPoints() {
        LeastSquaresZPlaneFitter leastSquaresZPlaneFitter = new LeastSquaresZPlaneFitter();
        ArrayList<Point3D> pointList = new ArrayList<Point3D>();
        Plane3D plane3d = new Plane3D(0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        pointList.add(new Point3D(0.0, 0.0, 0.0));
        pointList.add(new Point3D(0.0, 0.1, 0.0));
        leastSquaresZPlaneFitter.fitPlaneToPoints(pointList, plane3d);
        Assert.assertTrue(this.isNaN((Tuple3DBasics)new Point3D((Tuple3DReadOnly)plane3d.getPoint())));
        Assert.assertTrue(this.isNaN((Tuple3DBasics)new Vector3D((Tuple3DReadOnly)plane3d.getNormal())));
    }

    @Test
    public void testCornerCaseWithColinearPoints() {
        LeastSquaresZPlaneFitter leastSquaresZPlaneFitter = new LeastSquaresZPlaneFitter();
        ArrayList<Point3D> pointList = new ArrayList<Point3D>();
        Plane3D plane3d = new Plane3D(0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        pointList.add(new Point3D(0.0, 0.0, 0.0));
        pointList.add(new Point3D(0.0, 0.1, 0.0));
        pointList.add(new Point3D(0.0, 0.3, 0.0));
        leastSquaresZPlaneFitter.fitPlaneToPoints(pointList, plane3d);
        Assert.assertTrue(this.isNaN((Tuple3DBasics)new Point3D((Tuple3DReadOnly)plane3d.getPoint())));
        Assert.assertTrue(this.isNaN((Tuple3DBasics)new Vector3D((Tuple3DReadOnly)plane3d.getNormal())));
    }

    private boolean isNaN(Tuple3DBasics tuple3d) {
        if (!Double.isNaN(tuple3d.getX())) {
            return false;
        }
        if (!Double.isNaN(tuple3d.getY())) {
            return false;
        }
        return Double.isNaN(tuple3d.getZ());
    }

    @Disabled
    @Test
    public void testStraightUpAndDownPlane() {
        LeastSquaresZPlaneFitter leastSquaresZPlaneFitter = new LeastSquaresZPlaneFitter();
        ArrayList<Point3D> pointList = new ArrayList<Point3D>();
        Plane3D plane3d = new Plane3D(0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        pointList.add(new Point3D(0.0, 0.0, 0.0));
        pointList.add(new Point3D(0.0, 0.1, 0.0));
        pointList.add(new Point3D(0.0, 0.05, 1.0));
        leastSquaresZPlaneFitter.fitPlaneToPoints(pointList, plane3d);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(0.0, 1.0, 0.0), (EuclidGeometry)new Vector3D((Tuple3DReadOnly)plane3d.getNormal()), (double)1.0E-7);
    }
}

