/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Line2D;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DBasics;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.ConvexPolygon2dCalculator;

public class ConvexPolygon2dCalculatorTest {
    private static final double epsilon = 1.0E-10;

    @Test
    public void testConstruction() {
        new ConvexPolygon2dCalculator();
    }

    @Test
    public void testIsPolygonInside1() {
        ConvexPolygon2D polygon = new ConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(2.0, 1.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 2.0));
        polygon.update();
        ConvexPolygon2D polygonToTest1 = new ConvexPolygon2D();
        polygonToTest1.addVertex((Point2DReadOnly)new Point2D(0.1, 0.1));
        polygonToTest1.addVertex((Point2DReadOnly)new Point2D(0.2, 0.2));
        polygonToTest1.update();
        Assert.assertTrue(ConvexPolygon2dCalculator.isPolygonInside((ConvexPolygon2DReadOnly)polygonToTest1, (ConvexPolygon2DReadOnly)polygon));
        ConvexPolygon2D polygonToTest2 = new ConvexPolygon2D((Vertex2DSupplier)polygon);
        Assert.assertTrue(ConvexPolygon2dCalculator.isPolygonInside((ConvexPolygon2DReadOnly)polygonToTest2, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertTrue(ConvexPolygon2dCalculator.isPolygonInside((ConvexPolygon2DReadOnly)polygonToTest2, (double)1.0E-10, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertFalse(ConvexPolygon2dCalculator.isPolygonInside((ConvexPolygon2DReadOnly)polygonToTest2, (double)-1.0E-10, (ConvexPolygon2DReadOnly)polygon));
        ConvexPolygon2D polygonToTest3 = new ConvexPolygon2D();
        polygonToTest3.addVertex((Point2DReadOnly)new Point2D(0.3, 0.9));
        polygonToTest3.addVertex((Point2DReadOnly)new Point2D(0.1, 0.1));
        polygonToTest3.addVertex((Point2DReadOnly)new Point2D(1.0, 1.2));
        polygonToTest3.update();
        Assert.assertFalse(ConvexPolygon2dCalculator.isPolygonInside((ConvexPolygon2DReadOnly)polygonToTest3, (ConvexPolygon2DReadOnly)polygon));
        ConvexPolygon2D polygonToTest4 = new ConvexPolygon2D();
        Assert.assertTrue(ConvexPolygon2dCalculator.isPolygonInside((ConvexPolygon2DReadOnly)polygonToTest4, (ConvexPolygon2DReadOnly)polygon));
        ConvexPolygon2D polygonToTest5 = new ConvexPolygon2D();
        polygonToTest5.addVertex((Point2DReadOnly)new Point2D(-0.1, 0.1));
        polygonToTest5.update();
        Assert.assertFalse(ConvexPolygon2dCalculator.isPolygonInside((ConvexPolygon2DReadOnly)polygonToTest5, (ConvexPolygon2DReadOnly)polygon));
    }

    @Test
    public void testTranslatePolygon1() {
        ConvexPolygon2D polygon = new ConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(10.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 10.0));
        polygon.update();
        Vector2D translation1 = new Vector2D(0.0, 0.0);
        ConvexPolygon2DBasics polygon1 = polygon.translateCopy((Tuple2DReadOnly)translation1);
        Assert.assertTrue(polygon1.epsilonEquals((EuclidGeometry)polygon, 1.0E-10));
        Vector2D translation2 = new Vector2D(1.0, 0.5);
        ConvexPolygon2DBasics polygon2 = polygon.translateCopy((Tuple2DReadOnly)translation2);
        Assert.assertTrue(polygon2.getVertex(2).epsilonEquals((EuclidGeometry)new Point2D(1.0, 0.5), 1.0E-10));
        Assert.assertTrue(polygon2.getVertex(1).epsilonEquals((EuclidGeometry)new Point2D(11.0, 0.5), 1.0E-10));
        Assert.assertTrue(polygon2.getVertex(0).epsilonEquals((EuclidGeometry)new Point2D(1.0, 10.5), 1.0E-10));
    }

    @Test
    public void testGetMiddleIndexCounterClockwise1() {
        Random random = new Random(234L);
        ConvexPolygon2D polygon = new ConvexPolygon2D();
        while (polygon.getNumberOfVertices() < 6) {
            polygon.addVertex((Point2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random));
            polygon.update();
        }
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)0, (int)0, (ConvexPolygon2DReadOnly)polygon), 3);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)1, (int)1, (ConvexPolygon2DReadOnly)polygon), 4);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)2, (int)2, (ConvexPolygon2DReadOnly)polygon), 5);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)3, (int)3, (ConvexPolygon2DReadOnly)polygon), 0);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)4, (int)4, (ConvexPolygon2DReadOnly)polygon), 1);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)5, (int)5, (ConvexPolygon2DReadOnly)polygon), 2);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)1, (int)0, (ConvexPolygon2DReadOnly)polygon), 1);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)2, (int)0, (ConvexPolygon2DReadOnly)polygon), 1);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)3, (int)0, (ConvexPolygon2DReadOnly)polygon), 2);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)4, (int)0, (ConvexPolygon2DReadOnly)polygon), 2);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)5, (int)0, (ConvexPolygon2DReadOnly)polygon), 3);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)2, (int)1, (ConvexPolygon2DReadOnly)polygon), 2);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)3, (int)1, (ConvexPolygon2DReadOnly)polygon), 2);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)4, (int)1, (ConvexPolygon2DReadOnly)polygon), 3);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)5, (int)1, (ConvexPolygon2DReadOnly)polygon), 3);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)3, (int)2, (ConvexPolygon2DReadOnly)polygon), 3);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)4, (int)2, (ConvexPolygon2DReadOnly)polygon), 3);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)5, (int)2, (ConvexPolygon2DReadOnly)polygon), 4);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)4, (int)3, (ConvexPolygon2DReadOnly)polygon), 4);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)5, (int)3, (ConvexPolygon2DReadOnly)polygon), 4);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)5, (int)4, (ConvexPolygon2DReadOnly)polygon), 5);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)0, (int)1, (ConvexPolygon2DReadOnly)polygon), 4);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)0, (int)2, (ConvexPolygon2DReadOnly)polygon), 4);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)0, (int)3, (ConvexPolygon2DReadOnly)polygon), 5);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)0, (int)4, (ConvexPolygon2DReadOnly)polygon), 5);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)0, (int)5, (ConvexPolygon2DReadOnly)polygon), 0);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)1, (int)2, (ConvexPolygon2DReadOnly)polygon), 5);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)1, (int)3, (ConvexPolygon2DReadOnly)polygon), 5);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)1, (int)4, (ConvexPolygon2DReadOnly)polygon), 0);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)1, (int)5, (ConvexPolygon2DReadOnly)polygon), 0);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)2, (int)3, (ConvexPolygon2DReadOnly)polygon), 0);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)2, (int)4, (ConvexPolygon2DReadOnly)polygon), 0);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)2, (int)5, (ConvexPolygon2DReadOnly)polygon), 1);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)3, (int)4, (ConvexPolygon2DReadOnly)polygon), 1);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)3, (int)5, (ConvexPolygon2DReadOnly)polygon), 1);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)4, (int)5, (ConvexPolygon2DReadOnly)polygon), 2);
        polygon.clearAndUpdate();
        while (polygon.getNumberOfVertices() < 3) {
            polygon.addVertex((Point2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random));
            polygon.update();
        }
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)0, (int)0, (ConvexPolygon2DReadOnly)polygon), 2);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)1, (int)1, (ConvexPolygon2DReadOnly)polygon), 0);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)2, (int)2, (ConvexPolygon2DReadOnly)polygon), 1);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)0, (int)1, (ConvexPolygon2DReadOnly)polygon), 2);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)0, (int)2, (ConvexPolygon2DReadOnly)polygon), 0);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)1, (int)2, (ConvexPolygon2DReadOnly)polygon), 0);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)1, (int)0, (ConvexPolygon2DReadOnly)polygon), 1);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)2, (int)0, (ConvexPolygon2DReadOnly)polygon), 1);
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)2, (int)1, (ConvexPolygon2DReadOnly)polygon), 2);
        polygon.clearAndUpdate();
        while (polygon.getNumberOfVertices() < 1) {
            polygon.addVertex((Point2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random));
            polygon.update();
        }
        ConvexPolygon2dCalculatorTest.assertIndexCorrect(ConvexPolygon2dCalculator.getMiddleIndexCounterClockwise((int)0, (int)0, (ConvexPolygon2DReadOnly)polygon), 0);
    }

    @Test
    public void testGetLineOfSightVertices1() {
        Point2D vertex1 = new Point2D(0.0, 1.0);
        Point2D vertex2 = new Point2D(1.0, 1.0);
        Point2D vertex3 = new Point2D(1.5, 0.5);
        Point2D vertex4 = new Point2D(1.0, 0.0);
        Point2D vertex5 = new Point2D(0.0, 0.0);
        ConvexPolygon2D polygon = new ConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)vertex1);
        polygon.addVertex((Point2DReadOnly)vertex2);
        polygon.addVertex((Point2DReadOnly)vertex3);
        polygon.addVertex((Point2DReadOnly)vertex4);
        polygon.addVertex((Point2DReadOnly)vertex5);
        polygon.update();
        Point2D observer1 = new Point2D(-0.5, 0.5);
        ConvexPolygon2dCalculatorTest.assertPointsEqual((Point2DReadOnly[])new Point2D[]{vertex5, vertex1}, (Point2DReadOnly[])polygon.lineOfSightVertices((Point2DReadOnly)observer1), true);
        Point2D observer2 = new Point2D(1.0, -0.5);
        ConvexPolygon2dCalculatorTest.assertPointsEqual((Point2DReadOnly[])new Point2D[]{vertex3, vertex5}, (Point2DReadOnly[])polygon.lineOfSightVertices((Point2DReadOnly)observer2), true);
        Point2D observer3 = new Point2D(-1.0, -1.9999999999);
        ConvexPolygon2dCalculatorTest.assertPointsEqual((Point2DReadOnly[])new Point2D[]{vertex4, vertex1}, (Point2DReadOnly[])polygon.lineOfSightVertices((Point2DReadOnly)observer3), true);
        Point2D observer4 = new Point2D(-1.0, -2.0000000001);
        ConvexPolygon2dCalculatorTest.assertPointsEqual((Point2DReadOnly[])new Point2D[]{vertex3, vertex1}, (Point2DReadOnly[])polygon.lineOfSightVertices((Point2DReadOnly)observer4), true);
        Point2D observer5 = new Point2D(1.5000000001, 0.5);
        ConvexPolygon2dCalculatorTest.assertPointsEqual((Point2DReadOnly[])new Point2D[]{vertex2, vertex4}, (Point2DReadOnly[])polygon.lineOfSightVertices((Point2DReadOnly)observer5), true);
        Point2D observer6 = vertex3;
        ConvexPolygon2dCalculatorTest.assertPointsEqual(null, (Point2DReadOnly[])polygon.lineOfSightVertices((Point2DReadOnly)observer6), true);
        Point2D observer7 = new Point2D(0.5, 0.5);
        ConvexPolygon2dCalculatorTest.assertPointsEqual(null, (Point2DReadOnly[])polygon.lineOfSightVertices((Point2DReadOnly)observer7), true);
    }

    @Test
    public void testGetLineOfSightVertices2() {
        ConvexPolygon2D polygon = new ConvexPolygon2D();
        Point2D observer1 = new Point2D(0.5, 0.5);
        ConvexPolygon2dCalculatorTest.assertPointsEqual(null, (Point2DReadOnly[])polygon.lineOfSightVertices((Point2DReadOnly)observer1), true);
    }

    @Test
    public void testGetLineOfSightVertexIndices1() {
        Point2D vertex = new Point2D(-0.5, 0.5);
        ConvexPolygon2D polygon = new ConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)vertex);
        polygon.update();
        Point2D observer1 = vertex;
        ConvexPolygon2dCalculatorTest.assertPointsEqual(null, (Point2DReadOnly[])polygon.lineOfSightVertices((Point2DReadOnly)observer1), true);
        Point2D observer2 = new Point2D(0.5, 0.5);
        ConvexPolygon2dCalculatorTest.assertPointsEqual((Point2DReadOnly[])new Point2D[]{vertex, vertex}, (Point2DReadOnly[])polygon.lineOfSightVertices((Point2DReadOnly)observer2), true);
        ConvexPolygon2dCalculatorTest.assertIndicesCorrect(new int[]{0, 0}, polygon.lineOfSightIndices((Point2DReadOnly)observer2));
    }

    @Test
    public void testGetLineOfSightVertexIndices4() {
        ConvexPolygon2D polygon = new ConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 1.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 1.0));
        polygon.update();
        Point2D observer1 = new Point2D(-1.0, 1.0);
        ConvexPolygon2dCalculatorTest.assertIndicesCorrect(new int[]{1, 0}, polygon.lineOfSightIndices((Point2DReadOnly)observer1));
        Point2D observer2 = new Point2D(0.5, 0.0);
        ConvexPolygon2dCalculatorTest.assertIndicesCorrect(new int[]{1, 0}, polygon.lineOfSightIndices((Point2DReadOnly)observer2));
        Point2D observer3 = new Point2D(0.5, 1.5);
        ConvexPolygon2dCalculatorTest.assertIndicesCorrect(new int[]{0, 1}, polygon.lineOfSightIndices((Point2DReadOnly)observer3));
        Point2D observer4 = new Point2D(0.5, 1.0);
        ConvexPolygon2dCalculatorTest.assertIndicesCorrect(null, polygon.lineOfSightIndices((Point2DReadOnly)observer4));
        Point2D observer5 = new Point2D(1.0, 1.0);
        ConvexPolygon2dCalculatorTest.assertIndicesCorrect(null, polygon.lineOfSightIndices((Point2DReadOnly)observer5));
    }

    @Test
    public void testDoesLineIntersectEdge1() {
        ConvexPolygon2D polygon = new ConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 1.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 1.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.5, 0.5));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 0.0));
        polygon.update();
        Line2D line1 = new Line2D((Point2DReadOnly)new Point2D(0.0, 0.1), (Vector2DReadOnly)new Vector2D(1.0, 1.0));
        Assert.assertTrue(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line1, (int)0, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line1, (int)1, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line1, (int)2, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line1, (int)3, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertTrue(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line1, (int)4, (ConvexPolygon2DReadOnly)polygon));
        Line2D line2 = new Line2D((Point2DReadOnly)new Point2D(0.9, 1.0), (Vector2DReadOnly)new Vector2D(1.0, -1.0));
        Assert.assertTrue(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line2, (int)0, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line2, (int)1, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertTrue(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line2, (int)2, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line2, (int)3, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line2, (int)4, (ConvexPolygon2DReadOnly)polygon));
        Line2D line3 = new Line2D((Point2DReadOnly)new Point2D(0.2, 0.6), (Vector2DReadOnly)new Vector2D(1.0, 0.0));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line3, (int)0, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertTrue(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line3, (int)1, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line3, (int)2, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line3, (int)3, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertTrue(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line3, (int)4, (ConvexPolygon2DReadOnly)polygon));
        Line2D line4 = new Line2D((Point2DReadOnly)new Point2D(0.0, -0.3), (Vector2DReadOnly)new Vector2D(0.0, 0.25));
        Assert.assertTrue(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line4, (int)0, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line4, (int)1, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line4, (int)2, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertTrue(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line4, (int)3, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line4, (int)4, (ConvexPolygon2DReadOnly)polygon));
    }

    @Test
    public void testDoesLineIntersectEdge2() {
        ConvexPolygon2D polygon = new ConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 1.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, 1.0));
        polygon.update();
        Line2D line1 = new Line2D((Point2DReadOnly)new Point2D(0.0, 0.3), (Vector2DReadOnly)new Vector2D(1.0, 0.0));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line1, (int)0, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line1, (int)1, (ConvexPolygon2DReadOnly)polygon));
        Line2D line2 = new Line2D((Point2DReadOnly)new Point2D(0.0, 0.3), (Vector2DReadOnly)new Vector2D(0.0, 1.0));
        Assert.assertTrue(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line2, (int)0, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertTrue(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line2, (int)1, (ConvexPolygon2DReadOnly)polygon));
        Line2D line3 = new Line2D((Point2DReadOnly)new Point2D(0.0, 0.3), (Vector2DReadOnly)new Vector2D(0.0, -1.0));
        Assert.assertTrue(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line3, (int)0, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertTrue(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line3, (int)1, (ConvexPolygon2DReadOnly)polygon));
        Line2D line4 = new Line2D((Point2DReadOnly)new Point2D(2.0, 0.3), (Vector2DReadOnly)new Vector2D(0.0, -1.0));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line4, (int)0, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line4, (int)1, (ConvexPolygon2DReadOnly)polygon));
        Line2D line5 = new Line2D((Point2DReadOnly)new Point2D(-1.0E-6, 0.3), (Vector2DReadOnly)new Vector2D(0.0, -1.0));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line5, (int)0, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line5, (int)1, (ConvexPolygon2DReadOnly)polygon));
        Line2D line6 = new Line2D((Point2DReadOnly)new Point2D(0.0, 0.3), (Vector2DReadOnly)new Vector2D(1.0, 0.0));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line6, (int)0, (ConvexPolygon2DReadOnly)polygon));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line6, (int)1, (ConvexPolygon2DReadOnly)polygon));
    }

    @Test
    public void testDoesLineIntersectEdge3() {
        ConvexPolygon2D polygon = new ConvexPolygon2D();
        Line2D line5 = new Line2D((Point2DReadOnly)new Point2D(0.0, 0.0), (Vector2DReadOnly)new Vector2D(1.0, 0.0));
        Assert.assertFalse(ConvexPolygon2dCalculator.doesLineIntersectEdge((Line2DReadOnly)line5, (int)0, (ConvexPolygon2DReadOnly)polygon));
    }

    @Test
    public void testGetIntersectingEdges1() {
        Point2D vertex1 = new Point2D(0.0, 1.0);
        Point2D vertex2 = new Point2D(1.0, 1.0);
        Point2D vertex3 = new Point2D(1.0, 0.0);
        Point2D vertex4 = new Point2D(0.0, 0.0);
        LineSegment2D edge1 = new LineSegment2D((Point2DReadOnly)vertex1, (Point2DReadOnly)vertex2);
        LineSegment2D edge2 = new LineSegment2D((Point2DReadOnly)vertex2, (Point2DReadOnly)vertex3);
        LineSegment2D edge3 = new LineSegment2D((Point2DReadOnly)vertex3, (Point2DReadOnly)vertex4);
        LineSegment2D edge4 = new LineSegment2D((Point2DReadOnly)vertex4, (Point2DReadOnly)vertex1);
        ConvexPolygon2D polygon = new ConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)vertex1);
        polygon.addVertex((Point2DReadOnly)vertex2);
        polygon.addVertex((Point2DReadOnly)vertex3);
        polygon.addVertex((Point2DReadOnly)vertex4);
        polygon.update();
        LineSegment2D result1 = new LineSegment2D();
        LineSegment2D result2 = new LineSegment2D();
        Line2D line1 = new Line2D((Point2DReadOnly)new Point2D(0.5, 0.5), (Vector2DReadOnly)new Vector2D(-1.0, 0.0));
        LineSegment2D[] expected1 = new LineSegment2D[]{edge4, edge2};
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected1, ConvexPolygon2dCalculator.getIntersectingEdgesCopy((Line2DReadOnly)line1, (ConvexPolygon2DReadOnly)polygon), false);
        Assert.assertEquals(2L, ConvexPolygon2dCalculator.getIntersectingEdges((Line2DReadOnly)line1, (LineSegment2DBasics)result1, (LineSegment2DBasics)result2, (ConvexPolygon2DReadOnly)polygon));
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected1, new LineSegment2D[]{result1, result2}, false);
        Line2D line2 = new Line2D((Point2DReadOnly)new Point2D(0.5, 1.5), (Vector2DReadOnly)new Vector2D(1.0, 0.0));
        LineSegment2D[] expected2 = null;
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected2, ConvexPolygon2dCalculator.getIntersectingEdgesCopy((Line2DReadOnly)line2, (ConvexPolygon2DReadOnly)polygon), false);
        Assert.assertEquals(0L, ConvexPolygon2dCalculator.getIntersectingEdges((Line2DReadOnly)line2, (LineSegment2DBasics)result1, (LineSegment2DBasics)result2, (ConvexPolygon2DReadOnly)polygon));
        Line2D line3 = new Line2D((Point2DReadOnly)new Point2D(0.0, 2.0), (Vector2DReadOnly)new Vector2D(1.0, -1.0));
        LineSegment2D[] expected3 = new LineSegment2D[]{edge1};
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected3, ConvexPolygon2dCalculator.getIntersectingEdgesCopy((Line2DReadOnly)line3, (ConvexPolygon2DReadOnly)polygon), false);
        Assert.assertEquals(1L, ConvexPolygon2dCalculator.getIntersectingEdges((Line2DReadOnly)line3, (LineSegment2DBasics)result1, (LineSegment2DBasics)result2, (ConvexPolygon2DReadOnly)polygon));
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected3, new LineSegment2D[]{result1}, false);
        Line2D line4 = new Line2D((Point2DReadOnly)new Point2D(0.0, 0.0), (Vector2DReadOnly)new Vector2D(1.0, 1.0));
        LineSegment2D[] expected4 = new LineSegment2D[]{edge1, edge3};
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected4, ConvexPolygon2dCalculator.getIntersectingEdgesCopy((Line2DReadOnly)line4, (ConvexPolygon2DReadOnly)polygon), false);
        Assert.assertEquals(2L, ConvexPolygon2dCalculator.getIntersectingEdges((Line2DReadOnly)line4, (LineSegment2DBasics)result1, (LineSegment2DBasics)result2, (ConvexPolygon2DReadOnly)polygon));
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected4, new LineSegment2D[]{result1, result2}, false);
        Line2D line5 = new Line2D((Point2DReadOnly)new Point2D(-0.5, -0.5), (Vector2DReadOnly)new Vector2D(0.7, 0.7));
        LineSegment2D[] expected5 = new LineSegment2D[]{edge1, edge3};
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected5, ConvexPolygon2dCalculator.getIntersectingEdgesCopy((Line2DReadOnly)line5, (ConvexPolygon2DReadOnly)polygon), false);
        Assert.assertEquals(2L, ConvexPolygon2dCalculator.getIntersectingEdges((Line2DReadOnly)line5, (LineSegment2DBasics)result1, (LineSegment2DBasics)result2, (ConvexPolygon2DReadOnly)polygon));
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected5, new LineSegment2D[]{result1, result2}, false);
        Line2D line6 = new Line2D((Point2DReadOnly)new Point2D(0.0, -0.5), (Vector2DReadOnly)new Vector2D(0.0, 0.7));
        LineSegment2D[] expected6 = new LineSegment2D[]{edge1, edge3};
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected6, ConvexPolygon2dCalculator.getIntersectingEdgesCopy((Line2DReadOnly)line6, (ConvexPolygon2DReadOnly)polygon), false);
        Assert.assertEquals(2L, ConvexPolygon2dCalculator.getIntersectingEdges((Line2DReadOnly)line6, (LineSegment2DBasics)result1, (LineSegment2DBasics)result2, (ConvexPolygon2DReadOnly)polygon));
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected6, new LineSegment2D[]{result1, result2}, false);
        Line2D line7 = new Line2D((Point2DReadOnly)new Point2D(-0.5, 1.5), (Vector2DReadOnly)new Vector2D(1.0, -1.0));
        LineSegment2D[] expected7 = new LineSegment2D[]{edge2, edge4};
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected7, ConvexPolygon2dCalculator.getIntersectingEdgesCopy((Line2DReadOnly)line7, (ConvexPolygon2DReadOnly)polygon), false);
        Assert.assertEquals(2L, ConvexPolygon2dCalculator.getIntersectingEdges((Line2DReadOnly)line7, (LineSegment2DBasics)result1, (LineSegment2DBasics)result2, (ConvexPolygon2DReadOnly)polygon));
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected7, new LineSegment2D[]{result1, result2}, false);
        Line2D line8 = new Line2D((Point2DReadOnly)new Point2D(1.0, 0.5), (Vector2DReadOnly)new Vector2D(0.0, -0.2));
        LineSegment2D[] expected8 = new LineSegment2D[]{edge1, edge3};
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected8, ConvexPolygon2dCalculator.getIntersectingEdgesCopy((Line2DReadOnly)line8, (ConvexPolygon2DReadOnly)polygon), false);
        Assert.assertEquals(2L, ConvexPolygon2dCalculator.getIntersectingEdges((Line2DReadOnly)line8, (LineSegment2DBasics)result1, (LineSegment2DBasics)result2, (ConvexPolygon2DReadOnly)polygon));
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected8, new LineSegment2D[]{result1, result2}, false);
        Line2D line9 = new Line2D((Point2DReadOnly)new Point2D(-0.3, 1.0), (Vector2DReadOnly)new Vector2D(0.2, 0.0));
        LineSegment2D[] expected9 = new LineSegment2D[]{edge4, edge2};
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected9, ConvexPolygon2dCalculator.getIntersectingEdgesCopy((Line2DReadOnly)line9, (ConvexPolygon2DReadOnly)polygon), false);
        Assert.assertEquals(2L, ConvexPolygon2dCalculator.getIntersectingEdges((Line2DReadOnly)line9, (LineSegment2DBasics)result1, (LineSegment2DBasics)result2, (ConvexPolygon2DReadOnly)polygon));
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected9, new LineSegment2D[]{result1, result2}, false);
    }

    @Test
    public void testGetIntersectingEdges2() {
        Point2D vertex1 = new Point2D(1.0, 1.0);
        Point2D vertex2 = new Point2D(1.0, 0.0);
        LineSegment2D edge1 = new LineSegment2D((Point2DReadOnly)vertex1, (Point2DReadOnly)vertex2);
        LineSegment2D edge2 = new LineSegment2D((Point2DReadOnly)vertex2, (Point2DReadOnly)vertex1);
        ConvexPolygon2D polygon = new ConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)vertex1);
        polygon.addVertex((Point2DReadOnly)vertex2);
        polygon.update();
        LineSegment2D result1 = new LineSegment2D();
        LineSegment2D result2 = new LineSegment2D();
        Line2D line1 = new Line2D((Point2DReadOnly)new Point2D(0.5, 1.5), (Vector2DReadOnly)new Vector2D(0.0, 0.1));
        LineSegment2D[] expected1 = null;
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected1, ConvexPolygon2dCalculator.getIntersectingEdgesCopy((Line2DReadOnly)line1, (ConvexPolygon2DReadOnly)polygon), false);
        Assert.assertEquals(0L, ConvexPolygon2dCalculator.getIntersectingEdges((Line2DReadOnly)line1, (LineSegment2DBasics)result1, (LineSegment2DBasics)result2, (ConvexPolygon2DReadOnly)polygon));
        Line2D line2 = new Line2D((Point2DReadOnly)new Point2D(-0.5, 0.0), (Vector2DReadOnly)new Vector2D(0.75, 0.25));
        LineSegment2D[] expected2 = new LineSegment2D[]{edge1, edge2};
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected2, ConvexPolygon2dCalculator.getIntersectingEdgesCopy((Line2DReadOnly)line2, (ConvexPolygon2DReadOnly)polygon), false);
        Assert.assertEquals(2L, ConvexPolygon2dCalculator.getIntersectingEdges((Line2DReadOnly)line2, (LineSegment2DBasics)result1, (LineSegment2DBasics)result2, (ConvexPolygon2DReadOnly)polygon));
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected2, new LineSegment2D[]{result1, result2}, false);
        Line2D line3 = new Line2D((Point2DReadOnly)new Point2D(1.0, -0.5), (Vector2DReadOnly)new Vector2D(0.0, 0.1));
        LineSegment2D[] expected3 = null;
        ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected3, ConvexPolygon2dCalculator.getIntersectingEdgesCopy((Line2DReadOnly)line3, (ConvexPolygon2DReadOnly)polygon), false);
        Assert.assertEquals(0L, ConvexPolygon2dCalculator.getIntersectingEdges((Line2DReadOnly)line3, (LineSegment2DBasics)result1, (LineSegment2DBasics)result2, (ConvexPolygon2DReadOnly)polygon));
    }

    @Test
    public void testGetIntersectingEdges3() {
        ConvexPolygon2D polygon = new ConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(-1.0, -0.5));
        polygon.update();
        LineSegment2D result1 = new LineSegment2D();
        LineSegment2D result2 = new LineSegment2D();
        Line2D line1 = new Line2D((Point2DReadOnly)new Point2D(0.0, 0.0), (Vector2DReadOnly)new Vector2D(-0.5, -0.25));
        Assert.assertEquals(ConvexPolygon2dCalculator.getIntersectingEdges((Line2DReadOnly)line1, (LineSegment2DBasics)result1, (LineSegment2DBasics)result2, (ConvexPolygon2DReadOnly)polygon), 0L);
        Assert.assertTrue(ConvexPolygon2dCalculator.getIntersectingEdgesCopy((Line2DReadOnly)line1, (ConvexPolygon2DReadOnly)polygon) == null);
        Line2D line2 = new Line2D((Point2DReadOnly)new Point2D(0.5, 1.5), (Vector2DReadOnly)new Vector2D(0.0, 0.1));
        Assert.assertEquals(ConvexPolygon2dCalculator.getIntersectingEdges((Line2DReadOnly)line2, (LineSegment2DBasics)result1, (LineSegment2DBasics)result2, (ConvexPolygon2DReadOnly)polygon), 0L);
        Assert.assertTrue(ConvexPolygon2dCalculator.getIntersectingEdgesCopy((Line2DReadOnly)line2, (ConvexPolygon2DReadOnly)polygon) == null);
        Line2D line3 = new Line2D((Point2DReadOnly)new Point2D(-1.0, -0.5), (Vector2DReadOnly)new Vector2D(1.0, 0.1));
        Assert.assertEquals(ConvexPolygon2dCalculator.getIntersectingEdges((Line2DReadOnly)line3, (LineSegment2DBasics)result1, (LineSegment2DBasics)result2, (ConvexPolygon2DReadOnly)polygon), 0L);
        Assert.assertTrue(ConvexPolygon2dCalculator.getIntersectingEdgesCopy((Line2DReadOnly)line3, (ConvexPolygon2DReadOnly)polygon) == null);
    }

    @Test
    public void testGetIntersectingEdges4() {
        ConvexPolygon2D polygon = new ConvexPolygon2D();
        LineSegment2D result1 = new LineSegment2D();
        LineSegment2D result2 = new LineSegment2D();
        Line2D line1 = new Line2D((Point2DReadOnly)new Point2D(0.5, 1.5), (Vector2DReadOnly)new Vector2D(0.0, 0.1));
        Assert.assertEquals(ConvexPolygon2dCalculator.getIntersectingEdges((Line2DReadOnly)line1, (LineSegment2DBasics)result1, (LineSegment2DBasics)result2, (ConvexPolygon2DReadOnly)polygon), 0L);
        Assert.assertTrue(ConvexPolygon2dCalculator.getIntersectingEdgesCopy((Line2DReadOnly)line1, (ConvexPolygon2DReadOnly)polygon) == null);
    }

    @Test
    public void testGetEdgeNormal() {
        ConvexPolygon2D polygon = new ConvexPolygon2D();
        polygon.addVertex((Point2DReadOnly)new Point2D(-1.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(0.0, 1.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(2.0, 0.0));
        polygon.addVertex((Point2DReadOnly)new Point2D(1.0, -1.0));
        polygon.update();
        for (int i = 0; i < polygon.getNumberOfVertices(); ++i) {
            Vector2D normal = new Vector2D();
            ConvexPolygon2dCalculator.getEdgeNormal((int)i, (Vector2DBasics)normal, (ConvexPolygon2DReadOnly)polygon);
            Vector2D expected = new Vector2D();
            Point2DReadOnly edgeStart = polygon.getVertex(i);
            Point2DReadOnly edgeEnd = polygon.getNextVertex(i);
            Vector2D edgeVector = new Vector2D();
            edgeVector.sub((Tuple2DReadOnly)edgeEnd, (Tuple2DReadOnly)edgeStart);
            EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)edgeVector, (Vector2DBasics)expected);
            expected.normalize();
            Assert.assertTrue("Expected normal Vector did not match computed one.", expected.epsilonEquals((EuclidGeometry)normal, 1.0E-10));
        }
    }

    private static void assertEdgesEqual(LineSegment2D[] expected, LineSegment2D[] actual, boolean enforceOrder) {
        if (expected == null || actual == null) {
            Assert.assertTrue("Expected did not equal actual. One of them was null.", expected == actual);
            return;
        }
        Assert.assertEquals("Array lengths are not equal.", expected.length, actual.length);
        int points = expected.length;
        for (int i = 0; i < points; ++i) {
            if (enforceOrder) {
                ConvexPolygon2dCalculatorTest.assertEdgesEqual(expected[i], actual[i]);
                continue;
            }
            boolean foundPoint = false;
            for (int j = 0; j < points; ++j) {
                if (!expected[i].epsilonEquals((EuclidGeometry)actual[j], 1.0E-10)) continue;
                foundPoint = true;
            }
            Assert.assertTrue("Did not find edge.", foundPoint);
        }
    }

    private static void assertEdgesEqual(LineSegment2D expected, LineSegment2D actual) {
        Assert.assertTrue("Edge did not match expected.", expected.epsilonEquals((EuclidGeometry)actual, 1.0E-10));
    }

    private static void assertPointsEqual(Point2DReadOnly[] expected, Point2DReadOnly[] actual, boolean enforceOrder) {
        if (expected == null || actual == null) {
            Assert.assertTrue("Expected did not equal actual. One of them was null.", expected == actual);
            return;
        }
        Assert.assertEquals("Array lengths are not equal.", expected.length, actual.length);
        int points = expected.length;
        for (int i = 0; i < points; ++i) {
            if (enforceOrder) {
                ConvexPolygon2dCalculatorTest.assertPointsEqual(expected[i], actual[i]);
                continue;
            }
            boolean foundPoint = false;
            for (int j = 0; j < points; ++j) {
                if (!expected[i].epsilonEquals((EuclidGeometry)actual[j], 1.0E-10)) continue;
                foundPoint = true;
            }
            Assert.assertTrue("Did not find point.", foundPoint);
        }
    }

    private static void assertIndicesCorrect(int[] expected, int[] actual) {
        if (expected == null || actual == null) {
            Assert.assertTrue("Expected did not equal actual. One of them was null.", expected == actual);
            return;
        }
        Assert.assertEquals("Array lengths are not equal.", expected.length, actual.length);
        for (int i = 0; i < expected.length; ++i) {
            ConvexPolygon2dCalculatorTest.assertIndexCorrect(expected[i], actual[i]);
        }
    }

    private static void assertIndexCorrect(int expected, int actual) {
        Assert.assertEquals("Index does not equal expected.", expected, actual);
    }

    private static void assertPointsEqual(Point2DReadOnly expected, Point2DReadOnly actual) {
        if (expected == null && actual == null) {
            return;
        }
        double localEpsilon = 1.0E-10 * expected.distance((Point2DReadOnly)new Point2D());
        Assert.assertTrue("Point does not match expected.", expected.epsilonEquals((EuclidGeometry)actual, localEpsilon));
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(ConvexPolygon2dCalculator.class, ConvexPolygon2dCalculatorTest.class);
    }
}

