/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.functionApproximation;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.functionApproximation.OnlineLeastSquaresRegression;
import us.ihmc.robotics.statistics.OnlineStandardDeviationCalculator;
import us.ihmc.yoVariables.registry.YoRegistry;

public class OnlineLeastSquaresRegressionTest {
    private static final double epsilon = 1.0E-5;

    @Test
    public void testPerfectFunction() {
        OnlineLeastSquaresRegression linearRegression = new OnlineLeastSquaresRegression("", new YoRegistry("testRegistry"));
        OnlineStandardDeviationCalculator residualStats = new OnlineStandardDeviationCalculator("", new YoRegistry("testRegistry"));
        int functionsToEstimate = 10;
        int valuesToUse = 200;
        Random random = new Random(1738L);
        for (int function = 0; function < functionsToEstimate; ++function) {
            double x;
            int value;
            linearRegression.reset();
            double a0 = RandomNumbers.nextDouble((Random)random, (double)10.0);
            double a1 = RandomNumbers.nextDouble((Random)random, (double)10.0);
            for (value = 0; value < valuesToUse; ++value) {
                x = RandomNumbers.nextDouble((Random)random, (double)10.0);
                double y = a0 + a1 * x;
                linearRegression.update(x, y);
                double residual = y - linearRegression.computeY(x);
                if (Double.isNaN(residual) || value <= 0) continue;
                residualStats.update(residual);
            }
            for (value = 0; value < valuesToUse; ++value) {
                x = RandomNumbers.nextDouble((Random)random, (double)10.0);
                Assert.assertEquals(a0 + a1 * x, linearRegression.computeY(x), 1.0E-5);
            }
            Assert.assertEquals(1.0, linearRegression.getRSquared(), 1.0E-5);
            Assert.assertEquals(0.0, residualStats.getStandardDeviation(), 1.0E-5);
            Assert.assertEquals(0.0, residualStats.getVariance(), 1.0E-5);
        }
    }
}

