/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers.stiction;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.controllers.stiction.ConstantStictionModel;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ConstantStictionModelTest {
    private static final int iters = 100;
    private static final double epsilon = 1.0E-8;

    @Test
    public void testGetStictionMagnitude() {
        YoRegistry registry = new YoRegistry("test");
        YoDouble constantStictionProvider = new YoDouble("constantStictionProvider", registry);
        ConstantStictionModel stictionModel = new ConstantStictionModel((DoubleProvider)constantStictionProvider);
        Assert.assertEquals(0.0, stictionModel.getStictionMagnitude(), 1.0E-8);
        Random random = new Random(1738L);
        for (int iter = 0; iter < 100; ++iter) {
            double expectedMagnitude = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)1000.0);
            constantStictionProvider.set(expectedMagnitude);
            Assert.assertEquals(expectedMagnitude, stictionModel.getStictionMagnitude(), 1.0E-8);
        }
    }
}

