/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.EuclidCoreMissingTools;

public class EuclidCoreMissingToolsTest {
    private static final double EPSILON = 1.0E-12;
    private static final int iters = 1000;

    @Test
    public void testRoundToGivenPrecision() {
        double longDouble = 0.12345678910111213;
        double roundedNumber = MathTools.floorToPrecision((double)longDouble, (double)1.0E-7);
        Assertions.assertEquals((double)roundedNumber, (double)0.1234567, (double)1.0E-14);
        roundedNumber = MathTools.floorToPrecision((double)longDouble, (double)0.001);
        Assertions.assertEquals((double)roundedNumber, (double)0.123, (double)1.0E-14);
        Vector3D preciseVector = new Vector3D(0.12345678910111213, 100.12345678910111, 1000.123456789101);
        Vector3D roundedVector = new Vector3D((Tuple3DReadOnly)preciseVector);
        EuclidCoreMissingTools.floorToGivenPrecision((Tuple3DBasics)roundedVector, (double)1.0E-7);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(0.1234567, 100.1234567, 1000.1234567), (EuclidGeometry)roundedVector, (double)1.0E-12);
        EuclidCoreMissingTools.floorToGivenPrecision((Tuple3DBasics)roundedVector, (double)0.001);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(0.123, 100.123, 1000.123), (EuclidGeometry)roundedVector, (double)1.0E-14);
    }

    @Test
    public void testProjectRotationOnAxis() {
        Random random = new Random(9429424L);
        Quaternion fullRotation = new Quaternion();
        Quaternion actualRotation = new Quaternion();
        for (int i = 0; i < 10000; ++i) {
            Vector3D axis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            double angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)(-Math.PI), (double)Math.PI);
            Quaternion expectedRotation = new Quaternion((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)axis, angle));
            Vector3D orthogonalAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)axis, (boolean)true);
            double orthogonalAngle = EuclidCoreRandomTools.nextDouble((Random)random, (double)(-Math.PI), (double)Math.PI);
            Quaternion orthogonalRotation = new Quaternion((Orientation3DReadOnly)new AxisAngle((Vector3DReadOnly)orthogonalAxis, orthogonalAngle));
            fullRotation.multiply((QuaternionReadOnly)orthogonalRotation, (QuaternionReadOnly)expectedRotation);
            EuclidCoreMissingTools.projectRotationOnAxis((QuaternionReadOnly)fullRotation, (Vector3DReadOnly)axis, (QuaternionBasics)actualRotation);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)expectedRotation, (Orientation3DReadOnly)actualRotation, (double)1.0E-10);
        }
    }

    @Test
    public void testRotationMatrix3DFromFirstToSecondVector3D() {
        Random random = new Random(43634L);
        for (int i = 0; i < 10000; ++i) {
            Vector3D firstVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D secondVector = EuclidCoreRandomTools.nextVector3D((Random)random);
            RotationMatrix actualRotationMatrix = new RotationMatrix();
            AxisAngle actualAxisAngle = new AxisAngle();
            AxisAngle expectedAxisAngle = new AxisAngle();
            EuclidCoreMissingTools.rotationMatrix3DFromFirstToSecondVector3D((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector, (CommonMatrix3DBasics)actualRotationMatrix);
            actualAxisAngle.set((Orientation3DReadOnly)actualRotationMatrix);
            EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)firstVector, (Vector3DReadOnly)secondVector, (Orientation3DBasics)expectedAxisAngle);
            EuclidCoreTestTools.assertOrientation3DGeometricallyEquals((Orientation3DReadOnly)expectedAxisAngle, (Orientation3DReadOnly)actualAxisAngle, (double)1.0E-7);
        }
    }

    @Test
    public void testDistanceBetweenTwoLineSegment2Ds() {
        Vector2D shiftVector;
        Vector2D oppositeOflineSegmentDirection1;
        Point2D lineSegmentEnd2;
        Point2D lineSegmentStart2;
        Point2D lineSegmentEnd1;
        Point2D lineSegmentStart1;
        int i;
        Point2D closestPointOnLineSegment1 = new Point2D();
        Point2D closestPointOnLineSegment2 = new Point2D();
        Vector2D lineSegmentDirection1 = new Vector2D();
        Vector2D lineSegmentDirection2 = new Vector2D();
        Random random = new Random(11762L);
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentDirection1.sub((Tuple2DReadOnly)lineSegmentEnd1, (Tuple2DReadOnly)lineSegmentStart1);
            lineSegmentDirection1.normalize();
            closestPointOnLineSegment1.set(lineSegmentStart1);
            Vector2D orthogonalToLineSegment1 = EuclidCoreMissingToolsTest.nextOrthogonalVector2D(random, (Vector2DReadOnly)lineSegmentDirection1, true);
            double expectedMinimumDistance = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            closestPointOnLineSegment2.scaleAdd(expectedMinimumDistance, (Tuple2DReadOnly)orthogonalToLineSegment1, (Tuple2DReadOnly)closestPointOnLineSegment1);
            lineSegmentDirection2.set(lineSegmentDirection1);
            lineSegmentStart2 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)closestPointOnLineSegment2);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)closestPointOnLineSegment2);
            double actualMinimumDistance = EuclidCoreMissingTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2);
            Assert.assertEquals(expectedMinimumDistance, actualMinimumDistance, 1.0E-12);
            double shiftStartFromExpected = EuclidCoreRandomTools.nextDouble((Random)random, (double)-20.0, (double)-10.0);
            double shiftEndFromExpected = EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0);
            lineSegmentStart2.scaleAdd(shiftStartFromExpected, (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)closestPointOnLineSegment2);
            lineSegmentEnd2.scaleAdd(shiftEndFromExpected, (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)closestPointOnLineSegment2);
            closestPointOnLineSegment2.set(lineSegmentEnd2);
            expectedMinimumDistance = closestPointOnLineSegment1.distance((Point2DReadOnly)closestPointOnLineSegment2);
            actualMinimumDistance = EuclidCoreMissingTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2);
            Assert.assertEquals(expectedMinimumDistance, actualMinimumDistance, 1.0E-12);
            actualMinimumDistance = EuclidCoreMissingTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2);
            Assert.assertEquals(expectedMinimumDistance, actualMinimumDistance, 1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentDirection1.sub((Tuple2DReadOnly)lineSegmentEnd1, (Tuple2DReadOnly)lineSegmentStart1);
            lineSegmentDirection1.normalize();
            closestPointOnLineSegment1.set(lineSegmentStart1);
            oppositeOflineSegmentDirection1 = new Vector2D();
            oppositeOflineSegmentDirection1.setAndNegate((Tuple2DReadOnly)lineSegmentDirection1);
            Vector2D orthogonalToLineSegment1 = EuclidCoreMissingToolsTest.nextOrthogonalVector2D(random, (Vector2DReadOnly)lineSegmentDirection1, true);
            shiftVector = new Vector2D();
            shiftVector.interpolate((Tuple2DReadOnly)orthogonalToLineSegment1, (Tuple2DReadOnly)oppositeOflineSegmentDirection1, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            closestPointOnLineSegment2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)shiftVector, (Tuple2DReadOnly)closestPointOnLineSegment1);
            lineSegmentDirection2 = EuclidCoreMissingToolsTest.nextOrthogonalVector2D(random, (Vector2DReadOnly)shiftVector, true);
            lineSegmentStart2 = new Point2D();
            lineSegmentEnd2 = new Point2D();
            lineSegmentStart2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)-10.0, (double)0.0), (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)closestPointOnLineSegment2);
            lineSegmentEnd2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)closestPointOnLineSegment2);
            double expectedMinimumDistance = closestPointOnLineSegment1.distance((Point2DReadOnly)closestPointOnLineSegment2);
            double actualMinimumDistance = EuclidCoreMissingTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2);
            Assert.assertEquals(expectedMinimumDistance, actualMinimumDistance, 1.0E-12);
            actualMinimumDistance = EuclidCoreMissingTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2);
            Assert.assertEquals(expectedMinimumDistance, actualMinimumDistance, 1.0E-12);
            actualMinimumDistance = EuclidCoreMissingTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2);
            Assert.assertEquals(expectedMinimumDistance, actualMinimumDistance, 1.0E-12);
            actualMinimumDistance = EuclidCoreMissingTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd2, (Point2DReadOnly)lineSegmentStart2);
            Assert.assertEquals(expectedMinimumDistance, actualMinimumDistance, 1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            lineSegmentStart1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentStart1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentEnd1 = EuclidCoreRandomTools.nextPoint2D((Random)random);
            lineSegmentEnd1.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            lineSegmentDirection1.sub((Tuple2DReadOnly)lineSegmentEnd1, (Tuple2DReadOnly)lineSegmentStart1);
            lineSegmentDirection1.normalize();
            closestPointOnLineSegment1.set(lineSegmentStart1);
            oppositeOflineSegmentDirection1 = new Vector2D();
            oppositeOflineSegmentDirection1.setAndNegate((Tuple2DReadOnly)lineSegmentDirection1);
            Vector2D orthogonalToLineSegment1 = EuclidCoreMissingToolsTest.nextOrthogonalVector2D(random, (Vector2DReadOnly)lineSegmentDirection1, true);
            shiftVector = new Vector2D();
            double alpha = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            shiftVector.interpolate((Tuple2DReadOnly)orthogonalToLineSegment1, (Tuple2DReadOnly)oppositeOflineSegmentDirection1, alpha);
            closestPointOnLineSegment2.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0), (Tuple2DReadOnly)shiftVector, (Tuple2DReadOnly)closestPointOnLineSegment1);
            Point2D lineSegmentStart22 = new Point2D((Tuple2DReadOnly)closestPointOnLineSegment2);
            Vector2D orthogonalToShiftVector = EuclidCoreMissingToolsTest.nextOrthogonalVector2D(random, (Vector2DReadOnly)shiftVector, true);
            lineSegmentDirection2.interpolate((Tuple2DReadOnly)shiftVector, (Tuple2DReadOnly)orthogonalToShiftVector, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0));
            Point2D lineSegmentEnd22 = new Point2D();
            double alpha2 = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)10.0);
            lineSegmentEnd22.scaleAdd(alpha2, (Tuple2DReadOnly)lineSegmentDirection2, (Tuple2DReadOnly)closestPointOnLineSegment2);
            double expectedMinimumDistance = closestPointOnLineSegment1.distance((Point2DReadOnly)closestPointOnLineSegment2);
            double actualMinimumDistance = EuclidCoreMissingTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart22, (Point2DReadOnly)lineSegmentEnd22);
            Assert.assertEquals(expectedMinimumDistance, actualMinimumDistance, 1.0E-12);
            actualMinimumDistance = EuclidCoreMissingTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentEnd22, (Point2DReadOnly)lineSegmentStart22);
            Assert.assertEquals(expectedMinimumDistance, actualMinimumDistance, 1.0E-12);
            actualMinimumDistance = EuclidCoreMissingTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentStart22, (Point2DReadOnly)lineSegmentEnd22);
            Assert.assertEquals(expectedMinimumDistance, actualMinimumDistance, 1.0E-12);
            actualMinimumDistance = EuclidCoreMissingTools.distanceBetweenTwoLineSegment2Ds((Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd22, (Point2DReadOnly)lineSegmentStart22);
            Assert.assertEquals(expectedMinimumDistance, actualMinimumDistance, 1.0E-12);
        }
    }

    @Test
    public void testExtractNormalPart() {
        Random random = new Random(6457L);
        for (int i = 0; i < 1000; ++i) {
            Vector3D normalAxis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            Vector3D tangentialAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)normalAxis, (boolean)true);
            Vector3D normalPart = new Vector3D();
            Vector3D tangentialPart = new Vector3D();
            double normalMagnitude = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            double tangentialMagnitude = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            normalPart.setAndScale(normalMagnitude, (Tuple3DReadOnly)normalAxis);
            tangentialPart.setAndScale(tangentialMagnitude, (Tuple3DReadOnly)tangentialAxis);
            Vector3D input = new Vector3D();
            input.add((Tuple3DReadOnly)normalPart, (Tuple3DReadOnly)tangentialPart);
            Vector3D actualNormalPart = new Vector3D();
            EuclidCoreMissingTools.extractNormalPart((Tuple3DReadOnly)input, (Vector3DReadOnly)normalAxis, (Tuple3DBasics)actualNormalPart);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)normalPart, (EuclidGeometry)actualNormalPart, (double)1.0E-12);
            normalAxis.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            EuclidCoreMissingTools.extractNormalPart((Tuple3DReadOnly)input, (Vector3DReadOnly)normalAxis, (Tuple3DBasics)actualNormalPart);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)normalPart, (EuclidGeometry)actualNormalPart, (double)1.0E-12);
        }
    }

    @Test
    public void testExtractTangentialPart() {
        Vector3D actualTangentialPart;
        Vector3D input;
        double tangentialMagnitude;
        double normalMagnitude;
        Vector3D tangentialPart;
        Vector3D normalPart;
        Axis3D tangentialAxis;
        Axis3D normalAxis;
        int i;
        Random random = new Random(63457L);
        for (i = 0; i < 1000; ++i) {
            normalAxis = EuclidCoreRandomTools.nextAxis3D((Random)random);
            tangentialAxis = random.nextBoolean() ? normalAxis.next() : normalAxis.previous();
            normalPart = new Vector3D();
            tangentialPart = new Vector3D();
            normalMagnitude = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            tangentialMagnitude = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            normalPart.setAndScale(normalMagnitude, (Tuple3DReadOnly)normalAxis);
            tangentialPart.setAndScale(tangentialMagnitude, (Tuple3DReadOnly)tangentialAxis);
            input = new Vector3D();
            input.add((Tuple3DReadOnly)normalPart, (Tuple3DReadOnly)tangentialPart);
            actualTangentialPart = new Vector3D();
            EuclidCoreMissingTools.extractTangentialPart((Tuple3DReadOnly)input, (Vector3DReadOnly)normalAxis, (Tuple3DBasics)actualTangentialPart);
            EuclidCoreTestTools.assertEquals((String)("Iteration: " + i), (EuclidGeometry)tangentialPart, (EuclidGeometry)actualTangentialPart, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            normalAxis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            tangentialAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)normalAxis, (boolean)true);
            normalPart = new Vector3D();
            tangentialPart = new Vector3D();
            normalMagnitude = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            tangentialMagnitude = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            normalPart.setAndScale(normalMagnitude, (Tuple3DReadOnly)normalAxis);
            tangentialPart.setAndScale(tangentialMagnitude, (Tuple3DReadOnly)tangentialAxis);
            input = new Vector3D();
            input.add((Tuple3DReadOnly)normalPart, (Tuple3DReadOnly)tangentialPart);
            actualTangentialPart = new Vector3D();
            EuclidCoreMissingTools.extractTangentialPart((Tuple3DReadOnly)input, (Vector3DReadOnly)normalAxis, (Tuple3DBasics)actualTangentialPart);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tangentialPart, (EuclidGeometry)actualTangentialPart, (double)1.0E-12);
            normalAxis.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            EuclidCoreMissingTools.extractTangentialPart((Tuple3DReadOnly)input, (Vector3DReadOnly)normalAxis, (Tuple3DBasics)actualTangentialPart);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)tangentialPart, (EuclidGeometry)actualTangentialPart, (double)1.0E-12);
        }
    }

    @Test
    public void testIntersectionBetweenRay2DAndLine2D() {
        Point2D rayOrigin = new Point2D(8.689, 0.5687);
        Point2D pointOnRay = new Point2D(8.6432, 0.4951);
        Vector2D rayDirection = new Vector2D();
        rayDirection.sub((Tuple2DReadOnly)pointOnRay, (Tuple2DReadOnly)rayOrigin);
        Point2D lineStart = new Point2D(8.4521, 0.4323);
        Point2D lineEnd = new Point2D(8.776, 0.5267);
        Vector2D lineDirection = new Vector2D();
        lineDirection.sub((Tuple2DReadOnly)lineEnd, (Tuple2DReadOnly)lineStart);
        Point2D intersectionToPac = new Point2D();
        Assert.assertTrue(EuclidCoreMissingTools.intersectionBetweenRay2DAndLine2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineStart, (Vector2DReadOnly)lineDirection, (Point2DBasics)intersectionToPac));
        Point2D intersectionExpected = new Point2D();
        EuclidGeometryTools.intersectionBetweenLine2DAndLineSegment2D((Point2DReadOnly)rayOrigin, (Vector2DReadOnly)rayDirection, (Point2DReadOnly)lineStart, (Point2DReadOnly)lineEnd, (Point2DBasics)intersectionExpected);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)intersectionExpected, (Point2DReadOnly)intersectionToPac, (double)1.0E-5);
    }

    @Test
    public void testSetNormalPart() {
        Vector3D expected;
        Vector3D tupleToModify;
        Point3D input;
        double tangentialMagnitude;
        double normalMagnitude;
        Vector3D tangentialPart;
        Vector3D normalPart;
        Axis3D tangentialAxis;
        Axis3D normalAxis;
        int i;
        Random random = new Random(897632L);
        for (i = 0; i < 1000; ++i) {
            normalAxis = EuclidCoreRandomTools.nextAxis3D((Random)random);
            tangentialAxis = random.nextBoolean() ? normalAxis.next() : normalAxis.previous();
            normalPart = new Vector3D();
            tangentialPart = new Vector3D();
            normalMagnitude = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            tangentialMagnitude = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            normalPart.setAndScale(normalMagnitude, (Tuple3DReadOnly)normalAxis);
            tangentialPart.setAndScale(tangentialMagnitude, (Tuple3DReadOnly)tangentialAxis);
            input = new Point3D((Tuple3DReadOnly)normalPart);
            input.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)tangentialPart, (Tuple3DReadOnly)input);
            tupleToModify = new Vector3D((Tuple3DReadOnly)tangentialPart);
            tupleToModify.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)normalPart, (Tuple3DReadOnly)tupleToModify);
            expected = new Vector3D();
            expected.add((Tuple3DReadOnly)normalPart, (Tuple3DReadOnly)tangentialPart);
            EuclidCoreMissingTools.setNormalPart((Tuple3DReadOnly)input, (Vector3DReadOnly)normalAxis, (Tuple3DBasics)tupleToModify);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)tupleToModify, (double)1.0E-12);
        }
        for (i = 0; i < 1000; ++i) {
            normalAxis = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
            tangentialAxis = EuclidCoreRandomTools.nextOrthogonalVector3D((Random)random, (Vector3DReadOnly)normalAxis, (boolean)true);
            normalPart = new Vector3D();
            tangentialPart = new Vector3D();
            normalMagnitude = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            tangentialMagnitude = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0);
            normalPart.setAndScale(normalMagnitude, (Tuple3DReadOnly)normalAxis);
            tangentialPart.setAndScale(tangentialMagnitude, (Tuple3DReadOnly)tangentialAxis);
            input = new Point3D((Tuple3DReadOnly)normalPart);
            input.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)tangentialPart, (Tuple3DReadOnly)input);
            tupleToModify = new Vector3D((Tuple3DReadOnly)tangentialPart);
            tupleToModify.scaleAdd(EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0), (Tuple3DReadOnly)normalPart, (Tuple3DReadOnly)tupleToModify);
            expected = new Vector3D();
            expected.add((Tuple3DReadOnly)normalPart, (Tuple3DReadOnly)tangentialPart);
            EuclidCoreMissingTools.setNormalPart((Tuple3DReadOnly)input, (Vector3DReadOnly)normalAxis, (Tuple3DBasics)tupleToModify);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)tupleToModify, (double)1.0E-12);
            normalAxis.scale(EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            EuclidCoreMissingTools.setNormalPart((Tuple3DReadOnly)input, (Vector3DReadOnly)normalAxis, (Tuple3DBasics)tupleToModify);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)tupleToModify, (double)1.0E-12);
        }
    }

    @Test
    public void testDifferentiateOrientation() {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            Quaternion qStart = EuclidCoreRandomTools.nextQuaternion((Random)random);
            double duration = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)0.01);
            double angle = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)Math.PI);
            UnitVector3D velocityAxis = EuclidCoreRandomTools.nextUnitVector3D((Random)random);
            Vector3D expectedAngularVelocity = new Vector3D();
            expectedAngularVelocity.setAndScale(angle / duration, (Tuple3DReadOnly)velocityAxis);
            Quaternion qEnd = new Quaternion();
            qEnd.setRotationVector(velocityAxis.getX() * angle, velocityAxis.getY() * angle, velocityAxis.getZ() * angle);
            qEnd.prepend((Orientation3DReadOnly)qStart);
            Vector3D actualAngularVelocity = new Vector3D();
            EuclidCoreMissingTools.differentiateOrientation((QuaternionReadOnly)qStart, (QuaternionReadOnly)qEnd, (double)duration, (Vector3DBasics)actualAngularVelocity);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularVelocity, (EuclidGeometry)actualAngularVelocity, (double)(1.0E-12 * Math.max(1.0, expectedAngularVelocity.norm())));
        }
    }

    public static Vector2D nextOrthogonalVector2D(Random random, Vector2DReadOnly vectorToBeOrthogonalTo, boolean normalize) {
        Vector2D v1 = new Vector2D(vectorToBeOrthogonalTo.getY(), -vectorToBeOrthogonalTo.getX());
        Vector2D randomPerpendicular = new Vector2D();
        double a = EuclidCoreMissingToolsTest.nextDouble(random, 1.0);
        randomPerpendicular.scaleAdd(a, (Tuple2DReadOnly)v1, (Tuple2DReadOnly)randomPerpendicular);
        if (normalize) {
            randomPerpendicular.normalize();
        }
        return randomPerpendicular;
    }

    public static double nextDouble(Random random, double minMaxValue) {
        return EuclidCoreMissingToolsTest.nextDouble(random, -minMaxValue, minMaxValue);
    }

    public static double nextDouble(Random random, double minValue, double maxValue) {
        if (minValue > maxValue) {
            throw new RuntimeException("Min is greater than max: min = " + minValue + ", max = " + maxValue);
        }
        return minValue + random.nextDouble() * (maxValue - minValue);
    }
}

