/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotDescription;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import us.ihmc.robotics.robotDescription.CollisionMaskHolder;

public class CollisionMasksHelper {
    private final LinkedHashMap<String, ArrayList<? extends CollisionMaskHolder>> groups = new LinkedHashMap();
    private final LinkedHashMap<ArrayList<? extends CollisionMaskHolder>, Integer> groupBits = new LinkedHashMap();
    private int nextGroupBitMask = 1;

    public void addCollisionGroup(String name, ArrayList<? extends CollisionMaskHolder> group) {
        if (this.nextGroupBitMask == 0) {
            throw new RuntimeException("Number of groups at maximum of 32!");
        }
        this.groups.put(name, group);
        int groupBit = this.nextGroupBitMask;
        this.groupBits.put(group, groupBit);
        this.addToCollisionGroups(group, groupBit);
        this.nextGroupBitMask <<= 1;
    }

    public int getNextGroupBitMask() {
        return this.nextGroupBitMask;
    }

    public ArrayList<? extends CollisionMaskHolder> getCollisionGroup(String name) {
        return this.groups.get(name);
    }

    public void setToCollideWithGroup(String groupOneName, String groupTwoName) {
        ArrayList<? extends CollisionMaskHolder> groupOne = this.groups.get(groupOneName);
        ArrayList<? extends CollisionMaskHolder> groupTwo = this.groups.get(groupTwoName);
        Integer bitOne = this.groupBits.get(groupOne);
        Integer bitTwo = this.groupBits.get(groupTwo);
        this.addToCollisionMasks(groupOne, bitTwo);
        this.addToCollisionMasks(groupTwo, bitOne);
    }

    public void addToCollisionMasks(String name, int collisionMaskToAdd) {
        ArrayList<? extends CollisionMaskHolder> group = this.groups.get(name);
        this.addToCollisionMasks(group, (Integer)collisionMaskToAdd);
    }

    public void setAsSelfCollidingGroup(String name) {
        ArrayList<? extends CollisionMaskHolder> group = this.groups.get(name);
        Integer groupBit = this.groupBits.get(group);
        this.addToCollisionMasks(group, groupBit);
    }

    public void setAsNonSelfCollidingGroup(String name) {
        ArrayList<? extends CollisionMaskHolder> group = this.groups.get(name);
        Integer groupBit = this.groupBits.get(group);
        this.removeFromCollisionMasks(group, groupBit);
    }

    private void addToCollisionGroups(ArrayList<? extends CollisionMaskHolder> group, int groupBitsToAddToGroupMasks) {
        for (int i = 0; i < group.size(); ++i) {
            CollisionMaskHolder collisionMaskHolder = group.get(i);
            collisionMaskHolder.setCollisionGroup(collisionMaskHolder.getCollisionGroup() | groupBitsToAddToGroupMasks);
        }
    }

    private void addToCollisionMasks(ArrayList<? extends CollisionMaskHolder> group, Integer groupBitsToAddToCollisionMasks) {
        for (int i = 0; i < group.size(); ++i) {
            CollisionMaskHolder collisionMaskHolder = group.get(i);
            collisionMaskHolder.setCollisionMask(collisionMaskHolder.getCollisionMask() | groupBitsToAddToCollisionMasks);
        }
    }

    private void removeFromCollisionMasks(ArrayList<? extends CollisionMaskHolder> group, Integer groupBitsToRemoveFromCollisionMasks) {
        for (int i = 0; i < group.size(); ++i) {
            CollisionMaskHolder collisionMaskHolder = group.get(i);
            collisionMaskHolder.setCollisionMask(collisionMaskHolder.getCollisionMask() & (0xFFFFFFFF ^ groupBitsToRemoveFromCollisionMasks));
        }
    }
}

