/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotDescription;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.robotics.robotDescription.ConvexShapeDescriptionReadOnly;

public class CapsuleDescriptionReadOnly
implements ConvexShapeDescriptionReadOnly {
    private final double radius;
    private final LineSegment3D capToCapLineSegment = new LineSegment3D();

    public CapsuleDescriptionReadOnly(double radius, double height, RigidBodyTransform transformToCenter) {
        this(radius, height, Axis3D.Z, transformToCenter);
    }

    public CapsuleDescriptionReadOnly(double radius, LineSegment3D capToCapLineSegment, RigidBodyTransform transformToCenter) {
        this.radius = radius;
        this.capToCapLineSegment.set(capToCapLineSegment);
        capToCapLineSegment.applyTransform((Transform)transformToCenter);
    }

    public CapsuleDescriptionReadOnly(double radius, double height, Axis3D longAxis, RigidBodyTransform transformToCenter) {
        if (height < 2.0 * radius) {
            throw new RuntimeException("Capsule height must be at least 2.0 * radius!");
        }
        this.radius = radius;
        switch (longAxis) {
            case X: {
                this.capToCapLineSegment.set(-height / 2.0 + radius, 0.0, 0.0, 0.0, 0.0, height / 2.0 - radius);
                break;
            }
            case Y: {
                this.capToCapLineSegment.set(0.0, -height / 2.0 + radius, 0.0, 0.0, height / 2.0 - radius, 0.0);
                break;
            }
            case Z: {
                this.capToCapLineSegment.set(0.0, 0.0, -height / 2.0 + radius, 0.0, 0.0, height / 2.0 - radius);
            }
        }
        this.capToCapLineSegment.applyTransform((Transform)transformToCenter);
    }

    public double getRadius() {
        return this.radius;
    }

    public void getCapToCapLineSegment(LineSegment3D lineSegmentToPack) {
        lineSegmentToPack.set(this.capToCapLineSegment);
    }

    @Override
    public CapsuleDescriptionReadOnly copy() {
        return new CapsuleDescriptionReadOnly(this.radius, this.capToCapLineSegment, new RigidBodyTransform());
    }
}

