/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotDescription;

import java.util.ArrayList;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.robotics.robotDescription.CameraSensorDescription;
import us.ihmc.robotics.robotDescription.FloatingPlanarJointDescription;
import us.ihmc.robotics.robotDescription.GroundContactPointDescription;
import us.ihmc.robotics.robotDescription.IMUSensorDescription;
import us.ihmc.robotics.robotDescription.JointDescription;
import us.ihmc.robotics.robotDescription.JointWrenchSensorDescription;
import us.ihmc.robotics.robotDescription.LinkDescription;
import us.ihmc.robotics.robotDescription.LinkGraphicsDescription;
import us.ihmc.robotics.robotDescription.PinJointDescription;
import us.ihmc.robotics.robotDescription.Plane;
import us.ihmc.robotics.robotDescription.RobotDescription;

public class RobotDescriptionUsingSpringFlamingoTest {
    private static final boolean SHOW_CARTOON_GRAPHICS = true;
    private static final boolean SHOW_MASS_PROPERTIES_GRAPHICS = false;
    private static final double UPPER_LEG_MASS = 0.4598;
    private static final double UPPER_LEG_Ixx = 0.01256;
    private static final double UPPER_LEG_Iyy = 0.01256;
    private static final double UPPER_LEG_Izz = 1.3E-4;
    private static final double LOWER_LEG_MASS = 0.306;
    private static final double LOWER_LEG_Ixx = 0.00952;
    private static final double LOWER_LEG_Iyy = 0.00952;
    private static final double LOWER_LEG_Izz = 5.67E-5;
    private static final double FOOT_MASS = 0.3466;
    private static final double FOOT_Ixx = 7.15E-5;
    private static final double FOOT_Iyy = 0.0015;
    private static final double FOOT_Izz = 0.0015;
    private static final double BODY_Z = 0.385;
    private static final double BODY_Y = 0.12;
    private static final double BODY_X = 0.05;
    private static final double BODY_CG_Z = 0.2;
    private static final double BODY_Z_LEGPLOT = 0.21;
    private static final double BODY_Y_LEGPLOT = 0.363;
    private static final double BODY_X_LEGPLOT = 0.45;
    private static final double UPPER_LINK_LENGTH = 0.42;
    private static final double UPPER_LEG_ZMAX = 0.0;
    private static final double UPPER_LEG_ZMIN = -0.42;
    private static final double UPPER_LEG_Y = 0.02175;
    private static final double UPPER_LEG_X = 0.02175;
    private static final double LOWER_LINK_LENGTH = 0.42;
    private static final double LOWER_LEG_ZMAX = 0.0;
    private static final double LOWER_LEG_ZMIN = -0.42;
    private static final double LOWER_LEG_Y = 0.02175;
    private static final double LOWER_LEG_X = 0.02175;
    private static final double FOOT_ZMIN = -0.04;
    private static final double FOOT_ZMAX = -0.01;
    private static final double FOOT_Y = 0.04;
    private static final double FOOT_X = 0.23;
    private static final double FOOT_H = 0.04;
    private static final double FOOT_OFFSET_PERCENT = 0.25;
    private static final double FOOT_FORWARD = 0.0575;
    private static final double FOOT_BEHIND = 0.17250000000000001;
    private static final double HIP_OFFSET_Y = 0.12;

    @Test
    public void testUsingSpringFlamingoRobotDescription() {
        ArrayList<GroundContactPointDescription> gcPoints = new ArrayList<GroundContactPointDescription>(4);
        RobotDescription robotDescription = new RobotDescription("SpringFlamingo");
        FloatingPlanarJointDescription plane = new FloatingPlanarJointDescription("plane", Plane.XZ);
        LinkDescription body = this.body();
        plane.setLink(body);
        robotDescription.addRootJoint((JointDescription)plane);
        RigidBodyTransform camRotation = new RigidBodyTransform();
        camRotation.setRotationYawAndZeroTranslation(Math.PI);
        CameraSensorDescription robotCam = new CameraSensorDescription("robot cam mount", (RigidBodyTransformReadOnly)camRotation);
        plane.addCameraSensor(robotCam);
        RigidBodyTransform imuTransform = new RigidBodyTransform();
        imuTransform.getTranslation().set((Tuple3DReadOnly)new Vector3D(0.0, 0.0, 0.2));
        IMUSensorDescription imuMount = new IMUSensorDescription("FlamingoIMU", imuTransform);
        plane.addIMUSensor(imuMount);
        PinJointDescription rightHip = new PinJointDescription("rh", (Tuple3DReadOnly)new Vector3D(0.0, -0.12, 0.0), (Vector3DReadOnly)Axis3D.Y);
        LinkDescription r_upper_leg = this.upper_leg("r_upper_leg");
        rightHip.setLink(r_upper_leg);
        plane.addJoint((JointDescription)rightHip);
        JointWrenchSensorDescription rightHipWrenchSensor = new JointWrenchSensorDescription("rightHipWrenchSensor", new Vector3D());
        rightHip.addJointWrenchSensor(rightHipWrenchSensor);
        PinJointDescription rightKnee = new PinJointDescription("rk", (Tuple3DReadOnly)new Vector3D(0.0, 0.0, -0.42), (Vector3DReadOnly)Axis3D.Y);
        LinkDescription r_lower_leg = this.lower_leg("r_lower_leg");
        rightKnee.setLink(r_lower_leg);
        rightHip.addJoint((JointDescription)rightKnee);
        rightKnee.setLimitStops(-Math.PI, 0.0, 1000.0, 40.0);
        JointWrenchSensorDescription rightKneeWrenchSensor = new JointWrenchSensorDescription("rightKneeWrenchSensor", new Vector3D());
        rightKnee.addJointWrenchSensor(rightKneeWrenchSensor);
        PinJointDescription rightAnkle = new PinJointDescription("ra", (Tuple3DReadOnly)new Vector3D(0.0, 0.0, -0.42), (Vector3DReadOnly)Axis3D.Y);
        LinkDescription r_foot = this.foot("r_foot");
        rightAnkle.setLink(r_foot);
        rightKnee.addJoint((JointDescription)rightAnkle);
        GroundContactPointDescription gc_rheel = new GroundContactPointDescription("gc_rheel", new Vector3D(0.0575, 0.0, -0.04));
        GroundContactPointDescription gc_rtoe = new GroundContactPointDescription("gc_rtoe", new Vector3D(-0.17250000000000001, 0.0, -0.04));
        gcPoints.add(gc_rheel);
        gcPoints.add(gc_rtoe);
        rightAnkle.addGroundContactPoint(gc_rheel);
        rightAnkle.addGroundContactPoint(gc_rtoe);
        JointWrenchSensorDescription rightAnkleWrenchSensor = new JointWrenchSensorDescription("rightAnkleWrenchSensor", new Vector3D());
        rightAnkle.addJointWrenchSensor(rightAnkleWrenchSensor);
        PinJointDescription leftHip = new PinJointDescription("lh", (Tuple3DReadOnly)new Vector3D(0.0, 0.12, 0.0), (Vector3DReadOnly)Axis3D.Y);
        LinkDescription l_upper_leg = this.upper_leg("l_upper_leg");
        leftHip.setLink(l_upper_leg);
        plane.addJoint((JointDescription)leftHip);
        JointWrenchSensorDescription leftHipWrenchSensor = new JointWrenchSensorDescription("leftHipWrenchSensor", new Vector3D());
        leftHip.addJointWrenchSensor(leftHipWrenchSensor);
        PinJointDescription leftKnee = new PinJointDescription("lk", (Tuple3DReadOnly)new Vector3D(0.0, 0.0, -0.42), (Vector3DReadOnly)Axis3D.Y);
        LinkDescription l_lower_leg = this.lower_leg("l_lower_leg");
        leftKnee.setLink(l_lower_leg);
        leftHip.addJoint((JointDescription)leftKnee);
        leftKnee.setLimitStops(-Math.PI, 0.0, 1000.0, 40.0);
        JointWrenchSensorDescription leftKneeWrenchSensor = new JointWrenchSensorDescription("leftKneeWrenchSensor", new Vector3D());
        leftKnee.addJointWrenchSensor(leftKneeWrenchSensor);
        PinJointDescription leftAnkle = new PinJointDescription("la", (Tuple3DReadOnly)new Vector3D(0.0, 0.0, -0.42), (Vector3DReadOnly)Axis3D.Y);
        LinkDescription l_foot = this.foot("l_foot");
        leftAnkle.setLink(l_foot);
        leftKnee.addJoint((JointDescription)leftAnkle);
        GroundContactPointDescription gc_lheel = new GroundContactPointDescription("gc_lheel", new Vector3D(0.0575, 0.0, -0.04));
        GroundContactPointDescription gc_ltoe = new GroundContactPointDescription("gc_ltoe", new Vector3D(-0.17250000000000001, 0.0, -0.04));
        gcPoints.add(gc_lheel);
        gcPoints.add(gc_ltoe);
        leftAnkle.addGroundContactPoint(gc_lheel);
        leftAnkle.addGroundContactPoint(gc_ltoe);
        JointWrenchSensorDescription leftAnkleWrenchSensor = new JointWrenchSensorDescription("leftAnkleWrenchSensor", new Vector3D());
        leftAnkle.addJointWrenchSensor(leftAnkleWrenchSensor);
    }

    private LinkDescription body() {
        LinkDescription ret = new LinkDescription("body");
        ret.setMass(12.0);
        ret.setMomentOfInertia(0.1, 0.1, 0.1);
        ret.setCenterOfMassOffset(0.0, 0.0, 0.2);
        AppearanceDefinition bodyAppearance = YoAppearance.Red();
        LinkGraphicsDescription linkGraphics = new LinkGraphicsDescription();
        linkGraphics.translate(0.0, 0.12, 0.0);
        linkGraphics.rotate(-0.9599310885968813, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.identity();
        linkGraphics.translate(0.0, -0.12, 0.0);
        linkGraphics.rotate(-0.9599310885968813, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.rotate(0.1279849940487442, Axis3D.Y);
        linkGraphics.addCube(0.05, 0.12, 0.385, bodyAppearance);
        linkGraphics.identity();
        linkGraphics.rotate(1.5707963267948966, Axis3D.X);
        linkGraphics.translate(0.0, 0.0, -0.185);
        linkGraphics.addCylinder(0.37, 0.025);
        ret.setLinkGraphics(linkGraphics);
        return ret;
    }

    private LinkDescription upper_leg(String name) {
        LinkDescription ret = new LinkDescription(name);
        AppearanceDefinition pulleyAppearance = YoAppearance.Red();
        ret.setMass(0.4598);
        ret.setMomentOfInertia(0.01256, 0.01256, 1.3E-4);
        ret.setCenterOfMassOffset(0.0, 0.0, -0.3029);
        LinkGraphicsDescription linkGraphics = new LinkGraphicsDescription();
        linkGraphics.translate(0.0, 0.0, -0.42);
        linkGraphics.addCube(0.025, 0.053, 0.054, YoAppearance.AluminumMaterial());
        linkGraphics.translate(0.0, 0.0, 0.054);
        linkGraphics.addCylinder(0.308, 0.0113, YoAppearance.BlackMetalMaterial());
        linkGraphics.translate(0.0, 0.0, 0.308);
        linkGraphics.addCube(0.025, 0.053, 0.047, YoAppearance.AluminumMaterial());
        linkGraphics.identity();
        linkGraphics.translate(0.0, 0.0, -0.42);
        linkGraphics.rotate(1.5707963267948966, Axis3D.X);
        linkGraphics.translate(0.0, 0.0, -0.005);
        linkGraphics.addCylinder(0.01, 0.033, pulleyAppearance);
        linkGraphics.identity();
        linkGraphics.translate(0.0, 0.0, -0.42);
        linkGraphics.rotate(1.5707963267948966, Axis3D.X);
        linkGraphics.translate(0.0, 0.0, -0.013);
        linkGraphics.addCylinder(0.025, 0.015, pulleyAppearance);
        ret.setLinkGraphics(linkGraphics);
        return ret;
    }

    private LinkDescription lower_leg(String name) {
        LinkDescription ret = new LinkDescription(name);
        ret.setMass(0.306);
        ret.setMomentOfInertia(0.00952, 0.00952, 5.67E-5);
        ret.setCenterOfMassOffset(0.0, 0.0, -0.1818);
        LinkGraphicsDescription linkGraphics = new LinkGraphicsDescription();
        linkGraphics.translate(0.0, 0.0, -0.42);
        linkGraphics.addCube(0.025, 0.04, 0.04, YoAppearance.AluminumMaterial());
        linkGraphics.translate(0.0, 0.0, 0.04);
        linkGraphics.addCylinder(0.308, 0.0113, YoAppearance.BlackMetalMaterial());
        linkGraphics.translate(0.0, 0.0, 0.308);
        linkGraphics.addCube(0.025, 0.04, 0.062, YoAppearance.AluminumMaterial());
        ret.setLinkGraphics(linkGraphics);
        return ret;
    }

    private LinkDescription foot(String name) {
        LinkDescription ret = new LinkDescription(name);
        ret.setMass(0.3466);
        ret.setMomentOfInertia(7.15E-5, 0.0015, 0.0015);
        ret.setCenterOfMassOffset(-0.0458, 0.0, -0.0309);
        LinkGraphicsDescription linkGraphics = new LinkGraphicsDescription();
        linkGraphics.translate(-0.0575, 0.0, -0.04);
        linkGraphics.addCube(0.23, 0.04, 0.03);
        linkGraphics.identity();
        linkGraphics.translate(0.0, 0.0, -0.01);
        linkGraphics.addCube(0.028, 0.028, 0.01);
        ret.setLinkGraphics(linkGraphics);
        return ret;
    }
}

