/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.dataBuffers;

import gnu.trove.map.hash.TIntLongHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.robotDataLogger.LogDataType;
import us.ihmc.robotDataLogger.YoVariableClientImplementation;
import us.ihmc.robotDataLogger.dataBuffers.RegistryDecompressor;
import us.ihmc.robotDataLogger.dataBuffers.RegistryReceiveBuffer;
import us.ihmc.robotDataLogger.handshake.IDLYoVariableHandshakeParser;
import us.ihmc.robotDataLogger.util.DebugRegistry;

public class RegistryConsumer
extends Thread {
    private static final int MAXIMUM_ELEMENTS = 4096;
    private final PriorityBlockingQueue<RegistryReceiveBuffer> orderedBuffers = new PriorityBlockingQueue();
    private volatile boolean running = true;
    private boolean firstSample = true;
    private final IDLYoVariableHandshakeParser parser;
    private final RegistryDecompressor registryDecompressor;
    private final YoVariableClientImplementation listener;
    private final TIntLongHashMap lastRegistryUid = new TIntLongHashMap();
    private long previousTransmitTime = -1L;
    private long previousReceiveTime = -1L;
    private double jitterEstimate = 0.0;
    private double samples = 0.0;
    private double averageTimeBetweenPackets = 0.0;
    private volatile int jitterBufferSamples = 1;
    private long previousTimestamp = -1L;
    private long lastPacketReceived;
    private final DebugRegistry debugRegistry;

    public RegistryConsumer(IDLYoVariableHandshakeParser parser, YoVariableClientImplementation yoVariableClient, DebugRegistry debugRegistry) {
        this.parser = parser;
        this.registryDecompressor = new RegistryDecompressor(parser.getYoVariablesList(), parser.getJointStates());
        this.listener = yoVariableClient;
        this.debugRegistry = debugRegistry;
        this.start();
    }

    @Override
    public void run() {
        this.lastPacketReceived = System.nanoTime();
        while (this.running) {
            ThreadTools.sleep((long)1L);
            while (this.orderedBuffers.size() > this.jitterBufferSamples + this.lastRegistryUid.size() + 1) {
                try {
                    this.handlePackets();
                    this.lastPacketReceived = System.nanoTime();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        while (!this.orderedBuffers.isEmpty()) {
            try {
                this.handlePackets();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.listener.connectionClosed();
    }

    public void stopImmediately() {
        this.running = false;
    }

    private void decompressBuffer(RegistryReceiveBuffer buffer) {
        long previousUid = this.lastRegistryUid.put(buffer.getRegistryID(), buffer.getUid());
        this.updateDebugVariables(buffer, previousUid);
        this.registryDecompressor.decompressSegment(buffer, this.parser.getVariableOffset(buffer.getRegistryID()));
    }

    void updateDebugVariables(RegistryReceiveBuffer buffer, long previousUid) {
        if (previousUid != this.lastRegistryUid.getNoEntryValue() && buffer.getUid() != previousUid + 1L) {
            if (buffer.getUid() < previousUid) {
                this.debugRegistry.getPacketsOutOfOrder().increment();
            } else {
                this.debugRegistry.getSkippedPackets().add((int)(buffer.getUid() - previousUid - 1L));
            }
        }
        this.debugRegistry.getTotalPackets().increment();
    }

    private void handlePackets() throws InterruptedException {
        RegistryReceiveBuffer buffer = this.orderedBuffers.take();
        if (buffer.getType() == LogDataType.DATA_PACKET) {
            long timestamp = buffer.getTimestamp();
            this.decompressBuffer(buffer);
            while (!this.orderedBuffers.isEmpty() && this.orderedBuffers.peek().getTimestamp() == timestamp) {
                RegistryReceiveBuffer next = this.orderedBuffers.take();
                this.decompressBuffer(next);
                this.debugRegistry.getMergedPackets().increment();
            }
            if (this.previousTimestamp != -1L && this.previousTimestamp >= buffer.getTimestamp()) {
                this.debugRegistry.getNonIncreasingTimestamps().increment();
            }
            this.previousTimestamp = buffer.getTimestamp();
            if (this.firstSample) {
                this.listener.connected();
                this.firstSample = false;
            } else {
                this.listener.receivedTimestampAndData(timestamp);
            }
        }
    }

    public void onNewDataMessage(RegistryReceiveBuffer buffer) {
        if (this.previousTransmitTime != -1L) {
            long D = buffer.getReceivedTimestamp() - this.previousReceiveTime - (buffer.getTransmitTime() - this.previousTransmitTime);
            if (D < 0L) {
                D = -D;
            }
            this.jitterEstimate += ((double)D - this.jitterEstimate) / 16.0;
            this.samples += 1.0;
            this.averageTimeBetweenPackets += ((double)(buffer.getTransmitTime() - this.previousTransmitTime) - this.averageTimeBetweenPackets) / this.samples;
            this.jitterBufferSamples = (int)(Math.ceil(this.jitterEstimate / this.averageTimeBetweenPackets) + 1.0);
            if (this.jitterBufferSamples > 2048) {
                this.jitterBufferSamples = 2048;
            }
        }
        this.previousTransmitTime = buffer.getTransmitTime();
        this.previousReceiveTime = buffer.getReceivedTimestamp();
        if (this.orderedBuffers.size() < 4096) {
            this.orderedBuffers.add(buffer);
        } else {
            this.debugRegistry.getSkippedPacketDueToFullBuffer().increment();
        }
    }

    public void setVariableSynchronizer(Object variableSynchronizer) {
        this.registryDecompressor.setVariableSynchronizer(variableSynchronizer);
    }
}

