/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.util;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import us.ihmc.robotDataLogger.RobotVisualizer;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.util.PeriodicNonRealtimeThreadScheduler;
import us.ihmc.util.PeriodicNonRealtimeThreadSchedulerFactory;
import us.ihmc.util.PeriodicThreadScheduler;
import us.ihmc.util.PeriodicThreadSchedulerFactory;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoTools;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class JVMStatisticsGenerator {
    private final PeriodicThreadScheduler scheduler;
    private final JVMStatisticsGeneratorThread jvmStatisticsGeneratorThread = new JVMStatisticsGeneratorThread();
    private final YoRegistry registry = new YoRegistry("JVMStatistics");
    private final RobotVisualizer visualizer;
    private final YoLong freeMemory = new YoLong("freeMemoryInBytes", this.registry);
    private final YoLong maxMemory = new YoLong("maxMemoryInBytes", this.registry);
    private final YoLong usedMemory = new YoLong("usedMemoryInBytes", this.registry);
    private final YoLong totalMemory = new YoLong("totalMemoryInBytes", this.registry);
    private final YoLong totalGCInvocations = new YoLong("totalGCInvocations", this.registry);
    private final YoLong totalGCTotalCollectionTimeMs = new YoLong("gcTotalCollectionTimeMs", this.registry);
    private final YoInteger loadedClassCount = new YoInteger("loadedClassCount", this.registry);
    private final YoLong totalLoadedClassCount = new YoLong("totalLoadedClassCount", this.registry);
    private final YoLong unloadedClassCount = new YoLong("unloadedClassCount", this.registry);
    private final YoLong totalCompilationTime = new YoLong("totalCompilationTimeMs", this.registry);
    private final YoInteger availableProcessors = new YoInteger("availableProcessors", this.registry);
    private final YoDouble systemLoadAverage = new YoDouble("systemLoadAverage", this.registry);
    private final ArrayList<GCBeanHolder> gcBeanHolders = new ArrayList();
    private final ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
    private final CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
    private final OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();

    public JVMStatisticsGenerator(RobotVisualizer visualizer) {
        this(visualizer, (PeriodicThreadSchedulerFactory)new PeriodicNonRealtimeThreadSchedulerFactory());
    }

    public JVMStatisticsGenerator(RobotVisualizer visualizer, PeriodicThreadSchedulerFactory schedulerFactory) {
        this.visualizer = visualizer;
        this.createGCBeanHolders();
        this.availableProcessors.set(this.operatingSystemMXBean.getAvailableProcessors());
        this.maxMemory.set(Runtime.getRuntime().maxMemory());
        visualizer.addRegistry(this.registry, null);
        this.scheduler = schedulerFactory.createPeriodicThreadScheduler(this.getClass().getSimpleName());
    }

    public JVMStatisticsGenerator(YoRegistry parentRegistry) {
        this.visualizer = null;
        this.createGCBeanHolders();
        this.availableProcessors.set(this.operatingSystemMXBean.getAvailableProcessors());
        this.maxMemory.set(Runtime.getRuntime().maxMemory());
        parentRegistry.addChild(this.registry);
        this.scheduler = new PeriodicNonRealtimeThreadScheduler(this.getClass().getSimpleName());
    }

    public void start() {
        this.scheduler.schedule((Runnable)this.jvmStatisticsGeneratorThread, 1L, TimeUnit.SECONDS);
    }

    public void runManual() {
        this.jvmStatisticsGeneratorThread.run();
    }

    public void createGCBeanHolders() {
        List<GarbageCollectorMXBean> gcbeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (int i = 0; i < gcbeans.size(); ++i) {
            GarbageCollectorMXBean gcbean = gcbeans.get(i);
            String name = YoTools.ILLEGAL_CHARACTERS_PATTERN.matcher(gcbean.getName()).replaceAll("");
            this.gcBeanHolders.add(new GCBeanHolder(name, gcbean));
        }
    }

    public void addVariablesToStatisticsGenerator(YoVariableServer server) {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(this);
        objects.addAll(this.gcBeanHolders);
        for (Object e : objects) {
            Field[] allFields;
            for (Field field : allFields = e.getClass().getDeclaredFields()) {
                if (!YoVariable.class.isAssignableFrom(field.getType())) continue;
                try {
                    YoVariable variable = (YoVariable)field.get(e);
                    server.addSummarizedVariable(variable);
                }
                catch (IllegalAccessException | IllegalArgumentException e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    private class JVMStatisticsGeneratorThread
    implements Runnable {
        private JVMStatisticsGeneratorThread() {
        }

        @Override
        public void run() {
            this.updateGCStatistics();
            this.updateClassLoadingStatistics();
            this.updateMemoryUsageStatistics();
            if (JVMStatisticsGenerator.this.compilationMXBean != null) {
                JVMStatisticsGenerator.this.totalCompilationTime.set(JVMStatisticsGenerator.this.compilationMXBean.getTotalCompilationTime());
            }
            JVMStatisticsGenerator.this.systemLoadAverage.set(JVMStatisticsGenerator.this.operatingSystemMXBean.getSystemLoadAverage());
            if (JVMStatisticsGenerator.this.visualizer != null) {
                JVMStatisticsGenerator.this.visualizer.update(JVMStatisticsGenerator.this.visualizer.getLatestTimestamp(), JVMStatisticsGenerator.this.registry);
            }
        }

        public void updateMemoryUsageStatistics() {
            JVMStatisticsGenerator.this.freeMemory.set(Runtime.getRuntime().freeMemory());
            JVMStatisticsGenerator.this.totalMemory.set(Runtime.getRuntime().totalMemory());
            JVMStatisticsGenerator.this.usedMemory.set(JVMStatisticsGenerator.this.totalMemory.getLongValue() - JVMStatisticsGenerator.this.freeMemory.getLongValue());
        }

        public void updateClassLoadingStatistics() {
            JVMStatisticsGenerator.this.loadedClassCount.set(JVMStatisticsGenerator.this.classLoadingMXBean.getLoadedClassCount());
            JVMStatisticsGenerator.this.totalLoadedClassCount.set(JVMStatisticsGenerator.this.classLoadingMXBean.getTotalLoadedClassCount());
            JVMStatisticsGenerator.this.unloadedClassCount.set(JVMStatisticsGenerator.this.classLoadingMXBean.getUnloadedClassCount());
        }

        public void updateGCStatistics() {
            long totalInvocations = 0L;
            long totalTime = 0L;
            for (int i = 0; i < JVMStatisticsGenerator.this.gcBeanHolders.size(); ++i) {
                GCBeanHolder holder = JVMStatisticsGenerator.this.gcBeanHolders.get(i);
                holder.update();
                totalInvocations += holder.gcInvocations.getLongValue();
                totalTime += holder.gcTotalCollectionTimeMs.getLongValue();
            }
            JVMStatisticsGenerator.this.totalGCInvocations.set(totalInvocations);
            JVMStatisticsGenerator.this.totalGCTotalCollectionTimeMs.set(totalTime);
        }
    }

    private class GCBeanHolder {
        final GarbageCollectorMXBean gcBean;
        final YoLong gcInvocations;
        final YoLong gcTotalCollectionTimeMs;

        GCBeanHolder(String name, GarbageCollectorMXBean gcBean) {
            this.gcBean = gcBean;
            this.gcInvocations = new YoLong(name + "GCInvocations", JVMStatisticsGenerator.this.registry);
            this.gcTotalCollectionTimeMs = new YoLong(name + "GCTotalTimeMs", JVMStatisticsGenerator.this.registry);
        }

        void update() {
            this.gcInvocations.set(this.gcBean.getCollectionCount());
            this.gcTotalCollectionTimeMs.set(this.gcBean.getCollectionTime());
        }
    }
}

