/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.command;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;

public enum DataServerCommand {
    SEND_TIMESTAMPS(false),
    LIMIT_RATE(false),
    CLEAR_LOG(true),
    LOG_ACTIVE(true),
    LOG_ACTIVE_WITH_CAMERA(true),
    START_LOG(true),
    STOP_LOG(true),
    RESTART_LOG(true);

    private static final int MAX_ARGUMENT_SIZE = 5;
    public static DataServerCommand[] values;
    private final ByteBuf content = Unpooled.copiedBuffer((CharSequence)this.toString(), (Charset)CharsetUtil.UTF_8);
    private final int length = this.content.readableBytes();
    private final boolean broadcast;

    public static int MaxCommandSize() {
        int maxSize = 0;
        for (DataServerCommand cmd : values) {
            if (cmd.toString().length() <= maxSize) continue;
            maxSize = cmd.length;
        }
        return maxSize + 5;
    }

    public static DataServerCommand getCommand(ByteBuf in) {
        for (DataServerCommand cmd : values) {
            if (!cmd.isThisCommand(in)) continue;
            return cmd;
        }
        return null;
    }

    private DataServerCommand(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public boolean broadcast() {
        return this.broadcast;
    }

    public boolean isThisCommand(ByteBuf test) {
        byte in;
        int i;
        if (test.readableBytes() != this.content.readableBytes() && test.readableBytes() != this.content.readableBytes() + 5) {
            return false;
        }
        for (i = 0; i < this.content.readableBytes(); ++i) {
            byte orig;
            in = test.getByte(test.readerIndex() + i);
            if (in == (orig = this.content.getByte(i))) continue;
            return false;
        }
        if (test.readableBytes() == this.content.readableBytes() + 5) {
            for (i = this.content.readableBytes(); i < test.readableBytes(); ++i) {
                in = test.getByte(test.readerIndex() + i);
                if (in >= 48 && in <= 57) continue;
                return false;
            }
        }
        return true;
    }

    public int getArgument(ByteBuf in) {
        if (in.readableBytes() == this.length) {
            return 0;
        }
        if (in.readableBytes() == this.length + 5) {
            int multiplier = (int)Math.pow(10.0, 5.0);
            int argument = 0;
            for (int i = 0; i < 5; ++i) {
                argument += (in.getByte(this.length + i) - 48) * (multiplier /= 10);
            }
            return argument;
        }
        return -1;
    }

    public void getBytes(ByteBuf out) {
        out.writeBytes(this.content, 0, this.content.readableBytes());
    }

    public void getBytes(ByteBuf out, int argument) {
        int multiplier = (int)Math.pow(10.0, 5.0);
        if (argument < 0 || argument >= multiplier) {
            throw new RuntimeException("Invalid argument");
        }
        out.writeBytes(this.content, 0, this.content.readableBytes());
        for (int i = 0; i < 5; ++i) {
            int val = argument / (multiplier /= 10) % 10;
            out.writeByte(val + 48);
        }
    }

    public static int getMaximumArgumentValue() {
        return (int)Math.pow(10.0, 5.0) - 1;
    }

    static {
        values = DataServerCommand.values();
    }
}

