/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class LogIndex {
    public long[] timestamps;
    public long[] dataOffsets;
    public int[] compressedSizes;
    private final int numberOfEntries;

    public LogIndex(File indexData, long channelSize) throws IOException {
        FileInputStream indexStream = new FileInputStream(indexData);
        FileChannel indexChannel = indexStream.getChannel();
        this.timestamps = new long[(int)(indexChannel.size() / 16L)];
        this.dataOffsets = new long[(int)(indexChannel.size() / 16L)];
        int index = 0;
        ByteBuffer indexDataBuffer = ByteBuffer.allocateDirect(16);
        while (indexChannel.read(indexDataBuffer) == 16) {
            indexDataBuffer.clear();
            this.timestamps[index] = indexDataBuffer.getLong(0);
            this.dataOffsets[index] = indexDataBuffer.getLong(8);
            ++index;
        }
        indexChannel.close();
        indexStream.close();
        this.compressedSizes = new int[this.dataOffsets.length];
        for (int i = 0; i < this.dataOffsets.length - 1; ++i) {
            this.compressedSizes[i] = (int)(this.dataOffsets[i + 1] - this.dataOffsets[i]);
        }
        this.compressedSizes[this.dataOffsets.length - 1] = (int)(channelSize - this.dataOffsets[this.dataOffsets.length - 1]);
        this.numberOfEntries = this.dataOffsets.length;
    }

    public int seek(long inStamp) {
        int head = 0;
        int tail = this.numberOfEntries;
        int position = -1;
        while (head < tail) {
            position = head + (tail - head) / 2;
            long timestamp = this.timestamps[position];
            if (timestamp < inStamp) {
                head = position + 1;
                continue;
            }
            tail = position;
        }
        return position;
    }

    public int getNumberOfEntries() {
        return this.dataOffsets.length;
    }

    public long getInitialTimestamp() {
        return this.timestamps[0];
    }
}

