/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.logger;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.ZEDSDKAnnounce;
import us.ihmc.robotDataLogger.logger.ZEDSVOLogger;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeBuilder;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.ROS2TopicNameTools;
import us.ihmc.zed.library.ZEDJavaAPINativeLibrary;

public class ZEDSVOLoggerManager {
    private static final boolean ZED_SDK_LOADED = ZEDJavaAPINativeLibrary.load();
    public static final ROS2Topic<ZEDSDKAnnounce> ZED_SDK_ANNOUNCE_TOPIC = new ROS2Topic().withType(ZEDSDKAnnounce.class).withSuffix("zed_sdk_announce");
    private final File tempDirectory;
    private final ROS2Node ros2Node;
    private final Map<ZEDSDKAnnounceHash, ZEDSVOLogger> zedLoggers = new ConcurrentHashMap<ZEDSDKAnnounceHash, ZEDSVOLogger>();

    public ZEDSVOLoggerManager(File tempDirectory, File finalDirectory) {
        this.tempDirectory = tempDirectory;
        LogTools.info((String)"Creating a ROS2Node for listening to ZED SDK connections.");
        this.ros2Node = new ROS2NodeBuilder().build(ROS2TopicNameTools.toROSTopicFormat((String)(finalDirectory.getName() + "_zed_svo_logger_node")));
        if (ZED_SDK_LOADED) {
            this.ros2Node.createSubscription2(ZED_SDK_ANNOUNCE_TOPIC, this::onZEDSDKAnnounceMessage);
        } else {
            LogTools.info((String)"ZED SDK not available on the system. Will not attempt to log SVO files.");
        }
    }

    private void onZEDSDKAnnounceMessage(ZEDSDKAnnounce message) {
        try {
            String secondWordInTempDirName = this.tempDirectory.getName().substring(1).split("(?=[A-Z])")[1];
            if (!message.getSensorNameAsString().startsWith(secondWordInTempDirName)) {
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException secondWordInTempDirName) {
            // empty catch block
        }
        ZEDSDKAnnounceHash announceHash = new ZEDSDKAnnounceHash(message.getAddressAsString(), message.getPort());
        if (this.zedLoggers.containsKey(announceHash)) {
            ZEDSVOLogger zedSVOLogger = this.zedLoggers.get(announceHash);
            if (zedSVOLogger.isClosed()) {
                this.zedLoggers.remove(announceHash);
            }
        } else if (message.getControllerTimestamp() != -1L) {
            File perceptionDir = new File(this.tempDirectory, "perception");
            perceptionDir.mkdirs();
            String svoFile = perceptionDir.getAbsolutePath() + File.separator + ZEDSVOLoggerManager.generateSVOFileName(message);
            String datFile = perceptionDir.getAbsolutePath() + File.separator + "%s%s".formatted(message.getSensorNameAsString(), "_Timestamps.dat");
            ZEDSVOLogger zedSVOLogger = new ZEDSVOLogger();
            zedSVOLogger.connect(svoFile, datFile, message.getAddressAsString(), message.getPort(), message.getFps(), message.getBitrate(), message.getSensorTimestamp(), message.getControllerTimestamp());
            this.zedLoggers.put(announceHash, zedSVOLogger);
        }
    }

    public void destroy() {
        this.zedLoggers.forEach((hostInstanceID, zedSVOLogger) -> zedSVOLogger.close());
        this.ros2Node.destroy();
    }

    private static String generateSVOFileName(ZEDSDKAnnounce message) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        return "%s_%s.svo2".formatted(dateFormat.format(new Date()), message.getSensorNameAsString());
    }

    private record ZEDSDKAnnounceHash(String address, int port) {
    }
}

