/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.util;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import us.ihmc.idl.CDR;
import us.ihmc.robotDataLogger.Handshake;
import us.ihmc.robotDataLogger.HandshakePubSubType;

public class HandshakeHashCalculator
extends CDR {
    private final MessageDigest md;
    private final ByteBuffer bytes = ByteBuffer.allocate(8);

    public static String calculateHash(Handshake handshake) {
        HandshakeHashCalculator calculator = new HandshakeHashCalculator();
        HandshakePubSubType.write(handshake, calculator);
        return calculator.getHash();
    }

    private HandshakeHashCalculator() {
        try {
            this.md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private String getHash() {
        return Base64.getEncoder().encodeToString(this.md.digest());
    }

    private void flipClearAndUpdate() {
        this.bytes.flip();
        this.md.update(this.bytes);
        this.bytes.clear();
    }

    public void write_type_1(short val) {
        this.bytes.putShort(val);
        this.flipClearAndUpdate();
    }

    public void write_type_2(int val) {
        this.bytes.putInt(val);
        this.flipClearAndUpdate();
    }

    public void write_type_5(float val) {
        this.bytes.putFloat(val);
        this.flipClearAndUpdate();
    }

    public void write_type_6(double val) {
        this.bytes.putDouble(val);
        this.flipClearAndUpdate();
    }

    public void write_type_8(char val) {
        this.bytes.putChar(val);
        this.flipClearAndUpdate();
    }

    public void write_type_9(byte val) {
        this.bytes.put(val);
        this.flipClearAndUpdate();
    }

    public void write_type_d(StringBuilder str) {
        this.write_type_2(str.length() + 1);
        for (int i = 0; i < str.length(); ++i) {
            this.bytes.put((byte)str.charAt(i));
            this.flipClearAndUpdate();
        }
    }

    public void write_type_11(long val) {
        this.bytes.putLong(val);
        this.flipClearAndUpdate();
    }

    public void write_type_15(StringBuilder str) {
        this.write_type_2(str.length());
        for (int i = 0; i < str.length(); ++i) {
            this.bytes.putChar(str.charAt(i));
            this.flipClearAndUpdate();
        }
    }
}

