/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.CameraConfiguration;
import us.ihmc.robotDataLogger.CameraType;

public class CameraConfigurationPubSubType
implements TopicDataType<CameraConfiguration> {
    public static final String name = "us::ihmc::robotDataLogger::CameraConfiguration";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "b17cf095dd34f50a65f2d4089c1236c304021dfc99d8f1583fd0bc86cd86a1d7";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(CameraConfiguration data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        CameraConfigurationPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, CameraConfiguration data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        CameraConfigurationPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return CameraConfigurationPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(CameraConfiguration data) {
        return CameraConfigurationPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(CameraConfiguration data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 1 + CDR.alignment((int)current_alignment, (int)1);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getName().length() + 1;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getIdentifier().length() + 1;
        return current_alignment - initial_alignment;
    }

    public static void write(CameraConfiguration data, CDR cdr) {
        cdr.write_type_c(data.getType().ordinal());
        cdr.write_type_9(data.getCameraId());
        if (data.getName().length() > 255) {
            throw new RuntimeException("name field exceeds the maximum length: %d > %d".formatted(data.getName().length(), 255));
        }
        cdr.write_type_d(data.getName());
        if (data.getIdentifier().length() > 255) {
            throw new RuntimeException("identifier field exceeds the maximum length: %d > %d".formatted(data.getIdentifier().length(), 255));
        }
        cdr.write_type_d(data.getIdentifier());
    }

    public static void read(CameraConfiguration data, CDR cdr) {
        data.setType(CameraType.values[cdr.read_type_c()]);
        data.setCameraId(cdr.read_type_9());
        cdr.read_type_d(data.getName());
        cdr.read_type_d(data.getIdentifier());
    }

    public final void serialize(CameraConfiguration data, InterchangeSerializer ser) {
        ser.write_type_c("type", (Enum)data.getType());
        ser.write_type_9("camera_id", data.getCameraId());
        ser.write_type_d("name", data.getName());
        ser.write_type_d("identifier", data.getIdentifier());
    }

    public final void deserialize(InterchangeSerializer ser, CameraConfiguration data) {
        data.setType((CameraType)ser.read_type_c("type", CameraType.class));
        data.setCameraId(ser.read_type_9("camera_id"));
        ser.read_type_d("name", data.getName());
        ser.read_type_d("identifier", data.getIdentifier());
    }

    public static void staticCopy(CameraConfiguration src, CameraConfiguration dest) {
        dest.set(src);
    }

    public CameraConfiguration createData() {
        return new CameraConfiguration();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)CameraConfigurationPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(CameraConfiguration data, CDR cdr) {
        CameraConfigurationPubSubType.write(data, cdr);
    }

    public void deserialize(CameraConfiguration data, CDR cdr) {
        CameraConfigurationPubSubType.read(data, cdr);
    }

    public void copy(CameraConfiguration src, CameraConfiguration dest) {
        CameraConfigurationPubSubType.staticCopy(src, dest);
    }

    public CameraConfigurationPubSubType newInstance() {
        return new CameraConfigurationPubSubType();
    }
}

