/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.compression;

import java.io.IOException;
import java.nio.ByteBuffer;
import us.ihmc.tools.compression.SnappyLibrary;

public class SnappyUtils {
    public static SnappyLibrary snappyLibrary = new SnappyLibrary();

    public static void setLibrary(SnappyLibrary library) {
        snappyLibrary = library;
    }

    public static void compress(ByteBuffer input, ByteBuffer output) throws IOException {
        int outOffset;
        byte[] out;
        int inOffset;
        byte[] in;
        int inLength;
        int length = SnappyUtils.maxCompressedLength(input.remaining());
        if (output.remaining() < length) {
            throw new IllegalArgumentException("Cannot compress to output buffer, buffer size is: " + output.remaining() + ", need " + length);
        }
        if (!input.hasArray()) {
            inLength = input.remaining();
            in = new byte[inLength];
            input.get(in);
            inOffset = 0;
        } else {
            in = input.array();
            inOffset = input.position() + input.arrayOffset();
            inLength = input.remaining();
            input.position(input.position() + input.remaining());
        }
        if (!output.hasArray()) {
            int outLength = SnappyUtils.maxCompressedLength(inLength);
            out = new byte[outLength];
            outOffset = 0;
        } else {
            out = output.array();
            outOffset = output.position() + output.arrayOffset();
        }
        int compressedSize = snappyLibrary.compress(in, inOffset, inLength, out, outOffset);
        if (!output.hasArray()) {
            output.put(out, outOffset, compressedSize);
        } else {
            output.position(output.position() + compressedSize);
        }
    }

    public static void uncompress(ByteBuffer input, ByteBuffer output) throws IllegalArgumentException, IOException {
        int outOffset;
        byte[] out;
        byte[] in;
        int inLength;
        int inOffset;
        if (!input.hasArray()) {
            inOffset = 0;
            inLength = input.remaining();
            in = new byte[inLength];
            input.get(in);
        } else {
            inOffset = input.position() + input.arrayOffset();
            inLength = input.remaining();
            in = input.array();
            input.position(input.position() + input.remaining());
        }
        if (!output.hasArray()) {
            int outLength = output.remaining();
            out = new byte[outLength];
            outOffset = 0;
        } else {
            out = output.array();
            outOffset = output.position() + output.arrayOffset();
        }
        int uncompressedSize = snappyLibrary.uncompress(in, inOffset, inLength, out, outOffset);
        if (!output.hasArray()) {
            output.put(out, outOffset, uncompressedSize);
        } else {
            output.position(output.position() + uncompressedSize);
        }
    }

    public static int maxCompressedLength(int sourceLength) {
        return snappyLibrary.maxCompressedLength(sourceLength);
    }
}

