/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.Host;

public class HostPubSubType
implements TopicDataType<Host> {
    public static final String name = "us::ihmc::robotDataLogger::Host";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "baf103896d3dc56cbce60810b7ce0bc2a8f722478377da362963af4f50e85a63";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(Host data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        HostPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, Host data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        HostPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return HostPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        current_alignment += 2 + CDR.alignment((int)current_alignment, (int)2);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += 128 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(Host data) {
        return HostPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(Host data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getHostname().length() + 1;
        current_alignment += 2 + CDR.alignment((int)current_alignment, (int)2);
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4);
        current_alignment += data.getCameras().size() * 1 + CDR.alignment((int)current_alignment, (int)1);
        return current_alignment - initial_alignment;
    }

    public static void write(Host data, CDR cdr) {
        if (data.getHostname().length() > 255) {
            throw new RuntimeException("hostname field exceeds the maximum length: %d > %d".formatted(data.getHostname().length(), 255));
        }
        cdr.write_type_d(data.getHostname());
        cdr.write_type_3(data.getPort());
        if (data.getCameras().size() > 128) {
            throw new RuntimeException("cameras field exceeds the maximum length: %d > %d".formatted(data.getCameras().size(), 128));
        }
        cdr.write_type_e((IDLSequence)data.getCameras());
    }

    public static void read(Host data, CDR cdr) {
        cdr.read_type_d(data.getHostname());
        data.setPort(cdr.read_type_3());
        cdr.read_type_e((IDLSequence)data.getCameras());
    }

    public final void serialize(Host data, InterchangeSerializer ser) {
        ser.write_type_d("hostname", data.getHostname());
        ser.write_type_3("port", data.getPort());
        ser.write_type_e("cameras", (IDLSequence)data.getCameras());
    }

    public final void deserialize(InterchangeSerializer ser, Host data) {
        ser.read_type_d("hostname", data.getHostname());
        data.setPort(ser.read_type_3("port"));
        ser.read_type_e("cameras", (IDLSequence)data.getCameras());
    }

    public static void staticCopy(Host src, Host dest) {
        dest.set(src);
    }

    public Host createData() {
        return new Host();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)HostPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(Host data, CDR cdr) {
        HostPubSubType.write(data, cdr);
    }

    public void deserialize(Host data, CDR cdr) {
        HostPubSubType.read(data, cdr);
    }

    public void copy(Host src, Host dest) {
        HostPubSubType.staticCopy(src, dest);
    }

    public HostPubSubType newInstance() {
        return new HostPubSubType();
    }
}

