/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import us.ihmc.log.LogTools;

public class UDPTimestampServer {
    public static final int TIMESTAMP_HEADER = 1563802659;
    private final Object closeLock = new Object();
    private final ByteBuffer sendDataBuffer = ByteBuffer.allocateDirect(12);
    private SocketAddress address;
    private final DatagramChannel channel = DatagramChannel.open();
    private volatile boolean active = false;

    public UDPTimestampServer() throws IOException {
        this.channel.configureBlocking(false);
    }

    public void startSending(InetAddress target, int port) {
        this.address = new InetSocketAddress(target, port);
        try {
            this.channel.connect(this.address);
            this.active = true;
        }
        catch (IOException e) {
            LogTools.warn((String)("Cannot connect UDP timestamp server to " + String.valueOf(this.address) + ": " + port + ". " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTimestamp(long timestamp) {
        if (this.active) {
            this.sendDataBuffer.clear();
            this.sendDataBuffer.putInt(1563802659);
            this.sendDataBuffer.putLong(timestamp);
            this.sendDataBuffer.flip();
            try {
                Object object = this.closeLock;
                synchronized (object) {
                    if (this.active) {
                        this.channel.write(this.sendDataBuffer);
                    }
                }
            }
            catch (PortUnreachableException e) {
                this.active = false;
            }
            catch (IOException e) {
                LogTools.warn((String)("Error sending timestamp. " + e.getMessage()));
                this.active = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.closeLock;
        synchronized (object) {
            this.active = false;
            try {
                this.channel.close();
            }
            catch (IOException e) {
                LogTools.warn((String)("Cannot close UDP timestamp server. " + e.getMessage()));
            }
        }
    }
}

