/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.util;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;

public final class LinuxSystemUptime {
    private static long systemUptimeQueryResult;
    private static long systemUptimeQueryTimeMillis;

    public static long getSystemUptime() {
        if (systemUptimeQueryTimeMillis == 0L) {
            return -1L;
        }
        long now = System.currentTimeMillis();
        long durationSinceLastQuery = now - systemUptimeQueryTimeMillis;
        return systemUptimeQueryResult + durationSinceLastQuery / 1000L;
    }

    static {
        File unixUptime;
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystemMXBean.getName().equals("Linux") && (unixUptime = new File("/proc/uptime")).exists()) {
            try {
                String systemUptimeSecondsString = FileUtils.readFileToString((File)unixUptime, (Charset)StandardCharsets.UTF_8).split("\\.")[0];
                systemUptimeQueryResult = Long.parseLong(systemUptimeSecondsString);
                systemUptimeQueryTimeMillis = System.currentTimeMillis();
            }
            catch (IOException | NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }
}

