/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.logger;

import java.io.File;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;

public class MagewellMuxer {
    private final FFmpegFrameRecorder recorder;

    public MagewellMuxer(File videoCaptureFile, int captureWidth, int captureHeight) {
        this.recorder = new FFmpegFrameRecorder(videoCaptureFile, captureWidth, captureHeight);
        this.recorder.setVideoOption("tune", "zerolatency");
        this.recorder.setFormat("mov");
        this.recorder.setVideoOption("preset", "ultrafast");
        this.recorder.setVideoOption("crf", "27");
        this.recorder.setVideoBitrate(60000000);
        this.recorder.setVideoCodec(7);
        this.recorder.setPixelFormat(0);
        this.recorder.setVideoOption("strict", "-2");
        this.recorder.setFrameRate(60.0);
    }

    public void start() throws FFmpegFrameRecorder.Exception {
        this.recorder.start();
    }

    public void recordFrame(Frame capturedFrame, long videoTimestamp) {
        if (videoTimestamp > this.recorder.getTimestamp()) {
            this.recorder.setTimestamp(videoTimestamp);
        }
        try {
            if (!this.recorder.isCloseOutputStream()) {
                this.recorder.record(capturedFrame);
            }
        }
        catch (FFmpegFrameRecorder.Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isCloseOutputStream() {
        return this.recorder.isCloseOutputStream();
    }

    public long getTimeStamp() {
        return this.recorder.getTimestamp();
    }

    public void close() {
        this.recorder.setCloseOutputStream(true);
        try {
            this.recorder.flush();
            this.recorder.stop();
        }
        catch (FFmpegFrameRecorder.Exception e) {
            throw new RuntimeException(e);
        }
    }
}

