/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.handshake;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.RemoteYoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.RemoteYoGraphicFactory;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.ArtifactList;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.EnumType;
import us.ihmc.robotDataLogger.Handshake;
import us.ihmc.robotDataLogger.JointDefinition;
import us.ihmc.robotDataLogger.LoadStatus;
import us.ihmc.robotDataLogger.ReferenceFrameInformation;
import us.ihmc.robotDataLogger.SCS1AppearanceDefinitionMessage;
import us.ihmc.robotDataLogger.SCS1YoGraphicObjectMessage;
import us.ihmc.robotDataLogger.SCS2YoGraphicDefinitionMessage;
import us.ihmc.robotDataLogger.YoRegistryDefinition;
import us.ihmc.robotDataLogger.YoType;
import us.ihmc.robotDataLogger.YoVariableDefinition;
import us.ihmc.robotDataLogger.dataBuffers.RegistrySendBufferBuilder;
import us.ihmc.robotDataLogger.handshake.SummaryProvider;
import us.ihmc.robotDataLogger.jointState.JointHolder;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicGroupDefinition;
import us.ihmc.yoVariables.parameters.ParameterLoadStatus;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoVariableHandShakeBuilder {
    private final RemoteYoGraphicFactory yoGraphicFactory = new RemoteYoGraphicFactory();
    private final Handshake handshake = new Handshake();
    private final ArrayList<JointHolder> jointHolders = new ArrayList();
    private final TObjectIntHashMap<YoVariable> yoVariableIndices = new TObjectIntHashMap();
    private final ArrayList<ImmutablePair<YoVariable, YoRegistry>> variablesAndRootRegistries = new ArrayList();
    private final TObjectIntHashMap<String> enumDescriptions = new TObjectIntHashMap();
    private int registryID = 1;
    private int enumID = 0;

    public YoVariableHandShakeBuilder(String rootRegistryName, double dt) {
        this.createRootRegistry(rootRegistryName);
        this.handshake.setDt(dt);
    }

    private void addSCS1YoGraphicObjects(YoGraphicsListRegistry yoGraphicsListRegistry) {
        if (yoGraphicsListRegistry == null) {
            return;
        }
        ArrayList yoGraphicsLists = new ArrayList();
        yoGraphicsListRegistry.getRegisteredYoGraphicsLists(yoGraphicsLists);
        for (YoGraphicsList yoGraphicsList : yoGraphicsLists) {
            for (YoGraphic yoGraphic : yoGraphicsList.getYoGraphics()) {
                if (yoGraphic instanceof RemoteYoGraphic) {
                    if (this.handshake.getGraphicObjects().remaining() == 0) {
                        throw new RuntimeException("The number of YoGraphics exceeds the maximum amount for the logger (" + this.handshake.getGraphicObjects().capacity() + ")");
                    }
                    if (!this.verifyDynamicGraphicObject((RemoteYoGraphic)yoGraphic)) continue;
                    SCS1YoGraphicObjectMessage msg = (SCS1YoGraphicObjectMessage)((Object)this.handshake.getGraphicObjects().add());
                    msg.setListName(yoGraphicsList.getLabel());
                    this.messageFromDynamicGraphicObject((RemoteYoGraphic)yoGraphic, msg);
                    continue;
                }
                System.err.println("Remote DGO not supported:  " + yoGraphic.getClass().getSimpleName());
            }
        }
        ArrayList artifactLists = new ArrayList();
        yoGraphicsListRegistry.getRegisteredArtifactLists(artifactLists);
        for (ArtifactList artifactList : artifactLists) {
            for (Artifact artifact : artifactList.getArtifacts()) {
                if (artifact instanceof RemoteYoGraphic) {
                    if (this.handshake.getArtifacts().remaining() == 0) {
                        throw new RuntimeException("The number of Artifacts exceeds the maximum amount for the logger (" + this.handshake.getArtifacts().capacity() + ")");
                    }
                    if (!this.verifyDynamicGraphicObject((RemoteYoGraphic)artifact)) continue;
                    SCS1YoGraphicObjectMessage msg = (SCS1YoGraphicObjectMessage)((Object)this.handshake.getArtifacts().add());
                    this.messageFromDynamicGraphicObject((RemoteYoGraphic)artifact, msg);
                    continue;
                }
                System.err.println("Remote artifact not supported: " + artifact.getClass().getSimpleName());
            }
        }
    }

    private void addSCS2YoGraphicDefinition(YoGraphicGroupDefinition rootDefinition) {
        if (rootDefinition == null) {
            return;
        }
        List treeFieldValueInfo = YoGraphicDefinition.exportSubtreeYoGraphicFieldsSummaryList((YoGraphicGroupDefinition)rootDefinition);
        for (YoGraphicDefinition.YoGraphicFieldsSummary yoGraphicFieldsValuesInfo : treeFieldValueInfo) {
            SCS2YoGraphicDefinitionMessage msg = (SCS2YoGraphicDefinitionMessage)((Object)this.handshake.getScs2YoGraphicDefinitions().add());
            for (YoGraphicDefinition.YoGraphicFieldInfo entry : yoGraphicFieldsValuesInfo) {
                ((StringBuilder)msg.getFieldNames().add()).append(entry.getFieldName());
                ((StringBuilder)msg.getFieldValues().add()).append(entry.getFieldValue());
            }
        }
    }

    private void addJointHolders(List<JointHolder> jointHolders) {
        for (JointHolder jointHolder : jointHolders) {
            JointDefinition jointDefinition = (JointDefinition)((Object)this.handshake.getJoints().add());
            jointDefinition.setName(jointHolder.getName());
            jointDefinition.setType(jointHolder.getJointType());
            this.jointHolders.add(jointHolder);
        }
    }

    public List<JointHolder> getJointHolders() {
        return Collections.unmodifiableList(this.jointHolders);
    }

    public int getNumberOfJointStates() {
        return RegistrySendBufferBuilder.getNumberOfJointStates(this.jointHolders);
    }

    private void createRootRegistry(String rootRegistryName) {
        YoRegistryDefinition yoRegistryDescription = (YoRegistryDefinition)((Object)this.handshake.getRegistries().add());
        yoRegistryDescription.setName(rootRegistryName);
        yoRegistryDescription.setParent(0);
    }

    public void addRegistryBuffer(RegistrySendBufferBuilder builder) {
        YoRegistry registry = builder.getYoRegistry();
        int registryID = this.addRegistry(0, registry, builder.getVariables(), registry);
        this.addSCS1YoGraphicObjects(builder.getSCS1YoGraphics());
        this.addSCS2YoGraphicDefinition(builder.getSCS2YoGraphics());
        builder.build(registryID);
        List<JointHolder> jointHolders = builder.getJointHolders();
        if (jointHolders != null && !jointHolders.isEmpty()) {
            if (!this.jointHolders.isEmpty()) {
                throw new RuntimeException("Cannot register multiple registries with joint holders");
            }
            this.addJointHolders(jointHolders);
        }
    }

    private int addRegistry(int parentID, YoRegistry registry, List<YoVariable> variableListToPack, YoRegistry rootRegistry) {
        int myID;
        if ((myID = this.registryID++) > this.handshake.getRegistries().capacity()) {
            throw new RuntimeException("The number of registries exceeds the maximum number of registries for the logger (" + this.handshake.getRegistries().capacity() + ")");
        }
        YoRegistryDefinition yoRegistryDescription = (YoRegistryDefinition)((Object)this.handshake.getRegistries().add());
        yoRegistryDescription.setName(registry.getName());
        yoRegistryDescription.setParent((short)parentID);
        this.addVariables(myID, registry, variableListToPack, rootRegistry);
        for (YoRegistry child : registry.getChildren()) {
            this.addRegistry(myID, child, variableListToPack, rootRegistry);
        }
        return myID;
    }

    private short getOrAddEnumType(String enumClass, String[] enumTypes) {
        int myID;
        if (this.enumDescriptions.containsKey((Object)enumClass)) {
            return (short)this.enumDescriptions.get((Object)enumClass);
        }
        if ((myID = this.enumID++) > this.handshake.getEnumTypes().capacity()) {
            throw new RuntimeException("The number of enum types exceeds the maximum number of enum types for the logger (" + this.handshake.getEnumTypes().capacity() + ")");
        }
        EnumType enumTypeDescription = (EnumType)((Object)this.handshake.getEnumTypes().add());
        String name = enumClass;
        if (name.length() > 255 && (name = name.substring(name.length() - 255)).startsWith(".")) {
            name = name.substring(1);
        }
        enumTypeDescription.setName(name);
        if (enumTypes.length > enumTypeDescription.getEnumValues().capacity()) {
            throw new RuntimeException("The number of enum values for " + name + " exceeds the maximum number of enum values (" + enumTypeDescription.getEnumValues().capacity() + ")");
        }
        for (String enumType : enumTypes) {
            if (enumType == null) {
                enumType = "null";
            }
            if (enumType.length() > 255) {
                enumType = enumType.substring(0, 255);
            }
            enumTypeDescription.getEnumValues().add(enumType);
        }
        this.enumDescriptions.put((Object)enumClass, myID);
        return (short)myID;
    }

    private void addVariables(int registryID, YoRegistry registry, List<YoVariable> variableListToPack, YoRegistry rootRegistry) {
        List variables = registry.getVariables();
        if (variables.size() > this.handshake.getVariables().capacity()) {
            throw new RuntimeException("The number of variables exceeds the maximum number of variables for the logger (" + this.handshake.getVariables().capacity() + ")");
        }
        for (YoVariable variable : variables) {
            YoVariableDefinition yoVariableDefinition = (YoVariableDefinition)((Object)this.handshake.getVariables().add());
            yoVariableDefinition.setName(variable.getName());
            String description = variable.getDescription();
            if (description != null && description.length() > 255) {
                description = description.substring(0, 255);
            }
            yoVariableDefinition.setDescription(description);
            yoVariableDefinition.setRegistry((short)registryID);
            yoVariableDefinition.setIsParameter(variable.isParameter());
            yoVariableDefinition.setMin(variable.getLowerBound());
            yoVariableDefinition.setMax(variable.getUpperBound());
            if (variable.isParameter()) {
                ParameterLoadStatus loadStatus = variable.getParameter().getLoadStatus();
                switch (loadStatus) {
                    case UNLOADED: {
                        yoVariableDefinition.setLoadStatus(LoadStatus.Unloaded);
                        break;
                    }
                    case DEFAULT: {
                        yoVariableDefinition.setLoadStatus(LoadStatus.Default);
                        break;
                    }
                    case LOADED: {
                        yoVariableDefinition.setLoadStatus(LoadStatus.Loaded);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown load status: " + String.valueOf(loadStatus));
                    }
                }
            } else {
                yoVariableDefinition.setLoadStatus(LoadStatus.NoParameter);
            }
            switch (variable.getType()) {
                case DOUBLE: {
                    yoVariableDefinition.setType(YoType.DoubleYoVariable);
                    break;
                }
                case INTEGER: {
                    yoVariableDefinition.setType(YoType.IntegerYoVariable);
                    break;
                }
                case BOOLEAN: {
                    yoVariableDefinition.setType(YoType.BooleanYoVariable);
                    break;
                }
                case LONG: {
                    yoVariableDefinition.setType(YoType.LongYoVariable);
                    break;
                }
                case ENUM: {
                    yoVariableDefinition.setType(YoType.EnumYoVariable);
                    if (((YoEnum)variable).isBackedByEnum()) {
                        yoVariableDefinition.setEnumType(this.getOrAddEnumType(((YoEnum)variable).getEnumType().getCanonicalName(), ((YoEnum)variable).getEnumValuesAsString()));
                    } else {
                        yoVariableDefinition.setEnumType(this.getOrAddEnumType(variable.getFullNameString() + ".EnumType", ((YoEnum)variable).getEnumValuesAsString()));
                    }
                    yoVariableDefinition.setAllowNullValues(((YoEnum)variable).isNullAllowed());
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown variable type: " + String.valueOf(variable.getType()));
                }
            }
            variableListToPack.add(variable);
            this.variablesAndRootRegistries.add((ImmutablePair<YoVariable, YoRegistry>)new ImmutablePair((Object)variable, (Object)rootRegistry));
            this.yoVariableIndices.put((Object)variable, this.variablesAndRootRegistries.size() - 1);
        }
    }

    private boolean verifyDynamicGraphicObject(RemoteYoGraphic remoteYoGraphic) {
        for (YoVariable yoVariable : remoteYoGraphic.getVariables()) {
            if (this.yoVariableIndices.containsKey((Object)yoVariable)) continue;
            LogTools.error((String)"Backing YoRegistry not added for {}, variable: {}. Disabling visualizer for {}.", (Object)remoteYoGraphic.getName(), (Object)yoVariable, (Object)remoteYoGraphic.getName());
            return false;
        }
        return true;
    }

    private void messageFromDynamicGraphicObject(RemoteYoGraphic obj, SCS1YoGraphicObjectMessage objectMessage) {
        objectMessage.setRegistrationID(this.yoGraphicFactory.getRegistrationID(obj.getClass()));
        objectMessage.setName(obj.getName());
        try {
            SCS1AppearanceDefinitionMessage sCS1AppearanceDefinitionMessage = objectMessage.getAppearance();
            sCS1AppearanceDefinitionMessage.setR(obj.getAppearance().getColor().getX());
            sCS1AppearanceDefinitionMessage.setG(obj.getAppearance().getColor().getY());
            sCS1AppearanceDefinitionMessage.setB(obj.getAppearance().getColor().getZ());
            sCS1AppearanceDefinitionMessage.setTransparency(obj.getAppearance().getTransparency());
        }
        catch (NotImplementedException notImplementedException) {
            System.err.println(notImplementedException.getMessage());
        }
        if (obj.getVariables().length > objectMessage.getYoVariableIndex().capacity()) {
            throw new RuntimeException(obj.getName() + " has too many variables. It has " + obj.getVariables().length + " variables");
        }
        for (YoVariable yoVar : obj.getVariables()) {
            if (!this.yoVariableIndices.containsKey((Object)yoVar)) {
                throw new RuntimeException("Backing YoRegistry not added for " + obj.getName() + ", variable: " + String.valueOf(yoVar));
            }
            int index = this.yoVariableIndices.get((Object)yoVar);
            objectMessage.getYoVariableIndex().add((int)((short)index));
        }
        for (double d : obj.getConstants()) {
            objectMessage.getConstants().add(d);
        }
    }

    public int getNumberOfVariables() {
        return this.variablesAndRootRegistries.size();
    }

    public ArrayList<ImmutablePair<YoVariable, YoRegistry>> getVariablesAndRootRegistries() {
        return this.variablesAndRootRegistries;
    }

    public Handshake getHandShake() {
        return this.handshake;
    }

    public void setSummaryProvider(SummaryProvider summaryProvider) {
        this.handshake.getSummary().setCreateSummary(summaryProvider.isSummarize());
        if (summaryProvider.isSummarize()) {
            this.handshake.getSummary().setSummaryTriggerVariable(summaryProvider.getSummaryTriggerVariable());
            String[] summarizedVariables = summaryProvider.getSummarizedVariables();
            for (int i = 0; i < summarizedVariables.length; ++i) {
                String var = summarizedVariables[i];
                this.handshake.getSummary().getSummarizedVariables().add(var);
            }
        }
    }

    public void setFrames(ReferenceFrame rootFrame) {
        try {
            Collection frames = ReferenceFrameTools.getAllFramesInTree((ReferenceFrame)rootFrame);
            ReferenceFrameInformation referenceFrameInformation = this.handshake.getReferenceFrameInformation();
            int i = 0;
            int packetSizeLimit = 8192;
            Iterator iterator = frames.iterator();
            while (iterator.hasNext() && i++ < packetSizeLimit) {
                ReferenceFrame frame = (ReferenceFrame)iterator.next();
                referenceFrameInformation.getFrameNames().add(frame.getName());
                referenceFrameInformation.getFrameIndices().add(frame.getFrameIndex());
            }
            if (frames.size() > packetSizeLimit) {
                LogTools.warn((String)"There are too many frames to pack! ({}) We chopped off the end.", (Object)frames.size());
            }
        }
        catch (NullPointerException nullPointerException) {
            LogTools.error((String)"Setting frames failed, most likely due to a threading violation. Frames may not be set.");
        }
    }
}

