/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.example;

import java.util.UUID;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.robotDataLogger.logger.ZEDSVOLogger;
import us.ihmc.zed.SL_InitParameters;
import us.ihmc.zed.SL_RuntimeParameters;
import us.ihmc.zed.global.zed;
import us.ihmc.zed.library.ZEDJavaAPINativeLibrary;

public class ExampleSVOLogger {
    private static final String ADDRESS = "127.0.0.1";
    private static final int PORT = 30000;
    private static final ZEDSVOLogger SVO_LOGGER = new ZEDSVOLogger();
    private static volatile boolean running = true;

    public static void main(String[] args) {
        ExampleSVOLogger.startLocalUSBSensor();
        String svoFile = System.getProperty("user.home") + "/Desktop/test" + UUID.randomUUID().toString().substring(0, 5) + ".svo2";
        SVO_LOGGER.start(svoFile, ADDRESS, 30000);
        ThreadTools.sleepForever();
    }

    public static void destroy() {
        running = false;
        SVO_LOGGER.stop();
        ExampleSVOLogger.stopLocalUSBSensor();
    }

    private static void stopLocalUSBSensor() {
        zed.sl_close_camera((int)0);
    }

    private static void startLocalUSBSensor() {
        zed.sl_create_camera((int)0);
        SL_InitParameters initParameters = new SL_InitParameters();
        initParameters.camera_fps(30);
        initParameters.resolution(5);
        initParameters.input_type(0);
        initParameters.camera_device_id(0);
        int state = zed.sl_open_camera((int)0, (SL_InitParameters)initParameters, (int)0, (String)"", (String)"", (int)0, (String)"", (String)"", (String)"");
        zed.sl_enable_streaming((int)0, (int)0, (int)8000, (short)30000, (int)-1, (int)0, (int)16084, (int)30);
        if (state != 0) {
            throw new RuntimeException("Could not initialize ZED");
        }
        SL_RuntimeParameters runtimeParameters = new SL_RuntimeParameters();
        runtimeParameters.enable_depth(true);
        Thread imageGrabThread = new Thread(() -> {
            while (running) {
                zed.sl_grab((int)0, (SL_RuntimeParameters)runtimeParameters);
            }
        }, "ImageGrabThread");
        imageGrabThread.start();
    }

    static {
        ZEDJavaAPINativeLibrary.load();
        Runtime.getRuntime().addShutdownHook(new Thread(ExampleSVOLogger::destroy));
    }
}

