/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.dataBuffers;

import java.nio.ByteBuffer;
import java.util.Arrays;
import us.ihmc.robotDataLogger.dataBuffers.RegistryBuffer;

public class RegistryReceiveBuffer
extends RegistryBuffer {
    private final long receivedTimestamp;
    private ByteBuffer compressedVariableDataBuffer;
    private double[] jointStates;

    public RegistryReceiveBuffer(long receivedTimestamp) {
        this.receivedTimestamp = receivedTimestamp;
    }

    public long getReceivedTimestamp() {
        return this.receivedTimestamp;
    }

    public ByteBuffer allocateBuffer(int size) {
        this.compressedVariableDataBuffer = ByteBuffer.allocate(size);
        return this.compressedVariableDataBuffer;
    }

    public double[] allocateStates(int stateLength) {
        this.jointStates = new double[stateLength];
        return this.jointStates;
    }

    public double[] getJointStates() {
        return this.jointStates;
    }

    public ByteBuffer getData() {
        return this.compressedVariableDataBuffer;
    }

    public String toString() {
        return "RegistryReceiveBuffer [receivedTimestamp=" + this.receivedTimestamp + ", compressedVariableDataBuffer=" + String.valueOf(this.compressedVariableDataBuffer) + ", registryID=" + this.registryID + ", jointStates=" + Arrays.toString(this.jointStates) + ", timestamp=" + this.timestamp + ", uid=" + this.uid + "]";
    }
}

