/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.publisher.logger.utils.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ListView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import us.ihmc.log.LogTools;
import us.ihmc.publisher.logger.utils.DeployConsoleInterface;

public class FXConsole
implements DeployConsoleInterface {
    private final Stage dialog = new Stage();
    private final ObservableList<String> outputValues = FXCollections.observableArrayList();
    private final ListView<String> output = new ListView(this.outputValues);
    private final FileChooser fileChooser = new FileChooser();
    private final Button close = new Button("Close");
    private final CheckBox closeWhenFinished = new CheckBox("Close when finished");
    private int clients = 0;

    public FXConsole(Stage parent) {
        this.dialog.initOwner((Window)parent);
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.setTitle("Status");
        this.dialog.setOnCloseRequest(e -> {
            if (this.clients > 0) {
                e.consume();
            }
        });
        Button exportOutput = new Button("Export output");
        exportOutput.setOnAction(e -> this.exportOutput());
        this.close.setOnAction(e -> this.tryClose());
        HBox hbox = new HBox(10.0, new Node[]{exportOutput, this.close});
        VBox vbox = new VBox(10.0, new Node[]{this.output, this.closeWhenFinished, hbox});
        VBox.setVgrow(this.output, (Priority)Priority.ALWAYS);
        vbox.setPadding(new Insets(10.0));
        Scene scene = new Scene((Parent)vbox, 800.0, 600.0);
        this.dialog.setScene(scene);
        this.fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
    }

    private void exportOutput() {
        LogTools.info((String)"Exporting output");
        File target = this.fileChooser.showSaveDialog((Window)this.dialog);
        if (target != null) {
            try {
                PrintWriter pw = new PrintWriter(target);
                for (String line : this.outputValues) {
                    pw.println(line);
                }
                pw.close();
            }
            catch (FileNotFoundException e) {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Cannot write log");
                alert.setHeaderText(e.getMessage());
                alert.showAndWait();
            }
        }
    }

    @Override
    public void replaceln(String line) {
        Platform.runLater(() -> this.outputValues.set(this.outputValues.size() - 1, (Object)line));
    }

    @Override
    public void println(String line) {
        Platform.runLater(() -> {
            this.outputValues.add((Object)line);
            this.output.scrollTo(this.outputValues.size() - 1);
        });
    }

    private void tryClose() {
        if (this.clients <= 0) {
            this.dialog.close();
        }
    }

    private void closePlatform() {
        --this.clients;
        if (this.clients <= 0) {
            this.close.setDisable(false);
            if (this.closeWhenFinished.isSelected()) {
                this.dialog.close();
            }
        }
    }

    @Override
    public void close() {
        Platform.runLater(() -> this.closePlatform());
    }

    @Override
    public void closeWithMessage(String message) {
        Platform.runLater(() -> {
            this.println(message);
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("Success");
            alert.setHeaderText(message);
            alert.showAndWait();
            this.closePlatform();
        });
    }

    @Override
    public void closeWithError(Exception e, String errorMessage) {
        Platform.runLater(() -> {
            if (errorMessage != null) {
                this.println("[Exception] " + errorMessage);
            }
            if (e != null) {
                this.println("[Exception] " + e.getMessage());
                for (StackTraceElement el : e.getStackTrace()) {
                    this.println("[Exception] " + el.toString());
                }
            }
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Error");
            alert.setHeaderText(e.getMessage());
            if (errorMessage != null) {
                alert.setContentText(errorMessage);
            } else {
                alert.setContentText(e.getStackTrace()[0].toString());
            }
            alert.showAndWait();
            this.closePlatform();
        });
    }

    @Override
    public void open() {
        Platform.runLater(() -> {
            ++this.clients;
            this.close.setDisable(true);
            this.dialog.show();
        });
    }
}

