/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.util.function.Supplier;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.interfaces.EpsilonComparable;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.idl.IDLSequence;
import us.ihmc.idl.IDLTools;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.robotDataLogger.EnumType;
import us.ihmc.robotDataLogger.EnumTypePubSubType;
import us.ihmc.robotDataLogger.HandshakePubSubType;
import us.ihmc.robotDataLogger.JointDefinition;
import us.ihmc.robotDataLogger.JointDefinitionPubSubType;
import us.ihmc.robotDataLogger.ReferenceFrameInformation;
import us.ihmc.robotDataLogger.ReferenceFrameInformationPubSubType;
import us.ihmc.robotDataLogger.SCS1YoGraphicObjectMessage;
import us.ihmc.robotDataLogger.SCS1YoGraphicObjectMessagePubSubType;
import us.ihmc.robotDataLogger.SCS2YoGraphicDefinitionMessage;
import us.ihmc.robotDataLogger.SCS2YoGraphicDefinitionMessagePubSubType;
import us.ihmc.robotDataLogger.Summary;
import us.ihmc.robotDataLogger.SummaryPubSubType;
import us.ihmc.robotDataLogger.YoRegistryDefinition;
import us.ihmc.robotDataLogger.YoRegistryDefinitionPubSubType;
import us.ihmc.robotDataLogger.YoVariableDefinition;
import us.ihmc.robotDataLogger.YoVariableDefinitionPubSubType;

public class Handshake
extends Packet<Handshake>
implements Settable<Handshake>,
EpsilonComparable<Handshake> {
    public double dt_;
    public IDLSequence.Object<YoRegistryDefinition> registries_ = new IDLSequence.Object(1024, (TopicDataType)new YoRegistryDefinitionPubSubType());
    public IDLSequence.Object<YoVariableDefinition> variables_ = new IDLSequence.Object(Short.MAX_VALUE, (TopicDataType)new YoVariableDefinitionPubSubType());
    public IDLSequence.Object<JointDefinition> joints_ = new IDLSequence.Object(128, (TopicDataType)new JointDefinitionPubSubType());
    public IDLSequence.Object<SCS1YoGraphicObjectMessage> graphicObjects_ = new IDLSequence.Object(2048, (TopicDataType)new SCS1YoGraphicObjectMessagePubSubType());
    public IDLSequence.Object<SCS1YoGraphicObjectMessage> artifacts_ = new IDLSequence.Object(2048, (TopicDataType)new SCS1YoGraphicObjectMessagePubSubType());
    public IDLSequence.Object<SCS2YoGraphicDefinitionMessage> scs2YoGraphicDefinitions_ = new IDLSequence.Object(2048, (TopicDataType)new SCS2YoGraphicDefinitionMessagePubSubType());
    public IDLSequence.Object<EnumType> enumTypes_ = new IDLSequence.Object(1024, (TopicDataType)new EnumTypePubSubType());
    public ReferenceFrameInformation referenceFrameInformation_ = new ReferenceFrameInformation();
    public Summary summary_ = new Summary();

    public Handshake() {
    }

    public Handshake(Handshake other) {
        this();
        this.set(other);
    }

    public void set(Handshake other) {
        this.dt_ = other.dt_;
        this.registries_.set(other.registries_);
        this.variables_.set(other.variables_);
        this.joints_.set(other.joints_);
        this.graphicObjects_.set(other.graphicObjects_);
        this.artifacts_.set(other.artifacts_);
        this.scs2YoGraphicDefinitions_.set(other.scs2YoGraphicDefinitions_);
        this.enumTypes_.set(other.enumTypes_);
        ReferenceFrameInformationPubSubType.staticCopy(other.referenceFrameInformation_, this.referenceFrameInformation_);
        SummaryPubSubType.staticCopy(other.summary_, this.summary_);
    }

    public void setDt(double dt) {
        this.dt_ = dt;
    }

    public double getDt() {
        return this.dt_;
    }

    public IDLSequence.Object<YoRegistryDefinition> getRegistries() {
        return this.registries_;
    }

    public IDLSequence.Object<YoVariableDefinition> getVariables() {
        return this.variables_;
    }

    public IDLSequence.Object<JointDefinition> getJoints() {
        return this.joints_;
    }

    public IDLSequence.Object<SCS1YoGraphicObjectMessage> getGraphicObjects() {
        return this.graphicObjects_;
    }

    public IDLSequence.Object<SCS1YoGraphicObjectMessage> getArtifacts() {
        return this.artifacts_;
    }

    public IDLSequence.Object<SCS2YoGraphicDefinitionMessage> getScs2YoGraphicDefinitions() {
        return this.scs2YoGraphicDefinitions_;
    }

    public IDLSequence.Object<EnumType> getEnumTypes() {
        return this.enumTypes_;
    }

    public ReferenceFrameInformation getReferenceFrameInformation() {
        return this.referenceFrameInformation_;
    }

    public Summary getSummary() {
        return this.summary_;
    }

    public static Supplier<HandshakePubSubType> getPubSubType() {
        return HandshakePubSubType::new;
    }

    public Supplier<TopicDataType> getPubSubTypePacket() {
        return HandshakePubSubType::new;
    }

    public boolean epsilonEquals(Handshake other, double epsilon) {
        int i;
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!IDLTools.epsilonEqualsPrimitive((double)this.dt_, (double)other.dt_, (double)epsilon)) {
            return false;
        }
        if (this.registries_.size() != other.registries_.size()) {
            return false;
        }
        for (i = 0; i < this.registries_.size(); ++i) {
            if (((YoRegistryDefinition)((Object)this.registries_.get(i))).epsilonEquals((YoRegistryDefinition)((Object)other.registries_.get(i)), epsilon)) continue;
            return false;
        }
        if (this.variables_.size() != other.variables_.size()) {
            return false;
        }
        for (i = 0; i < this.variables_.size(); ++i) {
            if (((YoVariableDefinition)((Object)this.variables_.get(i))).epsilonEquals((YoVariableDefinition)((Object)other.variables_.get(i)), epsilon)) continue;
            return false;
        }
        if (this.joints_.size() != other.joints_.size()) {
            return false;
        }
        for (i = 0; i < this.joints_.size(); ++i) {
            if (((JointDefinition)((Object)this.joints_.get(i))).epsilonEquals((JointDefinition)((Object)other.joints_.get(i)), epsilon)) continue;
            return false;
        }
        if (this.graphicObjects_.size() != other.graphicObjects_.size()) {
            return false;
        }
        for (i = 0; i < this.graphicObjects_.size(); ++i) {
            if (((SCS1YoGraphicObjectMessage)((Object)this.graphicObjects_.get(i))).epsilonEquals((SCS1YoGraphicObjectMessage)((Object)other.graphicObjects_.get(i)), epsilon)) continue;
            return false;
        }
        if (this.artifacts_.size() != other.artifacts_.size()) {
            return false;
        }
        for (i = 0; i < this.artifacts_.size(); ++i) {
            if (((SCS1YoGraphicObjectMessage)((Object)this.artifacts_.get(i))).epsilonEquals((SCS1YoGraphicObjectMessage)((Object)other.artifacts_.get(i)), epsilon)) continue;
            return false;
        }
        if (this.scs2YoGraphicDefinitions_.size() != other.scs2YoGraphicDefinitions_.size()) {
            return false;
        }
        for (i = 0; i < this.scs2YoGraphicDefinitions_.size(); ++i) {
            if (((SCS2YoGraphicDefinitionMessage)((Object)this.scs2YoGraphicDefinitions_.get(i))).epsilonEquals((SCS2YoGraphicDefinitionMessage)((Object)other.scs2YoGraphicDefinitions_.get(i)), epsilon)) continue;
            return false;
        }
        if (this.enumTypes_.size() != other.enumTypes_.size()) {
            return false;
        }
        for (i = 0; i < this.enumTypes_.size(); ++i) {
            if (((EnumType)((Object)this.enumTypes_.get(i))).epsilonEquals((EnumType)((Object)other.enumTypes_.get(i)), epsilon)) continue;
            return false;
        }
        if (!this.referenceFrameInformation_.epsilonEquals(other.referenceFrameInformation_, epsilon)) {
            return false;
        }
        return this.summary_.epsilonEquals(other.summary_, epsilon);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Handshake)) {
            return false;
        }
        Handshake otherMyClass = (Handshake)((Object)other);
        if (this.dt_ != otherMyClass.dt_) {
            return false;
        }
        if (!this.registries_.equals(otherMyClass.registries_)) {
            return false;
        }
        if (!this.variables_.equals(otherMyClass.variables_)) {
            return false;
        }
        if (!this.joints_.equals(otherMyClass.joints_)) {
            return false;
        }
        if (!this.graphicObjects_.equals(otherMyClass.graphicObjects_)) {
            return false;
        }
        if (!this.artifacts_.equals(otherMyClass.artifacts_)) {
            return false;
        }
        if (!this.scs2YoGraphicDefinitions_.equals(otherMyClass.scs2YoGraphicDefinitions_)) {
            return false;
        }
        if (!this.enumTypes_.equals(otherMyClass.enumTypes_)) {
            return false;
        }
        if (!this.referenceFrameInformation_.equals((Object)otherMyClass.referenceFrameInformation_)) {
            return false;
        }
        return this.summary_.equals((Object)otherMyClass.summary_);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Handshake {");
        builder.append("dt=");
        builder.append(this.dt_);
        builder.append(", ");
        builder.append("registries=");
        builder.append(this.registries_);
        builder.append(", ");
        builder.append("variables=");
        builder.append(this.variables_);
        builder.append(", ");
        builder.append("joints=");
        builder.append(this.joints_);
        builder.append(", ");
        builder.append("graphicObjects=");
        builder.append(this.graphicObjects_);
        builder.append(", ");
        builder.append("artifacts=");
        builder.append(this.artifacts_);
        builder.append(", ");
        builder.append("scs2YoGraphicDefinitions=");
        builder.append(this.scs2YoGraphicDefinitions_);
        builder.append(", ");
        builder.append("enumTypes=");
        builder.append(this.enumTypes_);
        builder.append(", ");
        builder.append("referenceFrameInformation=");
        builder.append((Object)this.referenceFrameInformation_);
        builder.append(", ");
        builder.append("summary=");
        builder.append((Object)this.summary_);
        builder.append("}");
        return builder.toString();
    }
}

