/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger;

import java.io.IOException;
import us.ihmc.idl.CDR;
import us.ihmc.idl.InterchangeSerializer;
import us.ihmc.pubsub.TopicDataType;
import us.ihmc.pubsub.common.SerializedPayload;
import us.ihmc.robotDataLogger.ClearLogRequest;

public class ClearLogRequestPubSubType
implements TopicDataType<ClearLogRequest> {
    public static final String name = "us::ihmc::robotDataLogger::ClearLogRequest";
    private final CDR serializeCDR = new CDR();
    private final CDR deserializeCDR = new CDR();

    public final String getDefinitionChecksum() {
        return "a8884f5c6d27c0aca20011f680b6d9de1dfb33464e6a527d63a8202455a8cc98";
    }

    public final String getDefinitionVersion() {
        return "local";
    }

    public void serialize(ClearLogRequest data, SerializedPayload serializedPayload) throws IOException {
        this.serializeCDR.serialize(serializedPayload);
        ClearLogRequestPubSubType.write(data, this.serializeCDR);
        this.serializeCDR.finishSerialize();
    }

    public void deserialize(SerializedPayload serializedPayload, ClearLogRequest data) throws IOException {
        this.deserializeCDR.deserialize(serializedPayload);
        ClearLogRequestPubSubType.read(data, this.deserializeCDR);
        this.deserializeCDR.finishDeserialize();
    }

    public static int getMaxCdrSerializedSize() {
        return ClearLogRequestPubSubType.getMaxCdrSerializedSize(0);
    }

    public static int getMaxCdrSerializedSize(int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + 255 + 1;
        return current_alignment - initial_alignment;
    }

    public static final int getCdrSerializedSize(ClearLogRequest data) {
        return ClearLogRequestPubSubType.getCdrSerializedSize(data, 0);
    }

    public static final int getCdrSerializedSize(ClearLogRequest data, int current_alignment) {
        int initial_alignment = current_alignment;
        current_alignment += 4 + CDR.alignment((int)current_alignment, (int)4) + data.getGuid().length() + 1;
        return current_alignment - initial_alignment;
    }

    public static void write(ClearLogRequest data, CDR cdr) {
        if (data.getGuid().length() > 255) {
            throw new RuntimeException("guid field exceeds the maximum length");
        }
        cdr.write_type_d(data.getGuid());
    }

    public static void read(ClearLogRequest data, CDR cdr) {
        cdr.read_type_d(data.getGuid());
    }

    public final void serialize(ClearLogRequest data, InterchangeSerializer ser) {
        ser.write_type_d("guid", data.getGuid());
    }

    public final void deserialize(InterchangeSerializer ser, ClearLogRequest data) {
        ser.read_type_d("guid", data.getGuid());
    }

    public static void staticCopy(ClearLogRequest src, ClearLogRequest dest) {
        dest.set(src);
    }

    public ClearLogRequest createData() {
        return new ClearLogRequest();
    }

    public int getTypeSize() {
        return CDR.getTypeSize((int)ClearLogRequestPubSubType.getMaxCdrSerializedSize());
    }

    public String getName() {
        return name;
    }

    public void serialize(ClearLogRequest data, CDR cdr) {
        ClearLogRequestPubSubType.write(data, cdr);
    }

    public void deserialize(ClearLogRequest data, CDR cdr) {
        ClearLogRequestPubSubType.read(data, cdr);
    }

    public void copy(ClearLogRequest src, ClearLogRequest dest) {
        ClearLogRequestPubSubType.staticCopy(src, dest);
    }

    public ClearLogRequestPubSubType newInstance() {
        return new ClearLogRequestPubSubType();
    }
}

