/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.logger;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.log.LogTools;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoVariableSummarizer {
    private static final int VariableOffset = 1;
    private final int trigger;
    private final YoVariable triggerVariable;
    private final YoVariableSummarizerData[] variables;
    private LongBuffer buffer;

    public YoVariableSummarizer(List<YoVariable> yoVariables, String triggerVariable, String[] variables) {
        this.trigger = this.getYoVariable(yoVariables, triggerVariable);
        if (this.trigger == -1) {
            LogTools.error((String)"No trigger variable found. Summarizing all data points.");
        }
        this.triggerVariable = yoVariables.get(this.trigger);
        LogTools.debug((String)("Creating summary of variables.\nTrigger Variable = " + this.triggerVariable.getName()));
        ArrayList<YoVariableSummarizerData> summaryVariables = new ArrayList<YoVariableSummarizerData>();
        for (String variable : variables) {
            int summaryVariable = this.getYoVariable(yoVariables, variable);
            if (summaryVariable == -1) {
                LogTools.error((String)("Cannot find variable " + variable + " for summarizing."));
                continue;
            }
            summaryVariables.add(new YoVariableSummarizerData(summaryVariable, yoVariables.get(summaryVariable)));
        }
        this.variables = summaryVariables.toArray(new YoVariableSummarizerData[summaryVariables.size()]);
    }

    private void updateVariable(int offset, YoVariable variable) {
        variable.setValueFromLongBits(this.buffer.get(offset + 1), false);
    }

    public int getYoVariable(List<YoVariable> yoVariables, String name) {
        for (int i = 0; i < yoVariables.size(); ++i) {
            if (!yoVariables.get(i).getFullNameString().endsWith(name)) continue;
            return i;
        }
        return -1;
    }

    public void update() {
        if (this.triggerVariable != null) {
            this.updateVariable(this.trigger, this.triggerVariable);
            if (this.triggerVariable.isZero()) {
                return;
            }
        }
        for (YoVariableSummarizerData data : this.variables) {
            data.update();
        }
    }

    public void writeData(File file) {
        try {
            PrintWriter writer = new PrintWriter(file);
            writer.print("namespace");
            writer.print(',');
            writer.print("name");
            writer.print(',');
            writer.print("minimum");
            writer.print(',');
            writer.print("maximum");
            writer.print(',');
            writer.print("average");
            writer.print(',');
            writer.print("delta");
            writer.println();
            for (YoVariableSummarizerData data : this.variables) {
                data.writeCSV(writer);
            }
            writer.flush();
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void restart() {
        for (YoVariableSummarizerData data : this.variables) {
            data.clear();
        }
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer.asLongBuffer();
    }

    private class YoVariableSummarizerData {
        private final int variableOffset;
        private final YoVariable variable;
        private double minimum;
        private double maximum;
        private double average;
        private long samples;

        public YoVariableSummarizerData(int variableOffset, YoVariable variable) {
            this.variableOffset = variableOffset;
            this.variable = variable;
            this.clear();
        }

        public void update() {
            YoVariableSummarizer.this.updateVariable(this.variableOffset, this.variable);
            if (this.variable.getValueAsDouble() < this.minimum) {
                this.minimum = this.variable.getValueAsDouble();
            }
            if (this.variable.getValueAsDouble() > this.maximum) {
                this.maximum = this.variable.getValueAsDouble();
            }
            ++this.samples;
            this.average += (this.variable.getValueAsDouble() - this.average) / (double)this.samples;
        }

        public void writeCSV(PrintWriter writer) {
            writer.print(this.variable.getNamespace());
            writer.print(',');
            writer.print(this.variable.getName());
            writer.print(',');
            writer.print(this.minimum);
            writer.print(',');
            writer.print(this.maximum);
            writer.print(',');
            writer.print(this.average);
            writer.print(',');
            writer.print(this.maximum - this.minimum);
            writer.println();
        }

        public void clear() {
            this.minimum = Double.POSITIVE_INFINITY;
            this.maximum = Double.NEGATIVE_INFINITY;
            this.average = 0.0;
            this.samples = 0L;
        }
    }
}

