/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.handshake;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ProtocolStringList;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import us.ihmc.commons.PrintTools;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearanceRGBColor;
import us.ihmc.graphicsDescription.color.MutableColor;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.RemoteYoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.plotting.ArtifactList;
import us.ihmc.robotDataLogger.Handshake;
import us.ihmc.robotDataLogger.JointType;
import us.ihmc.robotDataLogger.handshake.YoVariableHandshakeParser;
import us.ihmc.robotDataLogger.handshake.generated.YoProtoHandshakeProto;
import us.ihmc.robotDataLogger.jointState.JointState;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

@Deprecated
public class ProtoBufferYoVariableHandshakeParser
extends YoVariableHandshakeParser {
    ProtoBufferYoVariableHandshakeParser() {
    }

    private static JointType convertJointType(YoProtoHandshakeProto.YoProtoHandshake.JointDefinition.JointType type) {
        switch (type) {
            case OneDoFJoint: {
                return JointType.OneDoFJoint;
            }
            case SiXDoFJoint: {
                return JointType.SiXDoFJoint;
            }
        }
        throw new RuntimeException();
    }

    private static YoProtoHandshakeProto.YoProtoHandshake parseYoProtoHandshake(byte[] handShake) {
        try {
            return YoProtoHandshakeProto.YoProtoHandshake.parseFrom(handShake);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void parseFrom(byte[] handShake) {
        YoProtoHandshakeProto.YoProtoHandshake yoProtoHandshake = ProtoBufferYoVariableHandshakeParser.parseYoProtoHandshake(handShake);
        this.dt = yoProtoHandshake.getDt();
        List<YoRegistry> regs = ProtoBufferYoVariableHandshakeParser.parseRegistries(yoProtoHandshake);
        this.registries.clear();
        this.registries.addAll(regs);
        List<YoVariable> vars = ProtoBufferYoVariableHandshakeParser.parseVariables(yoProtoHandshake, regs);
        this.variables.clear();
        this.variables.addAll(vars);
        this.addJointStates(yoProtoHandshake);
        this.addGraphicObjects(yoProtoHandshake);
        int numberOfVariables = yoProtoHandshake.getVariableCount();
        int numberOfJointStateVariables = this.getNumberOfJointStateVariables(yoProtoHandshake);
        this.stateVariables = 1 + numberOfVariables + numberOfJointStateVariables;
    }

    private static List<YoRegistry> parseRegistries(YoProtoHandshakeProto.YoProtoHandshake yoProtoHandshake) {
        YoProtoHandshakeProto.YoProtoHandshake.YoRegistryDefinition rootDefinition = yoProtoHandshake.getRegistry(0);
        YoRegistry rootRegistry = new YoRegistry(rootDefinition.getName());
        ArrayList<YoRegistry> registryList = new ArrayList<YoRegistry>();
        registryList.add(rootRegistry);
        for (int i = 1; i < yoProtoHandshake.getRegistryCount(); ++i) {
            YoProtoHandshakeProto.YoProtoHandshake.YoRegistryDefinition registryDefinition = yoProtoHandshake.getRegistry(i);
            YoRegistry registry = new YoRegistry(registryDefinition.getName());
            registryList.add(registry);
            ((YoRegistry)registryList.get(registryDefinition.getParent())).addChild(registry);
        }
        return registryList;
    }

    private static List<YoVariable> parseVariables(YoProtoHandshakeProto.YoProtoHandshake yoProtoHandshake, List<YoRegistry> registryList) {
        ArrayList<YoVariable> variableList = new ArrayList<YoVariable>();
        block7: for (YoProtoHandshakeProto.YoProtoHandshake.YoVariableDefinition yoVariableDefinition : yoProtoHandshake.getVariableList()) {
            String name = yoVariableDefinition.getName();
            int registryIndex = yoVariableDefinition.getRegistry();
            YoRegistry parent = registryList.get(registryIndex);
            YoProtoHandshakeProto.YoProtoHandshake.YoVariableDefinition.YoProtoType type = yoVariableDefinition.getType();
            switch (type) {
                case DoubleYoVariable: {
                    YoDouble doubleVar = new YoDouble(name, parent);
                    variableList.add((YoVariable)doubleVar);
                    continue block7;
                }
                case IntegerYoVariable: {
                    YoInteger intVar = new YoInteger(name, parent);
                    variableList.add((YoVariable)intVar);
                    continue block7;
                }
                case BooleanYoVariable: {
                    YoBoolean boolVar = new YoBoolean(name, parent);
                    variableList.add((YoVariable)boolVar);
                    continue block7;
                }
                case LongYoVariable: {
                    YoLong longVar = new YoLong(name, parent);
                    variableList.add((YoVariable)longVar);
                    continue block7;
                }
                case EnumYoVariable: {
                    ProtocolStringList values = yoVariableDefinition.getEnumValuesList();
                    String[] names = values.toArray(new String[values.size()]);
                    boolean allowNullValues = !yoVariableDefinition.hasAllowNullValues() || yoVariableDefinition.getAllowNullValues();
                    YoEnum enumVar = new YoEnum(name, "", parent, allowNullValues, names);
                    variableList.add((YoVariable)enumVar);
                    continue block7;
                }
            }
            throw new RuntimeException("Unknown YoVariable type: " + type.name());
        }
        return variableList;
    }

    private int getNumberOfJointStateVariables(YoProtoHandshakeProto.YoProtoHandshake yoProtoHandshake) {
        int numberOfJointStates = 0;
        for (int i = 0; i < yoProtoHandshake.getJointCount(); ++i) {
            YoProtoHandshakeProto.YoProtoHandshake.JointDefinition joint = yoProtoHandshake.getJoint(i);
            numberOfJointStates += JointState.getNumberOfVariables(ProtoBufferYoVariableHandshakeParser.convertJointType(joint.getType()));
        }
        return numberOfJointStates;
    }

    private void addJointStates(YoProtoHandshakeProto.YoProtoHandshake yoProtoHandshake) {
        for (int i = 0; i < yoProtoHandshake.getJointCount(); ++i) {
            YoProtoHandshakeProto.YoProtoHandshake.JointDefinition joint = yoProtoHandshake.getJoint(i);
            this.jointStates.add(JointState.createJointState(joint.getName(), ProtoBufferYoVariableHandshakeParser.convertJointType(joint.getType())));
        }
    }

    private void addGraphicObjects(YoProtoHandshakeProto.YoProtoHandshake yoProtoHandshake) {
        HashMap<String, YoGraphicsList> dgoListMap = new HashMap<String, YoGraphicsList>();
        for (int i = 0; i < yoProtoHandshake.getGraphicObjectCount(); ++i) {
            YoGraphicsList dgoList;
            String listName = "default";
            if (yoProtoHandshake.getGraphicObject(i).hasListName() && !yoProtoHandshake.getGraphicObject(i).getListName().isEmpty()) {
                listName = yoProtoHandshake.getGraphicObject(i).getListName();
            }
            if (dgoListMap.containsKey(listName)) {
                dgoList = (YoGraphicsList)dgoListMap.get(listName);
            } else {
                dgoList = new YoGraphicsList(listName);
                dgoListMap.put(listName, dgoList);
            }
            try {
                dgoList.add((YoGraphic)this.getRemoteGraphic(yoProtoHandshake.getGraphicObject(i)));
                continue;
            }
            catch (Exception e) {
                PrintTools.error((Object)this, (String)("Got exception: " + e.getClass().getSimpleName() + " when loading a YoGraphic."));
            }
        }
        for (String list : dgoListMap.keySet()) {
            this.scs1YoGraphics.registerYoGraphicsList((YoGraphicsList)dgoListMap.get(list));
        }
        ArtifactList artifactList = new ArtifactList("remote");
        for (int i = 0; i < yoProtoHandshake.getArtifactCount(); ++i) {
            try {
                artifactList.add((Artifact)this.getRemoteGraphic(yoProtoHandshake.getArtifact(i)));
                continue;
            }
            catch (Exception e) {
                PrintTools.error((Object)this, (String)("Got exception: " + e.getClass().getSimpleName() + " when loading a Artifact."));
            }
        }
        this.scs1YoGraphics.registerArtifactList(artifactList);
    }

    private RemoteYoGraphic getRemoteGraphic(YoProtoHandshakeProto.YoProtoHandshake.DynamicGraphicMessage msg) {
        int registrationID = msg.getType();
        String name = msg.getName();
        YoVariable[] vars = new YoVariable[msg.getYoIndexCount()];
        for (int v = 0; v < vars.length; ++v) {
            vars[v] = (YoVariable)this.variables.get(msg.getYoIndex(v));
        }
        double[] consts = ArrayUtils.toPrimitive((Double[])msg.getConstantList().toArray(new Double[msg.getConstantCount()]));
        YoAppearanceRGBColor appearance = new YoAppearanceRGBColor(Color.red, 0.0);
        if (msg.hasAppearance()) {
            appearance = new YoAppearanceRGBColor(new MutableColor((float)msg.getAppearance().getX(), (float)msg.getAppearance().getY(), (float)msg.getAppearance().getZ()), msg.getAppearance().getTransparency());
        }
        return this.yoGraphicFromMessage(registrationID, name, vars, consts, (AppearanceDefinition)appearance);
    }

    @Override
    public void parseFrom(Handshake handshake) throws IOException {
        throw new RuntimeException("Not implemented");
    }
}

