/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.server.discovery;

import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.List;
import us.ihmc.robotDataLogger.websocket.DataServerLocationBroadcast;

public class DataServerLocationBroadcastSender
extends DataServerLocationBroadcast {
    private volatile boolean running = true;
    private final byte[] message;
    private final Thread internalThread;

    public DataServerLocationBroadcastSender(int dataServerPort) throws IOException {
        String messageStr = DataServerLocationBroadcastSender.createMessage(dataServerPort);
        this.message = messageStr.getBytes(CharsetUtil.UTF_8);
        if (this.message.length > 1472) {
            throw new IOException("Message to big.");
        }
        this.internalThread = new Thread(this::run, this.getClass().getSimpleName());
    }

    public void start() {
        this.running = true;
        this.internalThread.start();
    }

    public void stop() {
        this.running = false;
        try {
            this.internalThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void run() {
        try {
            List<MulticastSocket> sockets = DataServerLocationBroadcastSender.getSocketChannelList(0);
            InetAddress group = InetAddress.getByName("239.255.24.1");
            DatagramPacket packet = new DatagramPacket(this.message, this.message.length, group, 55241);
            while (this.running) {
                for (int i = 0; i < sockets.size(); ++i) {
                    sockets.get(i).send(packet);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException i) {}
            }
            for (int i = 0; i < sockets.size(); ++i) {
                sockets.get(i).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException {
        new DataServerLocationBroadcastSender(8008).start();
    }
}

