/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.websocket.server;

import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.ArrayList;
import us.ihmc.robotDataLogger.websocket.server.ResizeableUnpooledUnsafeDirectByteBuf;

class RecyclingByteBufAllocator
extends AbstractByteBufAllocator {
    private static final int INITIAL_MAX_CAPACITY = 2048;
    private static final int POOL_SIZE = 128;
    private final ArrayList<ByteBuf> pool = new ArrayList(128);
    private int capacity = 2048;
    private int index = 0;
    private final ByteBufAllocator backupAllocator;

    public RecyclingByteBufAllocator(ByteBufAllocator backupAllocator) {
        super(true);
        this.refill(2048);
        this.backupAllocator = backupAllocator;
    }

    private ByteBuf add(int capacity) {
        ResizeableUnpooledUnsafeDirectByteBuf wrappedBuffer = new ResizeableUnpooledUnsafeDirectByteBuf(capacity, capacity);
        wrappedBuffer.internalNioBuffer(0, 0);
        this.pool.add((ByteBuf)wrappedBuffer);
        return wrappedBuffer;
    }

    private void refill(int capacity) {
        this.pool.clear();
        for (int i = 0; i < 128; ++i) {
            this.add(capacity);
        }
        this.capacity = capacity;
    }

    public boolean isDirectBufferPooled() {
        return false;
    }

    protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
        return this.backupAllocator.heapBuffer(initialCapacity, maxCapacity);
    }

    protected ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
        if (initialCapacity > this.capacity) {
            ByteBuf newBuf = this.backupAllocator.directBuffer(initialCapacity, maxCapacity);
            return newBuf;
        }
        for (int i = this.index; i < this.index + this.pool.size(); ++i) {
            int item = i < this.pool.size() ? i : i - this.pool.size();
            ByteBuf byteBuf = this.pool.get(item);
            if (byteBuf.refCnt() != 1) continue;
            this.index = item + 1;
            byteBuf.capacity(initialCapacity);
            byteBuf.clear();
            byteBuf.internalNioBuffer(0, 0);
            return byteBuf.retain();
        }
        throw new RuntimeException("Pool ran out of capacity. Crashing connection.");
    }

    public void release() {
        for (int i = 0; i < this.pool.size(); ++i) {
            this.pool.get(i).release();
        }
    }
}

