/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotDataLogger.logger;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.function.Consumer;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.Announcement;
import us.ihmc.robotDataLogger.YoVariableClient;
import us.ihmc.robotDataLogger.logger.YoVariableLogRotator;
import us.ihmc.robotDataLogger.logger.YoVariableLoggerListener;
import us.ihmc.robotDataLogger.logger.YoVariableLoggerOptions;
import us.ihmc.robotDataLogger.websocket.client.discovery.HTTPDataServerConnection;

public class YoVariableLogger {
    public static final int timeout = 25000;
    private final YoVariableClient client;

    public YoVariableLogger(HTTPDataServerConnection connection, YoVariableLoggerOptions options, Consumer<Announcement> doneListener) throws IOException {
        Path logDirectory = Paths.get(options.getLogDirectory(), new String[0]);
        if (!Files.exists(logDirectory, new LinkOption[0])) {
            LogTools.info((String)("Creating directory for logs in " + logDirectory));
            Files.createDirectories(logDirectory, new FileAttribute[0]);
        } else if (!Files.isDirectory(logDirectory, new LinkOption[0])) {
            throw new IOException("Desired path for storing logs is not a directory: " + logDirectory);
        }
        if (options.isRotateLogs()) {
            YoVariableLogRotator.rotate(logDirectory, options.getNumberOfLogsToKeep());
        }
        Announcement request = connection.getAnnouncement();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        Calendar calendar = Calendar.getInstance();
        String timestamp = dateFormat.format(calendar.getTime());
        File tempDirectory = new File(logDirectory.toFile(), "." + timestamp + "_" + request.getName());
        File finalDirectory = new File(logDirectory.toFile(), timestamp + "_" + request.getName());
        if (finalDirectory.exists()) {
            throw new IOException("Directory " + finalDirectory.getAbsolutePath() + " already exists");
        }
        if (tempDirectory.exists()) {
            throw new IOException("Temp directory " + finalDirectory.getAbsolutePath() + " already exists");
        }
        if (!tempDirectory.mkdir()) {
            throw new IOException("Cannot create directory " + finalDirectory.getAbsolutePath() + "\nThis is likely due to the fact your Logger storage is full... maybe get some better funding and buy some more storage hot shot");
        }
        YoVariableLoggerListener logger = new YoVariableLoggerListener(tempDirectory, finalDirectory, timestamp, request, connection.getTarget(), options, doneListener);
        this.client = new YoVariableClient(logger);
        try {
            this.client.start(25000, connection);
        }
        catch (IOException e) {
            finalDirectory.delete();
            throw e;
        }
    }
}

